<?php
class primitive_tester extends TestCase
{
	function test_file_get_contents()
	{
		$this->assertEquals( "test1\n", file_get_contents( "test1.txt" ) );
		$this->assertEquals( "test1\ntest2\n", file_get_contents( "test2.txt" ) );
	}

	function test_preg_split()
	{
		$actual = preg_split( "/#/", "123" );
		$this->assertEquals( "123", $actual[ 0 ] );
		$actual = preg_split( "/#/", "#123" );
		$this->assertEquals( "", $actual[ 0 ] );
	}

	function test_preg_replace()
	{
		$this->assertEquals( "05/10/04 18:59:24", preg_replace( "/^(..)(..)(..)(.*)$/", "$1/$2/$3$4", "051004 18:59:24" ) );
	}
}
?>
