# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'fileutils'
require 'logger'

require 'mmon/appmmon'
require 'mmon/mlogger'

module Mmon
    def self.start
        conf_file = nil
        plugin_dir = nil
        log_file = nil

        if ENV.key?('HOME')
            homedir = ENV['HOME']

            conf_file = homedir + '/.mmon/mmon_conf'
            plugin_dir = homedir + '/.mmon/plugin'
            log_file = homedir + '/.mmon/mmon.log'

            FileUtils.mkdir_p(plugin_dir)
        end

        File.rename(log_file, log_file + '.bak') if File.exist?(log_file)
        mlog = MLogger.instance
        mlog.logdev = log_file
        mlog.debug = false

        app = AppMmon.new
#        app.check_plugin(plugin_dir)

        Gtk::init_add do
            app.read_conf(conf_file)
            app.show_dialog() unless app.has_item?
        end
        Gtk::main()

        app.write_conf(conf_file)
    end
end

if __FILE__ == $0
    Mmon.start
end
