# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

class BarGraph
    def initialize(w, h)
        @x = 0
        @y = 0
        @w = w
        @h = h

        @color = nil

        @surface = create_surface(@w, @h)
    end

    def position(x, y)
        @x = x
        @y = y
    end

    def size(w, h)
        @w = w
        @h = h
        @surface = create_surface(@w, @h)
    end

    def color(*color)
        @color = color
    end

    def value(*value)
        cc = Cairo::Context.new(@surface)
        cc.operator = Cairo::OPERATOR_CLEAR
        cc.paint
        cc.operator = Cairo::OPERATOR_SOURCE
        cc.antialias = Cairo::ANTIALIAS_NONE

        x = 0
        y = 0
        w = 0
        h = @h

        value.size.times do |n|
#            puts "x:#{x} y:#{y} w:#{w} h:#{h}"

            w = value[n] * @w

            if @color.nil? || @color[n].nil?
                cc.set_source_rgba(1.0, 1.0, 1.0, 1.0)
            else
                cc.set_source_rgba(@color[n])
            end
            cc.rectangle(x, y, w, h)
            cc.fill

            x += w
        end
    end

    def render(cc)
        cc.set_source(@surface, @x, @y)
        cc.paint
    end

    private

    def create_surface(w, h)
        surface = Cairo::ImageSurface.new(Cairo::FORMAT_ARGB32, w, h)

        cc = Cairo::Context.new(surface)
        cc.operator = Cairo::OPERATOR_CLEAR
        cc.paint

        return surface
    end
end

if __FILE__ == $0

end
