#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'
require 'mmon/util'
require 'mmon/cpu'
require 'mmon/component/trend_graph'

class ItemCpu < Item
    NAME = 'CPU'

    @@color_user = Color.new(0.0, 1.0, 0.0, 0.9)
    @@color_nice = Color.new(0.0, 1.0, 1.0, 0.9)
    @@color_system = Color.new(1.0, 0.0, 1.0, 0.9)

    def initialize(mmon)
        super(mmon)

        @interval = 0.5
        @use_bg = true
        @use_fg = true
        @width = 72
        @height = 32

        @trend = TrendGraph.new(@width - 2 * 2, @height - 2 * 2)
        @trend.position(2, 2)
        @trend.color(@@color_user, @@color_nice, @@color_system)

        @cpu = Cpu.new
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg(cc, w, h)
    end

    def render_fg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render(cc, w, h)
        @trend.render(cc)
    end

    def prepare
        @cpu.read

        @trend.value(@cpu.user, @cpu.nice, @cpu.system)

        return true
    end
end

if __FILE__ == $0
    require 'mmon/appmmon'

    app = AppMmon.new
    item = ItemCpu.new(app)
    app.add_item(item)

    Gtk::main()
end
