#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'
require 'mmon/image'

class ItemTClock < Item
    include Math

    NAME = 'Test Clock'

    def initialize(parent = nil)
        super(parent)

        @item_name = 'Analog Clock'
        @interval = 5.0
        @use_bg = true

        @image = Image.new('firefox.svg', 128, 128)
        @image2 = Image.new('web-browser.svg', 128, 128)

        self.set_item_size(128, 128)

        @now = Time.now
    end

    private

    def render_mask(cc, w, h)
        @image.render(cc)
    end

    def render_bg(cc, w, h)
        @image.render(cc)
    end

    def render(cc, w, h)
        hour = @now.hour
        min = @now.min
        sec = @now.sec
        rad_h = 2.0 * PI * (hour * 3600.0 + min * 60.0 + sec) / (12.0 * 3600.0);
        rad_m = 2.0 * PI * (min * 60.0 + sec) / 3600.0;

        cc.set_source_rgba(0.3, 0.3, 0.3, 0.5)
        cc.paint

        cc.save
        cc.translate(w / 2.0, h / 2.0)
        cc.rotate(rad_m + 2.0 * PI * 270.0 / 360.0)
        cc.translate(0.0, -h / 2.0 / 10.0)
        cc.scale(0.5, 0.1)
        @image2.render(cc)
        cc.restore

        cc.save
        cc.translate(w / 2.0, h / 2.0)
        cc.rotate(rad_h + 2.0 * PI * 270.0 / 360.0)
        cc.translate(0.0, -h / 2.0 / 10.0)
        cc.scale(0.35, 0.1)
        @image2.render(cc)
        cc.restore
    end

    def prepare
        old = @now
        @now = Time.now

        return true
    end
end

if __FILE__ == $0
    item = ItemTClock.new
    item.show

    Gtk::main()
end
