#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'
require 'mmon/util'
require 'mmon/memory'
require 'mmon/component/bar_graph'

class ItemMem < Item
    NAME = 'Memory'

    @@color_used = Color.new(1.0, 0.0, 0.0, 0.9)
    @@color_buffers = Color.new(0.0, 1.0, 0.0, 0.9)
    @@color_cached = Color.new(0.0, 0.0, 1.0, 0.9)
    @@color_paged = Color.new(1.0, 0.0, 0.0, 0.9)

    def initialize(mmon)
        super(mmon)

        @interval = 1.0
        @use_bg = true
        @use_fg = true

        @width = 72
        @height = 32

        @mem = Memory.new

        @bar_mem = BarGraph.new(72 - 4, 32 / 2 - 3)
        @bar_mem.color(@@color_used, @@color_buffers, @@color_cached)
        @bar_mem.position(2, 2)

        @bar_swap = BarGraph.new(72 - 4, 32 / 2 - 3)
        @bar_swap.color(@@color_paged)
        @bar_swap.position(2, 32 / 2 + 1)
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg2(cc, w, h)
        Util.simple_fg2(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg2(cc, w, h)
    end

    def render_fg(cc, w, h)
        Util.simple_fg2(cc, w, h)
    end

    def render(cc, w, h)
        @bar_mem.render(cc)
        @bar_swap.render(cc)
    end

    def prepare
        used = 0.0
        buffers = 0.0
        cached = 0.0
        paged = 0.0

        @mem.read

        mem_total = @mem.mem_total

        unless mem_total.zero?
            used = @mem.mem_used.to_f / mem_total
            buffers = @mem.mem_buffers.to_f / mem_total
            cached = @mem.mem_cached.to_f / mem_total
        end

        @bar_mem.value(used, buffers, cached)


        unless @mem.swap_total.zero?
            paged = @mem.swap_paged.to_f / @mem.swap_total
        end

        @bar_swap.value(paged)

        return true
    end
end

if __FILE__ == $0
    require 'mmon/appmmon'

    app = AppMmon.new
    item = ItemMem.new(app)
    app.add_item(item)

    Gtk::main()
end
