#!/usr/bin/ruby
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

class CairoWindow < Gtk::Window
    def initialize
        super(Gtk::Window::TOPLEVEL)

        @width = 200 
        @height = 200 

        self.decorated = true
        self.set_default_size(@width, @height)
        self.add_events(Gdk::Event::Mask::KEY_PRESS_MASK)

        signal_connect("destroy")          { |w, e| cw_destroy(e) }
        signal_connect("expose-event")     { |w, e| cw_expose(e) }
        signal_connect("key-press-event")  { |w, e| cw_key_press(e) }
    end

    def cw_destroy(event)
        Gtk::main_quit
        true
    end

    def cw_expose(event)
        puts "draw w:#{@width} h:#{@height}"

        cc = self.window.create_cairo_context
        draw(cc, @width, @height)

        true
    end

    def cw_key_press(event)
        if event.keyval == Gdk::Keyval::GDK_Escape
            self.destroy
            true
        else
            false
        end
    end
end

    
def draw(cc, w, h)
    cc.scale(w, h)
    
    cc.operator = Cairo::OPERATOR_OVER

    cc.set_source_rgba(1.0, 1.0, 1.0, 1.0)
    cc.paint

    r = 0.25

    cc.set_source_rgba(1.0, 0.3, 0.3, 0.7)
    cc.arc(0.3, 0.5, r, 0.0, 2.0 * Math::PI)
    cc.fill

    cc.set_source_rgba(0.3, 1.0, 0.3, 0.7)
    cc.arc(0.5, 0.5, r, 0.0, 2.0 * Math::PI)
    cc.fill

    cc.set_source_rgba(0.3, 0.3, 1.0, 0.7)
    cc.arc(0.7, 0.5, r, 0.0, 2.0 * Math::PI)
    cc.fill
end

unless Gdk.cairo_available?
    puts 'cairo :: not available'
    exit
end

surface_pdf = Cairo::PDFSurface.new('Reader.pdf', 200, 200)
context_pdf = Cairo::Context.new(surface_pdf)
draw(context_pdf, 200, 200)
context_pdf.show_page
surface_pdf.finish

surface_svg = Cairo::SVGSurface.new('aaa.svg', 200, 200)
context_svg = Cairo::Context.new(surface_svg)
draw(context_svg, 200, 200)
context_svg.show_page
surface_svg.finish

window = CairoWindow.new
window.show

Gtk::main()
