#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

class TextTest < Gtk::Window
    def initialize(text = 'abc', italic = false, bold = false)
        super()
        @interval = 0
#        @font = 'Sans'
        @font = 'Bitstream Vera Sans'
#        @font = 'Sazanami Mincho'
        if italic != nil && italic == 'true'
            @slant = Cairo::FONT_SLANT_ITALIC
        else
            @slant = Cairo::FONT_SLANT_NORMAL
        end
        if bold != nil && bold == 'true'
            @weight = Cairo::FONT_WEIGHT_BOLD
        else
            @weight = Cairo::FONT_WEIGHT_NORMAL
        end

        self.set_default_size(700, 400)

        if text.nil?
            @text = 'abc'
        else
            @text = text 
        end

        signal_connect("expose-event")   { |w, e| expose(w, e) }
    end

    private

    def expose(widget, event)
        e_x = event.area.x
        e_y = event.area.y
        e_w = event.area.width
        e_h = event.area.height

        cc = self.window.create_cairo_context
        cc.operator = Cairo::OPERATOR_CLEAR
        cc.paint

        cc.operator = Cairo::OPERATOR_OVER

        w, h = self.window.size
        render(cc, w, h)
    end

    def render(cc, w, h)
        cc.set_source_rgb(0.8, 0.8, 0.8)
        cc.paint

        cc.select_font_face(@font, @slant, @weight);
        cc.set_font_size(200)

        extents = cc.text_extents(@text)
        x_bearing = extents.x_bearing
        y_bearing = extents.y_bearing
        width     = extents.width
        height    = extents.height
        x_advance = extents.x_advance
        y_advance = extents.y_advance

        fext = cc.font_extents()
        f_ascent = fext.ascent
        f_descent = fext.descent
        f_height = fext.height
        f_max_x_advance = fext.max_x_advance
        f_max_y_advance = fext.max_y_advance

        show_extents(extents, fext)

        x0 = 40 
        y0 = 300 

=begin
    x0, y0 : cairo に指示する文字列の表示位置。この位置がベースラインになる。
             文字列の周囲には余白が取られるため、x0 と文字列の左端は一致しない。

    x_bearing, y_bearing : 文字列の左上がはじまる位置。(x0, y0) からの相対位置で表現される。

    width, height : 文字列の幅と高さ。周囲の余白は含まない。
=end

        # ベースライン
        cc.set_source_rgb(0.0, 0.0, 0.0)
        cc.move_to(0, y0)
        cc.line_to(700, y0)
        cc.stroke

        # 文字列
        cc.set_source_rgb(0.0, 0.0, 0.0)
        cc.move_to(x0, y0)
        cc.show_text(@text);

        # 指示位置
        cc.set_source_rgba(1.0, 0.0, 0.0, 0.7)
        cc.arc(x0, y0, 6, 0, 2 * Math::PI)
        cc.fill

        # 文字列の左上
        bx = x0 + x_bearing
        by = y0 + y_bearing
        cc.set_source_rgba(0.0, 0.0, 1.0, 0.7)
        cc.arc(bx, by, 6, 0, 2 * Math::PI)
        cc.fill

        # 文字列の表示範囲 
        cc.set_source_rgba(0.0, 0.0, 1.0, 0.7)
        cc.set_line_width(2.0)
        cc.rectangle(bx, by, width, height)
        cc.stroke

        # 次の文字列を描画する位置までの距離
        cc.set_source_rgba(0.0, 1.0, 0.0, 0.7)
        cc.set_line_width(5.0)
        cc.rectangle(x0, y0, x_advance, y_advance)
        cc.stroke

    end

    def show_extents(extents, fext)
        puts 'x_bearing ' + extents.x_bearing.to_s
        puts 'y_bearing ' + extents.y_bearing.to_s
        puts 'width     ' + extents.width.to_s
        puts 'height    ' + extents.height.to_s
        puts 'x_advance ' + extents.x_advance.to_s
        puts 'y_advance ' + extents.y_advance.to_s
        puts ''
        puts 'ascent        ' + fext.ascent.to_s
        puts 'descent       ' + fext.descent.to_s
        puts 'height        ' + fext.height.to_s
        puts 'max_x_advance ' + fext.max_x_advance.to_s
        puts 'max_y_advance ' + fext.max_y_advance.to_s
    end
end

if __FILE__ == $0
    item = TextTest.new(ARGV[0], ARGV[1], ARGV[2])
    item.show

    Gtk::main()
end
