/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt.swingui;

import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.image.Texture;
import com.jme.input.InputHandler;
import com.jme.input.KeyInput;
import com.jme.input.MouseInput;
import com.jme.input.action.InputAction;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jmex.awt.input.AWTKeyInput;
import com.jmex.awt.input.AWTMouseInput;
import com.jmex.awt.swingui.ImageGraphics;
import com.jmex.awt.swingui.dnd.JMEDragAndDrop;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class JMEDesktop
extends Quad {
    private static final Logger logger = Logger.getLogger(JMEDesktop.class.getName());
    private static final long serialVersionUID = 1L;
    private ImageGraphics graphics;
    private JDesktopPane desktop;
    private Texture texture;
    private boolean initialized;
    private int width;
    private int height;
    private boolean showingJFrame = false;
    private final Frame awtWindow;
    private int desktopWidth;
    private int desktopHeight;
    private static final int DOUBLE_CLICK_TIME = 300;
    private final InputHandler inputHandler;
    private XUpdateAction xUpdateAction;
    private YUpdateAction yUpdateAction;
    private WheelUpdateAction wheelUpdateAction;
    private ButtonAction allButtonsUpdateAction;
    private InputAction keyUpdateAction;
    private JMEDragAndDrop dragAndDropSupport;
    private static int desktopsUsed = 0;
    private boolean synchronizingThreadsOnUpdate;
    private static Int anInt = new Int(0);
    private Map<Int, Char> characters = new HashMap<Int, Char>();
    private Component lastComponent;
    private Component grabbedMouse;
    private int grabbedMouseButton;
    private int downX = 0;
    private int downY = 0;
    private long lastClickTime = 0L;
    private int clickCount = 0;
    private static final int MAX_CLICKED_OFFSET = 4;
    private Vector2f location = new Vector2f();
    private boolean useConvertPoint = true;
    private boolean focusCleared = false;
    private int lastXin = -1;
    private int lastXout = -1;
    private int lastYin = -1;
    private int lastYout = -1;
    private Ray pickRay = new Ray();
    private Vector3f bottomLeft = new Vector3f();
    private Vector3f topLeft = new Vector3f();
    private Vector3f topRight = new Vector3f();
    private Vector3f bottomRight = new Vector3f();
    private Vector3f tuv = new Vector3f();
    private final LockRunnable paintLockRunnable = new LockRunnable();
    private Component modalComponent;

    public JMEDragAndDrop getDragAndDropSupport() {
        return this.dragAndDropSupport;
    }

    public void setDragAndDropSupport(JMEDragAndDrop jMEDragAndDrop) {
        this.dragAndDropSupport = jMEDragAndDrop;
    }

    public boolean isShowingJFrame() {
        return this.showingJFrame;
    }

    public void setShowingJFrame(boolean bl) {
        this.showingJFrame = bl;
        this.awtWindow.setVisible(bl);
        this.awtWindow.repaint();
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public JMEDesktop(String string) {
        super(string);
        this.inputHandler = new InputHandler();
        this.awtWindow = new Frame(){
            private static final long serialVersionUID = 1L;

            public boolean isShowing() {
                return true;
            }

            public boolean isVisible() {
                if (JMEDesktop.this.awtWindow.isFocusableWindow() && new Throwable().getStackTrace()[1].getMethodName().startsWith("requestFocus")) {
                    return false;
                }
                return JMEDesktop.this.initialized || super.isVisible();
            }

            public Graphics getGraphics() {
                if (!JMEDesktop.this.showingJFrame) {
                    return JMEDesktop.this.graphics == null ? super.getGraphics() : JMEDesktop.this.graphics.create();
                }
                return super.getGraphics();
            }

            public boolean isFocused() {
                return true;
            }
        };
        this.awtWindow.setFocusableWindowState(false);
        Frame frame = this.awtWindow;
        this.awtWindow.setUndecorated(true);
        JMEDesktop.dontDrawBackground(frame);
        this.desktop = new JDesktopPane(){
            private static final long serialVersionUID = 1L;

            public void paint(Graphics graphics) {
                if (!JMEDesktop.this.isShowingJFrame()) {
                    graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paint(graphics);
            }

            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        new ScrollPaneRepaintFixListener().addTo(this.desktop);
        Color color = new Color(0, 0, 0, 0);
        this.desktop.setBackground(color);
        this.desktop.setFocusable(true);
        this.desktop.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JMEDesktop.this.desktop.requestFocusInWindow();
            }
        });
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") < 0) {
            JInternalFrame jInternalFrame = new JInternalFrame();
            jInternalFrame.setUI(new BasicInternalFrameUI(jInternalFrame){

                protected void installComponents() {
                }
            });
            jInternalFrame.setOpaque(false);
            jInternalFrame.setBackground(null);
            jInternalFrame.getContentPane().setLayout(new BorderLayout());
            jInternalFrame.getContentPane().add((Component)this.desktop, "Center");
            jInternalFrame.setVisible(true);
            jInternalFrame.setBorder(null);
            frame.add(jInternalFrame);
        } else {
            frame.add((Component)this.desktop, "Center");
        }
        this.awtWindow.pack();
        RepaintManager.currentManager(null).setDoubleBufferingEnabled(false);
    }

    public JMEDesktop(String string, int n, int n2, InputHandler inputHandler) {
        this(string, n, n2, false, inputHandler);
    }

    public JMEDesktop(String string, int n, int n2, boolean bl, InputHandler inputHandler) {
        this(string);
        this.setup(n, n2, bl, inputHandler);
    }

    public void setup(int n, int n2, boolean bl, InputHandler inputHandler) {
        this.reconstruct(null, null, null, null);
        if (inputHandler != null) {
            inputHandler.addToAttachedHandlers(this.inputHandler);
        }
        if (this.initialized) {
            throw new IllegalStateException("may be called only once");
        }
        this.initialize(JMEDesktop.powerOf2SizeIfNeeded(n, bl), JMEDesktop.powerOf2SizeIfNeeded(n2, bl));
        this.width = JMEDesktop.powerOf2SizeIfNeeded(n, bl);
        this.height = JMEDesktop.powerOf2SizeIfNeeded(n2, bl);
        this.setModelBound((BoundingVolume)new OrientedBoundingBox());
        this.updateModelBound();
        this.desktop.setPreferredSize(new Dimension(n, n2));
        this.desktopWidth = n;
        this.desktopHeight = n2;
        this.awtWindow.pack();
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureState.setCorrection(1);
        this.texture = new Texture();
        this.texture.setFilter(1);
        this.texture.setMipmapState(bl ? 6 : 2);
        this.texture.setWrap(3);
        this.graphics = ImageGraphics.createInstance(this.width, this.height, bl ? 2 : 0);
        this.enableAntiAlias(this.graphics);
        this.graphics.translate((float)(this.width - n) * 0.5f, (float)(this.height - n2) * 0.5f);
        this.texture.setImage(this.graphics.getImage());
        this.texture.setScale(new Vector3f(1.0f, -1.0f, 1.0f));
        textureState.setTexture(this.texture);
        textureState.apply();
        this.setRenderState((RenderState)textureState);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setEnabled(true);
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        this.setRenderState((RenderState)alphaState);
        this.xUpdateAction = new XUpdateAction();
        this.yUpdateAction = new YUpdateAction();
        this.wheelUpdateAction = new WheelUpdateAction();
        this.wheelUpdateAction.setSpeed(AWTMouseInput.WHEEL_AMP);
        this.allButtonsUpdateAction = new ButtonAction(Integer.MIN_VALUE);
        this.keyUpdateAction = new KeyUpdateAction();
        this.setupDefaultInputBindings();
        if (desktopsUsed == 0) {
            PopupFactory.setSharedInstance(new MyPopupFactory());
        }
        ++desktopsUsed;
        this.setFocusOwner(this.desktop);
        this.initialized = true;
        this.setSynchronizingThreadsOnUpdate(true);
    }

    protected void setupDefaultInputBindings() {
        this.getInputHandler().addAction((InputActionInterface)this.getButtonUpdateAction(Integer.MIN_VALUE), "mouse", Integer.MIN_VALUE, -1, false);
        this.getInputHandler().addAction((InputActionInterface)this.getXUpdateAction(), "mouse", -1, 0, false);
        this.getInputHandler().addAction((InputActionInterface)this.getYUpdateAction(), "mouse", -1, 1, false);
        this.getInputHandler().addAction((InputActionInterface)this.getWheelUpdateAction(), "mouse", -1, 2, false);
        this.getInputHandler().addAction((InputActionInterface)this.getKeyUpdateAction(), "keyboard", Integer.MIN_VALUE, -1, false);
    }

    public void onKey(final char c, final int n, final boolean bl) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JMEDesktop.this.sendAWTKeyEvent(n, bl, c);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "onKey(character, keyCode, pressed)", "Exception", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "onKey(character, keyCode, pressed)", "Exception", invocationTargetException);
        }
    }

    public void onButton(final int n, final boolean bl, int n2, int n3) {
        this.convert(n2, n3, this.location);
        final int n4 = (int)this.location.x;
        final int n5 = (int)this.location.y;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JMEDesktop.this.sendAWTMouseEvent(n4, n5, bl, n);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "onButton(swingButton, pressed, x, y)", "Exception", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "onButton(swingButton, pressed, x, y)", "Exception", invocationTargetException);
        }
    }

    public void onWheel(final int n, int n2, int n3) {
        this.convert(n2, n3, this.location);
        final int n4 = (int)this.location.x;
        final int n5 = (int)this.location.y;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JMEDesktop.this.sendAWTWheelEvent(n, n4, n5);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "onWheel(wheelDelta, x, y)", "Exception", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "onWheel(wheelDelta, x, y)", "Exception", invocationTargetException);
        }
    }

    public void onMove(int n, int n2, int n3, int n4) {
        this.convert(n3, n4, this.location);
        final int n5 = (int)this.location.x;
        final int n6 = (int)this.location.y;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JMEDesktop.this.sendAWTMouseEvent(n5, n6, false, 0);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "onMove(xDelta, yDelta, newX, newY)", "Exception", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "onMove(xDelta, yDelta, newX, newY)", "Exception", invocationTargetException);
        }
    }

    public boolean isSynchronizingThreadsOnUpdate() {
        return this.synchronizingThreadsOnUpdate;
    }

    public void setSynchronizingThreadsOnUpdate(boolean bl) {
        if (this.synchronizingThreadsOnUpdate != bl) {
            this.synchronizingThreadsOnUpdate = bl;
        }
    }

    private void enableAntiAlias(Graphics2D graphics2D) {
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.setRenderingHints(renderingHints);
    }

    public XUpdateAction getXUpdateAction() {
        return this.xUpdateAction;
    }

    public YUpdateAction getYUpdateAction() {
        return this.yUpdateAction;
    }

    public WheelUpdateAction getWheelUpdateAction() {
        return this.wheelUpdateAction;
    }

    public ButtonAction getButtonUpdateAction(int n) {
        if (n == Integer.MIN_VALUE) {
            return this.allButtonsUpdateAction;
        }
        return new ButtonAction(n);
    }

    public InputAction getKeyUpdateAction() {
        return this.keyUpdateAction;
    }

    private void sendAWTKeyEvent(int n, boolean bl, char c) {
        if ((n = AWTKeyInput.toAWTCode(n)) != 0) {
            Component component = this.getFocusOwner();
            if (component == null) {
                component = this.desktop;
            }
            if (c == '\u0000') {
                c = (char)65535;
            }
            if (component != null) {
                Object object;
                if (bl) {
                    object = new KeyEvent(component, 401, System.currentTimeMillis(), this.getCurrentModifiers(-1), n, c);
                    this.dispatchEvent(component, (AWTEvent)object);
                    JMEDesktop.anInt.value = n;
                    Char char_ = this.characters.get(anInt);
                    if (char_ == null) {
                        this.characters.put(new Int(n), new Char(c));
                    } else {
                        char_.value = c;
                    }
                    if (c != '\uffff') {
                        this.dispatchEvent(component, new KeyEvent(component, 400, System.currentTimeMillis(), this.getCurrentModifiers(-1), 0, c));
                    }
                }
                if (!bl) {
                    JMEDesktop.anInt.value = n;
                    object = this.characters.get(anInt);
                    if (object != null) {
                        c = ((Char)object).value;
                    }
                    this.dispatchEvent(component, new KeyEvent(component, 402, System.currentTimeMillis(), this.getCurrentModifiers(-1), n, c));
                }
            }
        }
    }

    private void dispatchEvent(Component component, AWTEvent aWTEvent) {
        if (this.getModalComponent() == null || SwingUtilities.isDescendingFrom(component, this.getModalComponent())) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("not in swing thread!");
            }
            component.dispatchEvent(aWTEvent);
        }
    }

    private static void dontDrawBackground(Container container) {
        if (container != null) {
            container.setBackground(null);
            if (container instanceof JComponent) {
                JComponent jComponent = (JComponent)container;
                jComponent.setOpaque(false);
            }
            JMEDesktop.dontDrawBackground(container.getParent());
        }
    }

    private static int powerOf2SizeIfNeeded(int n, boolean bl) {
        if (bl || !TextureState.isNonPowerOfTwoTextureSupported()) {
            int n2;
            for (n2 = 1; n2 < n; n2 <<= 1) {
            }
            return n2;
        }
        return n;
    }

    private void sendAWTWheelEvent(int n, int n2, int n3) {
        Component component;
        Component component2 = component = this.lastComponent != null ? this.lastComponent : this.componentAt(n2, n3, this.desktop, false);
        if (component == null) {
            component = this.desktop;
        }
        Point point = this.convertPoint(this.desktop, n2, n3, component);
        MouseWheelEvent mouseWheelEvent = new MouseWheelEvent(component, 507, System.currentTimeMillis(), this.getCurrentModifiers(-1), point.x, point.y, 1, false, 0, Math.abs(n), n > 0 ? -1 : 1);
        this.dispatchEvent(component, mouseWheelEvent);
    }

    private Point convertPoint(Component component, int n, int n2, Component component2) {
        if (this.useConvertPoint) {
            try {
                return SwingUtilities.convertPoint(component, n, n2, component2);
            }
            catch (InternalError internalError) {
                this.useConvertPoint = false;
            }
        }
        if (component2 != null) {
            while (component2 != component) {
                n -= component2.getX();
                n2 -= component2.getY();
                if (component2.getParent() == null) break;
                component2 = component2.getParent();
            }
        }
        return new Point(n, n2);
    }

    private void sendAWTMouseEvent(int n, int n2, boolean bl, int n3) {
        Component component = this.componentAt(n, n2, this.desktop, false);
        int n4 = n3 > 0 ? (bl ? 501 : 502) : (this.getButtonMask(0) == 0 ? 503 : 506);
        long l = System.currentTimeMillis();
        if (this.lastComponent != component) {
            Point point;
            while (!(this.lastComponent == null || component != null && SwingUtilities.isDescendingFrom(component, this.lastComponent))) {
                point = this.convertPoint(this.desktop, n, n2, this.lastComponent);
                this.sendExitedEvent(this.lastComponent, this.getCurrentModifiers(n3), point);
                this.lastComponent = this.lastComponent.getParent();
            }
            point = this.convertPoint(this.desktop, n, n2, this.lastComponent);
            if (this.lastComponent == null) {
                this.lastComponent = this.desktop;
            }
            this.sendEnteredEvent(component, this.lastComponent, this.getCurrentModifiers(n3), point);
            this.lastComponent = component;
            this.downX = Integer.MIN_VALUE;
            this.downY = Integer.MIN_VALUE;
            this.lastClickTime = 0L;
        }
        if (component != null) {
            boolean bl2 = false;
            if (n3 > 0) {
                if (bl) {
                    this.grabbedMouse = component;
                    this.grabbedMouseButton = n3;
                    this.downX = n;
                    this.downY = n2;
                    this.setFocusOwner(this.componentAt(n, n2, this.desktop, true));
                } else if (this.grabbedMouseButton == n3 && this.grabbedMouse != null) {
                    component = this.grabbedMouse;
                    this.grabbedMouse = null;
                    if (Math.abs(this.downX - n) <= 4 && Math.abs(this.downY - n2) < 4) {
                        this.clickCount = this.lastClickTime + 300L > l ? ++this.clickCount : 1;
                        bl2 = true;
                        this.lastClickTime = l;
                    }
                    this.downX = Integer.MIN_VALUE;
                    this.downY = Integer.MIN_VALUE;
                }
            } else if (this.grabbedMouse != null) {
                component = this.grabbedMouse;
            }
            Point point = this.convertPoint(this.desktop, n, n2, component);
            MouseEvent mouseEvent = new MouseEvent(component, n4, l, this.getCurrentModifiers(n3), point.x, point.y, this.clickCount, n3 == 2 && bl, n3 >= 0 ? n3 : 0);
            this.dispatchEvent(component, mouseEvent);
            if (bl2) {
                component = this.componentAt(n, n2, this.desktop, true);
                Point point2 = this.convertPoint(this.desktop, n, n2, component);
                MouseEvent mouseEvent2 = new MouseEvent(component, 500, l, this.getCurrentModifiers(n3), point2.x, point2.y, this.clickCount, false, n3);
                this.dispatchEvent(component, mouseEvent2);
            }
        } else if (bl) {
            this.setFocusOwner(null);
        }
    }

    public void setFocusOwner(Component component) {
        if (component == null || component.isFocusable()) {
            Component component2;
            for (component2 = component; component2 != null; component2 = component2.getParent()) {
                if (!(component2 instanceof JInternalFrame)) continue;
                try {
                    ((JInternalFrame)component2).setSelected(true);
                    continue;
                }
                catch (PropertyVetoException propertyVetoException) {
                    logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "setFocusOwner(Component comp)", "Exception", propertyVetoException);
                }
            }
            this.awtWindow.setFocusableWindowState(true);
            component2 = this.getFocusOwner();
            if (component == this.desktop) {
                component = null;
            }
            if (component2 != component) {
                if (component2 != null) {
                    this.dispatchEvent(component2, new FocusEvent(component2, 1005, false, component));
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                if (component != null) {
                    this.dispatchEvent(component, new FocusEvent(component, 1004, false, component2));
                }
            }
            this.awtWindow.setFocusableWindowState(false);
        }
        this.focusCleared = component == null;
    }

    private int getCurrentModifiers(int n) {
        int n2 = 0;
        if (this.isKeyDown(56)) {
            n2 |= 0x200;
            n2 |= 8;
        }
        if (this.isKeyDown(184)) {
            n2 |= 0x2000;
            n2 |= 0x20;
        }
        if (this.isKeyDown(29) || this.isKeyDown(157)) {
            n2 |= 0x80;
            n2 |= 2;
        }
        if (this.isKeyDown(42) || this.isKeyDown(54)) {
            n2 |= 0x40;
            n2 |= 1;
        }
        return n2 | this.getButtonMask(n);
    }

    private boolean isKeyDown(int n) {
        return KeyInput.get().isKeyDown(n);
    }

    private int getButtonMask(int n) {
        int n2 = 0;
        if (MouseInput.get().isButtonDown(0) || n == 1) {
            n2 |= 0x10;
            n2 |= 0x400;
        }
        if (MouseInput.get().isButtonDown(1) || n == 2) {
            n2 |= 8;
            n2 |= 0x800;
        }
        if (MouseInput.get().isButtonDown(2) || n == 3) {
            n2 |= 4;
            n2 |= 0x1000;
        }
        return n2;
    }

    public void convert(int n, int n2, Vector2f vector2f) {
        if (this.lastXin == n && this.lastYin == n2) {
            vector2f.x = this.lastXout;
            vector2f.y = this.lastYout;
        } else {
            this.lastXin = n;
            this.lastYin = n2;
            if (this.getRenderQueueMode() == 4) {
                n = (int)((float)n - this.getWorldTranslation().x + (float)(this.desktopWidth / 2));
                n2 = (int)((float)(this.desktopHeight / 2) - ((float)n2 - this.getWorldTranslation().y));
            } else {
                vector2f.set((float)n, (float)n2);
                DisplaySystem.getDisplaySystem().getWorldCoordinates(vector2f, 0.0f, this.pickRay.origin);
                DisplaySystem.getDisplaySystem().getWorldCoordinates(vector2f, 0.3f, this.pickRay.direction).subtractLocal(this.pickRay.origin).normalizeLocal();
                this.applyWorld(this.bottomLeft.set((float)(-this.width) * 0.5f, (float)(-this.height) * 0.5f, 0.0f));
                this.applyWorld(this.topLeft.set((float)(-this.width) * 0.5f, (float)this.height * 0.5f, 0.0f));
                this.applyWorld(this.topRight.set((float)this.width * 0.5f, (float)this.height * 0.5f, 0.0f));
                this.applyWorld(this.bottomRight.set((float)this.width * 0.5f, (float)(-this.height) * 0.5f, 0.0f));
                if (this.pickRay.intersectWherePlanarQuad(this.topLeft, this.topRight, this.bottomLeft, this.tuv)) {
                    n = (int)((this.tuv.y - 0.5f) * (float)this.width) + this.desktopWidth / 2;
                    n2 = (int)((this.tuv.z - 0.5f) * (float)this.height) + this.desktopHeight / 2;
                } else {
                    n = -1;
                    n2 = -1;
                }
            }
            this.lastYout = n2;
            this.lastXout = n;
            vector2f.set((float)n, (float)n2);
        }
    }

    private void applyWorld(Vector3f vector3f) {
        this.getWorldRotation().multLocal(vector3f.multLocal(this.getWorldScale())).addLocal(this.getWorldTranslation());
    }

    public Component componentAt(int n, int n2) {
        Component component = this.componentAt(n, n2, this.desktop, true);
        if (component != this.desktop) {
            return component;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component componentAt(int n, int n2, Component component, boolean bl) {
        Component component2;
        if (bl && component instanceof JRootPane) {
            component2 = (JRootPane)component;
            component = ((JRootPane)component2).getContentPane();
        }
        component2 = component;
        if (!component.contains(n, n2)) {
            component2 = null;
        } else {
            Object object = component.getTreeLock();
            synchronized (object) {
                if (component instanceof Container) {
                    Container container = (Container)component;
                    int n3 = container.getComponentCount();
                    for (int i = 0; i < n3; ++i) {
                        Component component3 = container.getComponent(i);
                        if (component3 == null || !component3.isVisible() || this.dragAndDropSupport != null && this.dragAndDropSupport.isDragPanel(component3) || !component3.contains(n - component3.getX(), n2 - component3.getY())) continue;
                        component2 = component3;
                        break;
                    }
                }
            }
        }
        if (component2 != null) {
            if (component instanceof JTabbedPane && component2 != component) {
                component2 = ((JTabbedPane)component).getSelectedComponent();
            }
            n -= component2.getX();
            n2 -= component2.getY();
        }
        return component2 != component && component2 != null ? this.componentAt(n, n2, component2, bl) : component2;
    }

    private void sendEnteredEvent(Component component, Component component2, int n, Point point) {
        if (component != null && component != component2) {
            this.sendEnteredEvent(component.getParent(), component2, n, point);
            point = this.convertPoint(component2, point.x, point.y, component);
            MouseEvent mouseEvent = new MouseEvent(component, 504, System.currentTimeMillis(), n, point.x, point.y, 0, false, 0);
            this.dispatchEvent(component, mouseEvent);
        }
    }

    private void sendExitedEvent(Component component, int n, Point point) {
        MouseEvent mouseEvent = new MouseEvent(component, 505, System.currentTimeMillis(), n, point.x, point.y, 1, false, 0);
        this.dispatchEvent(component, mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Renderer renderer) {
        if (this.graphics.isDirty()) {
            LockRunnable lockRunnable;
            boolean bl = this.synchronizingThreadsOnUpdate;
            if (bl) {
                lockRunnable = this.paintLockRunnable;
                synchronized (lockRunnable) {
                    try {
                        this.paintLockRunnable.wait = true;
                        SwingUtilities.invokeLater(this.paintLockRunnable);
                        this.paintLockRunnable.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "draw(Renderer r)", "Exception", interruptedException);
                    }
                }
            }
            try {
                if (this.graphics != null) {
                    this.graphics.update(this.texture);
                }
            }
            finally {
                if (bl) {
                    lockRunnable = this.paintLockRunnable;
                    synchronized (lockRunnable) {
                        this.paintLockRunnable.notifyAll();
                    }
                }
            }
        }
        super.draw(renderer);
    }

    public JDesktopPane getJDesktop() {
        return this.desktop;
    }

    public Component getFocusOwner() {
        if (!this.focusCleared) {
            return this.awtWindow.getFocusOwner();
        }
        return null;
    }

    private int getSwingButtonIndex(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    public Component getModalComponent() {
        return this.modalComponent;
    }

    public void setModalComponent(Component component) {
        this.modalComponent = component;
    }

    protected void setParent(Node node) {
        if (this.desktop == null) {
            throw new IllegalStateException("already disposed");
        }
        super.setParent(node);
    }

    public void dispose() {
        if (this.desktop != null) {
            if (this.getParent() != null) {
                this.getParent().detachChild((Spatial)this);
            }
            this.inputHandler.removeAllActions();
            if (this.inputHandler.getParent() != null) {
                this.inputHandler.getParent().removeFromAttachedHandlers(this.inputHandler);
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JMEDesktop.this.desktop.removeAll();
                        JMEDesktop.this.awtWindow.dispose();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "dispose()", "Exception", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().toString(), "dispose()", "Exception", invocationTargetException);
            }
            this.desktop = null;
            if (--desktopsUsed == 0) {
                PopupFactory.setSharedInstance(new PopupFactory());
            }
        }
    }

    public void resize(float f, float f2) {
        throw new UnsupportedOperationException("resizing JMEDesktop not yet implemented!");
    }

    private static class ScrollPaneRepaintFixListener
    implements ContainerListener {
        private ScrollPaneRepaintFixListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            this.componentAdded(component);
        }

        private void componentAdded(Component component) {
            Container container;
            if (component instanceof Container) {
                container = (Container)component;
                this.addTo(container);
                container.addContainerListener(this);
            }
            if (component instanceof JScrollPane) {
                container = (JScrollPane)component;
                this.subscribeRepaintListener(((JScrollPane)container).getViewport());
            }
        }

        private void addTo(Container container) {
            container.addContainerListener(this);
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.componentAdded(container.getComponent(i));
            }
        }

        private void removeFrom(Container container) {
            container.removeContainerListener(this);
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.componentRemoved(container.getComponent(i));
            }
        }

        private void subscribeRepaintListener(JViewport jViewport) {
            for (int i = 0; i < jViewport.getChangeListeners().length; ++i) {
                ChangeListener changeListener = jViewport.getChangeListeners()[i];
                if (!(changeListener instanceof ScrollPaneRepaintChangeListener)) continue;
                return;
            }
            jViewport.addChangeListener(new ScrollPaneRepaintChangeListener(jViewport));
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            this.componentRemoved(component);
        }

        private void componentRemoved(Component component) {
            if (component instanceof Container) {
                Container container = (Container)component;
                this.removeFrom(container);
            }
        }

        private static class ScrollPaneRepaintChangeListener
        implements ChangeListener {
            private final Component component;

            public ScrollPaneRepaintChangeListener(Component component) {
                this.component = component;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.component.repaint();
            }
        }
    }

    private class KeyUpdateAction
    extends InputAction {
        private KeyUpdateAction() {
        }

        public void performAction(InputActionEvent inputActionEvent) {
            JMEDesktop.this.onKey(inputActionEvent.getTriggerCharacter(), inputActionEvent.getTriggerIndex(), inputActionEvent.getTriggerPressed());
        }
    }

    private class WheelUpdateAction
    extends InputAction {
        public WheelUpdateAction() {
            this.setSpeed(1.0f);
        }

        public void performAction(InputActionEvent inputActionEvent) {
            JMEDesktop.this.onWheel((int)(inputActionEvent.getTriggerDelta() * this.getSpeed()), JMEDesktop.this.lastXin, JMEDesktop.this.lastYin);
        }
    }

    private class YUpdateAction
    extends InputAction {
        public YUpdateAction() {
            this.setSpeed(1.0f);
        }

        public void performAction(InputActionEvent inputActionEvent) {
            int n = DisplaySystem.getDisplaySystem().getHeight();
            JMEDesktop.this.onMove(0, (int)((float)n * inputActionEvent.getTriggerDelta() * this.getSpeed()), JMEDesktop.this.lastXin, (int)((float)n * inputActionEvent.getTriggerPosition() * this.getSpeed()));
        }
    }

    private class XUpdateAction
    extends InputAction {
        public XUpdateAction() {
            this.setSpeed(1.0f);
        }

        public void performAction(InputActionEvent inputActionEvent) {
            int n = DisplaySystem.getDisplaySystem().getWidth();
            JMEDesktop.this.onMove((int)((float)n * inputActionEvent.getTriggerDelta() * this.getSpeed()), 0, (int)((float)n * inputActionEvent.getTriggerPosition() * this.getSpeed()), JMEDesktop.this.lastYin);
        }
    }

    private class ButtonAction
    extends InputAction {
        private final int swingButtonIndex;

        public ButtonAction(int n) {
            this.swingButtonIndex = n;
        }

        public void performAction(InputActionEvent inputActionEvent) {
            JMEDesktop.this.onButton(this.swingButtonIndex != Integer.MIN_VALUE ? this.swingButtonIndex : JMEDesktop.this.getSwingButtonIndex(inputActionEvent.getTriggerIndex()), inputActionEvent.getTriggerPressed(), JMEDesktop.this.lastXin, JMEDesktop.this.lastYin);
        }
    }

    private static class MyPopupFactory
    extends PopupFactory {
        private final PopupFactory defaultPopupFactory = new PopupFactory();

        private MyPopupFactory() {
        }

        public Popup getPopup(Component component, Component component2, int n, int n2) throws IllegalArgumentException {
            while (!(component instanceof JDesktopPane)) {
                if ((component = component.getParent()) != null) continue;
                logger.warning("jME Popup creation failed, default popup created - desktop not found in component hierarchy of " + component);
                return this.defaultPopupFactory.getPopup(component, component2, n, n2);
            }
            LightWeightPopup lightWeightPopup = new LightWeightPopup((JComponent)component);
            lightWeightPopup.adjust(component, component2, n, n2);
            return lightWeightPopup;
        }
    }

    private class LockRunnable
    implements Runnable {
        private boolean wait = false;

        private LockRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LockRunnable lockRunnable = JMEDesktop.this.paintLockRunnable;
            synchronized (lockRunnable) {
                this.notifyAll();
                if (this.wait) {
                    try {
                        this.wait = false;
                        JMEDesktop.this.paintLockRunnable.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.logp(Level.SEVERE, this.getClass().toString(), "run()", "Exception", interruptedException);
                    }
                }
            }
        }
    }

    private static class Char {
        char value;

        public Char(char c) {
            this.value = c;
        }
    }

    private static class Int {
        int value;

        public Int(int n) {
            this.value = n;
        }

        public boolean equals(Object object) {
            return object instanceof Int && ((Int)object).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }
    }

    private static class LightWeightPopup
    extends Popup {
        private static final Integer INTEGER_MAX_VALUE = Integer.MAX_VALUE;
        private final JComponent desktop;
        JPanel panel = new JPanel(new BorderLayout());

        public LightWeightPopup(JComponent jComponent) {
            this.desktop = jComponent;
            new ScrollPaneRepaintFixListener().addTo(this.panel);
        }

        public void adjust(Component component, Component component2, int n, int n2) {
            this.panel.setVisible(false);
            this.desktop.add((Component)this.panel, INTEGER_MAX_VALUE);
            this.panel.removeAll();
            this.panel.add(component2, "Center");
            if (component2 instanceof JComponent) {
                JComponent jComponent = (JComponent)component2;
                jComponent.setDoubleBuffered(false);
            }
            this.panel.setSize(this.panel.getPreferredSize());
            n2 = Math.min(n2, this.desktop.getHeight() - this.panel.getHeight());
            n = Math.min(n, this.desktop.getWidth() - this.panel.getWidth());
            this.panel.setLocation(n, n2);
            component2.invalidate();
            this.panel.validate();
        }

        public void show() {
            this.panel.setVisible(true);
        }

        public void hide() {
            Rectangle rectangle = this.panel.getBounds();
            this.desktop.remove(this.panel);
            this.desktop.repaint(rectangle);
        }
    }
}

