/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample.jme;

import com.jme.animation.SpatialTransformer;
import com.jme.intersection.BoundingPickResults;
import com.jme.intersection.PickResults;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Arrow;
import com.jme.system.DisplaySystem;
import com.jme.system.SystemProvider;
import com.jme.system.lwjgl.LWJGLDisplaySystem;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryImporter;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.mmosf.client.sample.jme.ModelObject;
import jp.sourceforge.mmosf.client.sample.jme.SampleClientFrame;
import jp.sourceforge.mmosf.client.sample.jme.SampleJMEPanel;
import jp.sourceforge.mmosf.server.level.GeomapData;
import jp.sourceforge.mmosf.server.level.MobFactory;
import jp.sourceforge.mmosf.server.object.Mob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuarterViewPanel
extends SampleJMEPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(QuarterViewPanel.class);
    public GeomapData map;
    private Node nodeMap;
    private Node nodeChar;
    private Node nodeRotate1;
    private Node nodeRotate2;
    private Node nodeOffset;
    protected Mob self;
    protected Mob oldSelf;
    protected List<Mob> listMob;
    private float fsize = 0.2f;
    private Vector3f min = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f max = new Vector3f(this.fsize, this.fsize, this.fsize);
    private ModelObject myChar2;
    private float angle = 1.0f;
    private float length = -80.0f / this.angle;
    protected Point p;
    protected Map<Spatial, Mob> mapSpatialMob;
    protected Map<Integer, ModelObject> mapMobModel;
    protected Mob selectedMob = null;
    protected TriMesh cursol;
    protected SampleClientFrame frame;
    protected URL fileMan;
    protected URL fileTree;
    protected URL fileFire;
    protected URL fileDoorOpen;
    protected URL fileDoorClose;

    public QuarterViewPanel() {
        this.fileMan = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/man6.obj");
        this.fileTree = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/tree.obj");
        this.fileFire = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/fire.obj");
        this.fileDoorOpen = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/door_open.obj");
        this.fileDoorClose = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/door_close.obj");
    }

    public QuarterViewPanel(GeomapData data) {
        this.setMap(data);
        this.initGround();
        this.fileMan = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/man6.obj");
        this.fileTree = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/tree.obj");
        this.fileFire = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/fire.obj");
        this.fileDoorOpen = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/door_open.obj");
        this.fileDoorClose = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/door_close.obj");
    }

    public void setFrame(SampleClientFrame frame) {
        this.frame = frame;
    }

    @Override
    protected void simpleSetup2() {
        this.getRootNode().detachAllChildren();
        this.nodeChar = new Node();
        this.nodeOffset = new Node();
        this.nodeRotate1 = new Node();
        this.nodeRotate2 = new Node();
        this.initGround();
        this.myChar2 = this.getMobMesh("self", this.fileMan, 0);
        this.myChar2.getMesh().setDefaultColor(ColorRGBA.lightGray);
        this.myChar2.getNodeTranslation().setLocalTranslation(0.0f, 0.0f, 0.0f);
        this.cursol = new Arrow("cursol", 1.0f * this.fsize, 0.5f * this.fsize);
        Quaternion q = new Quaternion();
        q.fromAngles(0.0f, 0.0f, (float)Math.PI);
        this.cursol.setLocalRotation(q);
        this.cursol.setDefaultColor(ColorRGBA.red);
        this.nodeChar.attachChild(this.myChar2.getObject());
        this.nodeMap.attachChild((Spatial)this.nodeChar);
        this.nodeOffset.attachChild((Spatial)this.nodeMap);
        this.nodeRotate1.attachChild((Spatial)this.nodeOffset);
        this.nodeRotate2.attachChild((Spatial)this.nodeRotate1);
        this.getCamea().setParallelProjection(true);
        this.resizeCamera(this.getCamea(), this.comp.getWidth(), this.comp.getHeight());
        this.setAngle();
        this.getRootNode().setLocalTranslation(0.0f, 0.0f, this.length);
        this.getRootNode().attachChild((Spatial)this.nodeRotate2);
        this.comp.addMouseListener(this);
        this.mapSpatialMob = new HashMap<Spatial, Mob>();
        this.mapMobModel = new HashMap<Integer, ModelObject>();
    }

    private void setAngle() {
        Quaternion rote1 = new Quaternion();
        rote1.fromAngles(0.3926991f, 0.0f, 0.0f);
        this.nodeRotate2.setLocalRotation(rote1);
        Quaternion rote2 = new Quaternion();
        rote2.fromAngles(0.0f, 0.7853982f, 0.0f);
        this.nodeRotate1.setLocalRotation(rote2);
    }

    public void initGround() {
        try {
            URL url = QuarterViewPanel.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/jme/test.data");
            BinaryImporter im = BinaryImporter.getInstance();
            try {
                Savable s = im.load(url);
                if (s instanceof Node) {
                    this.nodeMap = (Node)s;
                    return;
                }
            }
            catch (IOException e) {
                log.error("error in init ground, ", e);
            }
        }
        catch (Exception e) {
            log.error("error in init ground, ", e);
        }
    }

    private Vector3f createVector3f(int x, int z) {
        return new Vector3f((float)(x - this.map.getMapWidth() / 2) * this.fsize, 0.0f, (float)(z - this.map.getMapHeight() / 2) * this.fsize);
    }

    @Override
    protected void simpleUpdate2() {
        try {
            if (this.self != null) {
                this.moveSelf();
            }
            if (this.listMob != null) {
                this.moveMob();
            }
            if (this.p != null) {
                this.selectMob(this.p);
                this.p = null;
            }
            this.dispCursol();
        }
        catch (Exception e) {
            log.error("error in simpleUpdate2,", e);
        }
    }

    protected void selectMob(Point pt) {
        Spatial sp = this.getSelectedSpatial(pt);
        if (sp != null) {
            this.selectedMob = this.mapSpatialMob.get(sp);
            this.frame.selectMob(this.selectedMob);
        }
    }

    protected Spatial getSelectedSpatial(Point pt) {
        Geometry sp = null;
        Vector2f screenPos = new Vector2f();
        screenPos.set((float)pt.x, (float)pt.y);
        SystemProvider systemProvider = LWJGLDisplaySystem.getSystemProvider();
        DisplaySystem displaySystem = systemProvider.getDisplaySystem();
        Ray mouseRay = displaySystem.getPickRay(screenPos, true, null);
        BoundingPickResults pr = new BoundingPickResults();
        pr.clear();
        this.getRootNode().findPick(mouseRay, (PickResults)pr);
        int i = 0;
        while (i < pr.getNumber()) {
            sp = pr.getPickData(i).getTargetMesh().getParentGeom();
            ++i;
        }
        return sp;
    }

    protected void moveMob() {
        for (Mob mob : this.listMob) {
            if (mob == this.self) continue;
            ModelObject obj = this.mapMobModel.get(mob.getId());
            if (obj != null) {
                if (mob.vis.getVtype() == MobFactory.VISUAL_DOOR_OPEN) {
                    System.out.println("open");
                }
                if (obj.getVisual() != mob.vis.getVtype()) {
                    this.nodeChar.detachChild(obj.getObject());
                    this.mapMobModel.remove(mob.getId());
                    this.mapSpatialMob.remove(obj.getObject());
                    obj = null;
                }
            }
            if (obj == null) {
                ModelObject obj2 = this.getModelObject(mob);
                this.nodeChar.attachChild(obj2.getObject());
                obj = obj2;
                this.mapSpatialMob.put((Spatial)obj2.getMesh(), mob);
                this.mapMobModel.put(mob.getId(), obj2);
            }
            obj.setDirection(mob);
            obj.setTranslation(this.createVector3f(mob));
            this.mapSpatialMob.get(obj.getMesh()).setPos(mob.getPos());
        }
    }

    private ModelObject getModelObject(Mob mob) {
        ModelObject obj2 = null;
        ColorRGBA color = ColorRGBA.red;
        switch (mob.vis.getVtype()) {
            case 0: {
                color = ColorRGBA.blue;
                obj2 = this.getMobMesh(Integer.toString(mob.getId()), this.fileMan, mob.vis.getVtype());
                break;
            }
            case 1: {
                color = ColorRGBA.red;
                obj2 = this.getMobMesh(Integer.toString(mob.getId()), this.fileMan, mob.vis.getVtype());
                break;
            }
            case 2: {
                color = ColorRGBA.brown;
                obj2 = this.getMobMesh(Integer.toString(mob.getId()), this.fileTree, mob.vis.getVtype());
                break;
            }
            case 3: {
                color = ColorRGBA.red;
                obj2 = this.getMobMesh(Integer.toString(mob.getId()), this.fileFire, mob.vis.getVtype());
                break;
            }
            case 4: {
                color = ColorRGBA.green;
                obj2 = this.getMobMesh(Integer.toString(mob.getId()), this.fileMan, mob.vis.getVtype());
                break;
            }
            case 5: {
                color = ColorRGBA.darkGray;
                obj2 = this.getMobMesh(Integer.toString(mob.getId()), this.fileDoorClose, mob.vis.getVtype());
                break;
            }
            case 6: {
                color = ColorRGBA.darkGray;
                obj2 = this.getMobMesh(Integer.toString(mob.getId()), this.fileDoorOpen, mob.vis.getVtype());
                break;
            }
            default: {
                color = ColorRGBA.randomColor();
                obj2 = this.getMobMesh(Integer.toString(mob.getId()), this.fileMan, mob.vis.getVtype());
            }
        }
        obj2.getMesh().setDefaultColor(color);
        return obj2;
    }

    private Vector3f createVector3f(Mob mob) {
        return this.createVector3f(mob.getPos().getX(), mob.getPos().getY());
    }

    protected void moveSelf() {
        Vector3f v = this.createVector3f(this.self);
        if (this.oldSelf == null) {
            this.nodeOffset.setLocalTranslation(v.negate());
            this.oldSelf = this.self;
        } else if (!this.self.getPos().equals(this.oldSelf.getPos())) {
            Vector3f v2 = this.createVector3f(this.oldSelf);
            SpatialTransformer st = new SpatialTransformer(1);
            st.setObject((Spatial)this.nodeOffset, 0, -1);
            st.setPosition(0, 0.0f, v2.negate());
            st.setPosition(0, 0.5f, v.negate());
            st.interpolateMissing();
            this.nodeOffset.clearControllers();
            this.nodeOffset.addController((Controller)st);
            this.myChar2.setDirection(this.self);
            this.oldSelf = this.self;
        }
        this.myChar2.getNodeTranslation().setLocalTranslation(v);
    }

    protected void dispCursol() {
        if (this.selectedMob != null) {
            if (!this.nodeChar.hasChild((Spatial)this.cursol)) {
                this.nodeChar.attachChild((Spatial)this.cursol);
            }
            Vector3f v = this.createVector3f(this.selectedMob);
            Vector3f v2 = this.cursol.getLocalTranslation();
            if (v.x == v2.x && v.y == v2.y) {
                return;
            }
            v.x += 0.5f * this.fsize;
            v.y += 4.0f * this.fsize;
            v.z += 0.5f * this.fsize;
            this.cursol.setLocalTranslation(v);
        } else if (this.nodeChar.hasChild((Spatial)this.cursol)) {
            this.nodeChar.detachChild((Spatial)this.cursol);
        }
    }

    protected void resizeCamera(Camera camea, int width, int height) {
        Vector2f rect = this.getCameraRect(width, height);
        camea.setFrustum(1.0f, 1000.0f, -rect.x / 2.0f, rect.x / 2.0f, -rect.y / 2.0f, rect.y / 2.0f);
    }

    protected Vector2f getCameraRect(float width, float height) {
        Vector2f rect = new Vector2f();
        float aspect = 1.3333334f;
        float width2 = this.fsize * 20.0f;
        float height2 = this.fsize * 20.0f;
        if (width / height < aspect) {
            width2 = width / height * height2;
        } else {
            height2 = width2 / (width / height);
        }
        rect.set(width2, height2);
        return rect;
    }

    public void setMap(GeomapData map) {
        this.map = map;
    }

    public void update(Mob self, List<Mob> listMob) {
        if (this.self == null || !this.self.getPos().equals(self.getPos())) {
            this.oldSelf = this.self;
            this.self = self;
        }
        this.listMob = listMob;
    }

    protected int getOffset(int pos, int viewSize, int mapSize) {
        int Offset = pos - viewSize / 2;
        if (Offset < 0) {
            Offset = 0;
        } else if (Offset > mapSize - viewSize) {
            Offset = mapSize - viewSize;
        }
        return Offset;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.p = e.getPoint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void resetSelect() {
        this.selectedMob = null;
        this.p = null;
    }

    public Mob getSelf() {
        return this.self;
    }

    protected ModelObject getMobMesh(String name, URL objFile, int visual) {
        try {
            return ModelObject.getModelObject(objFile, this.getDefaultRotate(), name, this.fsize, visual);
        }
        catch (Exception e) {
            log.error("error in load onject, ", e);
            return null;
        }
    }

    protected Quaternion getDefaultRotate() {
        Quaternion q = new Quaternion();
        q.fromAngles(-1.5707964f, -1.5707964f, 0.0f);
        return q;
    }
}

