/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.level.ItemFactory;
import jp.sourceforge.mmosf.server.level.LevelManager;
import jp.sourceforge.mmosf.server.level.QuestFactory;
import jp.sourceforge.mmosf.server.object.ChatMessage;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.PlayerCharactor;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.object.Visual;
import jp.sourceforge.mmosf.server.object.action.ActionCondition;
import jp.sourceforge.mmosf.server.object.action.ActionConditionItem;
import jp.sourceforge.mmosf.server.object.action.ActionConditionQuest;
import jp.sourceforge.mmosf.server.object.action.ActionElement;
import jp.sourceforge.mmosf.server.object.action.ActionResult;
import jp.sourceforge.mmosf.server.object.action.ActionResultChangeStatus;
import jp.sourceforge.mmosf.server.object.action.ActionResultGetItem;
import jp.sourceforge.mmosf.server.object.action.ActionResultGetMenu;
import jp.sourceforge.mmosf.server.object.action.ActionResultGetMessage;
import jp.sourceforge.mmosf.server.object.action.ActionResultPopMob;
import jp.sourceforge.mmosf.server.object.action.ActionResultTriggerQuest;
import jp.sourceforge.mmosf.server.object.item.Item;
import jp.sourceforge.mmosf.server.object.quest.Quest;
import jp.sourceforge.mmosf.server.object.quest.QuestPhase;
import jp.sourceforge.mmosf.server.object.quest.reward.QuestReward;
import jp.sourceforge.mmosf.server.object.quest.reward.QuestRewardGetItem;
import jp.sourceforge.mmosf.server.object.quest.trigger.TriggerParameter;
import jp.sourceforge.mmosf.server.object.quest.trigger.TriggerParameterAction;
import jp.sourceforge.mmosf.server.object.quest.trigger.TriggerParameterActionToItem;
import jp.sourceforge.mmosf.server.object.quest.trigger.TriggerParameterActionToMob;
import jp.sourceforge.mmosf.server.packet.MessagePacket;
import jp.sourceforge.mmosf.server.packet.MovePacket;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import jp.sourceforge.mmosf.server.sync.SyncArea;
import jp.sourceforge.mmosf.server.sync.SyncShard;
import jp.sourceforge.mmosf.server.timer.TimerFactory;
import jp.sourceforge.mmosf.server.timer.TimerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingServer
implements TimerListener,
Perception {
    public static Log log = LogFactory.getLog(MatchingServer.class);
    protected SyncShard shard = null;
    protected LevelManager level = null;
    protected List<PlayerCharactor> listPC = new LinkedList<PlayerCharactor>();
    protected List<Mob> listNPC;
    protected Timer timer = null;

    public MatchingServer() {
        this.shard = new SyncShard();
        this.level = new LevelManager();
        this.listNPC = this.level.getMob(0);
        for (Mob mob : this.listNPC) {
            SyncArea area = this.shard.getSyncArea(mob.getPos());
            area.in(mob);
        }
    }

    public void put(Packet packet, PlayerCharactor pc) throws PacketFormatException {
        block27: {
            try {
                switch (packet.getType()) {
                    case 7: {
                        Vector v = ((MovePacket)packet).getVector();
                        if (!pc.getVector().equals(v)) {
                            log.debug("move," + v);
                            pc.setVector(v);
                            this.move(pc);
                            break;
                        }
                        log.debug("pass," + v);
                        break;
                    }
                    case 8: {
                        int type = packet.getInt("type");
                        switch (type) {
                            case 0: {
                                int id = packet.getInt("id");
                                SyncArea area = this.shard.getSyncArea(pc.getPos());
                                Mob target = this.findMobAround(area, id);
                                if (target != null) {
                                    List<ActionElement> listAction = this.getEnableAction(pc, target.act.listAction);
                                    Packet sendPacket = PacketFactory.createMenuResponsePaket(new String(new char[]{target.c}), null, listAction);
                                    pc.conn.send(sendPacket);
                                    break;
                                }
                                break block27;
                            }
                            case 1: {
                                int slot = packet.getInt("slot");
                                Item item = pc.listItem[slot];
                                if (item == null) break block27;
                                Packet sendPacket = PacketFactory.createMenuResponsePaket(item.name, null, item.act.listAction);
                                pc.conn.send(sendPacket);
                            }
                            default: {
                                break;
                            }
                        }
                        break;
                    }
                    case 10: {
                        ActionElement elm;
                        String targetName;
                        int id;
                        TriggerParameterAction param = null;
                        if (packet.getInt("type") == 0) {
                            id = packet.getInt("targetid");
                            SyncArea area = this.shard.getSyncArea(pc.getPos());
                            Mob target = this.findMobAround(area, id);
                            if (target == null) break;
                            targetName = String.valueOf(target.c);
                            double length = MatchingServer.getDistance(pc.getPos(), target.getPos());
                            elm = target.act.getAction(packet.getInt("commandid"));
                            if ((double)elm.distance < length) {
                                Packet sendPacket = PacketFactory.createMessagePacket(new ChatMessage(0, 1));
                                pc.conn.send(sendPacket);
                                break;
                            }
                            param = new TriggerParameterActionToMob(target, elm);
                        } else {
                            id = packet.getInt("slotid");
                            Item item = pc.listItem[id];
                            if (item == null) break;
                            targetName = item.name;
                            elm = item.act.getAction(packet.getInt("commandid"));
                            param = new TriggerParameterActionToItem(item, elm);
                        }
                        if (!this.isEnableElement(pc, elm)) break;
                        for (ActionResult result : elm.listResult) {
                            ActionResult result2;
                            if (result instanceof ActionResultGetItem) {
                                result2 = (ActionResultGetItem)result;
                                this.getItem(pc, ((ActionResultGetItem)result2).item);
                                continue;
                            }
                            if (result instanceof ActionResultPopMob) {
                                result2 = (ActionResultPopMob)result;
                                Mob mob = ((ActionResultPopMob)result2).popMob(pc, this.level.createId());
                                SyncArea area2 = this.shard.getSyncArea(mob.getPos());
                                area2.in(mob);
                                continue;
                            }
                            if (result instanceof ActionResultGetMenu) {
                                result2 = (ActionResultGetMenu)result;
                                List<ActionElement> listAction = this.getEnableAction(pc, ((ActionResultGetMenu)result2).act.listAction);
                                Packet sendPacket = PacketFactory.createMenuResponsePaket(targetName, ((ActionResultGetMenu)result2).message, listAction);
                                pc.conn.send(sendPacket);
                                continue;
                            }
                            if (result instanceof ActionResultGetMessage) {
                                result2 = (ActionResultGetMessage)result;
                                Packet sendPacket = PacketFactory.createMessagePacket(((ActionResultGetMessage)result2).message);
                                pc.conn.send(sendPacket);
                                continue;
                            }
                            if (result instanceof ActionResultTriggerQuest) {
                                result2 = (ActionResultTriggerQuest)result;
                                int index = pc.getQuestIndex(((ActionResultTriggerQuest)result2).id);
                                if (index != -1) continue;
                                Quest quest = QuestFactory.createQuest(((ActionResultTriggerQuest)result2).id);
                                pc.addQuest(quest);
                                Packet sendPacket = PacketFactory.createQuestPacket(quest);
                                pc.conn.send(sendPacket);
                                continue;
                            }
                            if (!(result instanceof ActionResultChangeStatus)) continue;
                            result2 = (ActionResultChangeStatus)result;
                            if (!result2.isTarget(0) || !(param instanceof TriggerParameterActionToMob)) break;
                            TriggerParameterActionToMob target = (TriggerParameterActionToMob)param;
                            if (((ActionResultChangeStatus)result2).status == 1) {
                                target.targetMob.colType = ((ActionResultChangeStatus)result2).value;
                                continue;
                            }
                            if (((ActionResultChangeStatus)result2).status != 0) break;
                            target.targetMob.vis = new Visual(((ActionResultChangeStatus)result2).value);
                        }
                        this.checkQuestTriger(pc, param);
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("error in process packet, ", e);
            }
        }
        this.syncArea(pc, packet);
    }

    protected void getItem(PlayerCharactor pc, Item item) throws IOException, PacketFormatException {
        int slot = pc.addItem(item);
        if (slot == -1) {
            Packet sendPacket = PacketFactory.createMessagePacket(new ChatMessage(0, 0));
            pc.conn.send(sendPacket);
        } else {
            Packet sendPacket = PacketFactory.createGetItemStatusPacket(slot, item);
            pc.conn.send(sendPacket);
        }
    }

    protected List<ActionElement> getEnableAction(PlayerCharactor pc, List<ActionElement> listAction2) {
        LinkedList<ActionElement> listAction = new LinkedList<ActionElement>();
        listAction.addAll(listAction2);
        Iterator it2 = listAction.iterator();
        while (it2.hasNext()) {
            ActionElement actionElement = (ActionElement)it2.next();
            if (this.isEnableElement(pc, actionElement)) continue;
            it2.remove();
        }
        return listAction;
    }

    protected boolean isEnableElement(PlayerCharactor pc, ActionElement elm) {
        boolean isEnable = true;
        for (ActionCondition actionCondition : elm.listCondition) {
            ActionCondition condition;
            if (actionCondition instanceof ActionConditionQuest) {
                condition = (ActionConditionQuest)actionCondition;
                if (((ActionConditionQuest)condition).isEnable(pc)) continue;
                isEnable = false;
                continue;
            }
            if (!(actionCondition instanceof ActionConditionItem) || ((ActionConditionItem)(condition = (ActionConditionItem)actionCondition)).isEnable(pc)) continue;
            isEnable = false;
        }
        return isEnable;
    }

    public static double getDistance(Position pos1, Position pos2) {
        int x = pos1.getX() - pos2.getX();
        int y = pos1.getY() - pos2.getY();
        double length = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        return length;
    }

    protected Mob findMobAround(SyncArea area, int id) {
        Mob target = area.getMob(id);
        if (target != null) {
            return target;
        }
        List<SyncArea> listArea = area.getSyncAreaAround();
        for (SyncArea a : listArea) {
            Mob m = a.getMob(id);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private void syncArea(PlayerCharactor pc, Packet packet) throws PacketFormatException {
        SyncArea ga = this.shard.getSyncArea(pc.getPos());
        if (packet.getType() == 2) {
            try {
                System.out.println(PacketFactory.parseMessagePacket((MessagePacket)packet));
                Packet sendPacket = PacketFactory.createMessagePacket(ChatMessage.createSay(String.valueOf(pc.c), packet.toString()));
                ga.sendPacket(sendPacket);
                List<SyncArea> listArea = this.shard.getSyncArea(pc.getPos()).getSyncAreaAround();
                Iterator<SyncArea> it = listArea.iterator();
                while (it.hasNext()) {
                    it.next().sendPacket(sendPacket);
                }
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    public boolean register(PlayerCharactor pc) {
        if (this.listPC.isEmpty()) {
            this.timer = TimerFactory.startTimer(this, 600L);
        }
        this.listPC.add(pc);
        this.shard.getSyncArea(pc.getPos()).in(pc);
        return true;
    }

    public boolean unregister(PlayerCharactor pc) {
        int index = this.listPC.indexOf(pc);
        this.listPC.remove(index);
        this.shard.getSyncArea(pc.getPos()).out(pc);
        if (this.listPC.isEmpty()) {
            TimerFactory.stopTimer(this.timer);
        }
        return true;
    }

    @Override
    public void onTimer() {
        log.debug("OnTimer in");
        for (PlayerCharactor pc : this.listPC) {
            this.move(pc);
            log.debug("move pc:" + pc.c);
        }
        for (Mob mob : this.listNPC) {
            if (mob.moving.isMoveType(0)) continue;
            this.move(mob);
            log.debug("move mob:" + mob.c);
        }
        log.debug("OnTimer out");
    }

    public void move(Mob mob) {
        Position oldPos = mob.moving.move(mob, this);
        if (mob.getPos().equals(oldPos)) {
            return;
        }
        this.shard.getSyncZone(mob.getPos()).move(mob, oldPos, mob.getPos());
    }

    @Override
    public boolean isEnableMove(MoveObject mo) {
        if (!this.level.getZoneGeomap(mo.getNowPos().zoneID).isEnableMove(this, mo)) {
            return false;
        }
        return !this.isCollision(mo);
    }

    @Override
    public boolean isCollision(MoveObject mo) {
        Mob targetMob = this.shard.getSyncArea(mo.getNextPos()).getCollision(mo);
        return targetMob != null;
    }

    public void checkQuestTriger(PlayerCharactor pc, TriggerParameter param) throws PacketFormatException, IOException {
        int i = 0;
        while (i < pc.listQuest.length) {
            Quest quest;
            QuestPhase phase;
            if (pc.listQuest[i] != null && (phase = (quest = pc.listQuest[i]).getPhase()).trigger(param)) {
                Packet pac;
                quest.update();
                if (!quest.isComplete()) {
                    pac = PacketFactory.createQuestPacket(quest);
                    try {
                        pc.conn.send(pac);
                    }
                    catch (Exception e) {
                        log.error("error in send packet, ", e);
                    }
                } else {
                    pc.listQuest[i] = null;
                    pc.listCompleteQuest.add(quest);
                    pac = PacketFactory.createQuestPacket(quest);
                    pc.conn.send(pac);
                    for (QuestReward reward : quest.listReward) {
                        if (!(reward instanceof QuestRewardGetItem)) continue;
                        QuestRewardGetItem reward2 = (QuestRewardGetItem)reward;
                        Item item = ItemFactory.createItem(reward2.itemId);
                        this.getItem(pc, item);
                    }
                }
            }
            ++i;
        }
    }
}

