/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import jp.sourceforge.mmosf.server.PacketCache;

public class SocketManager {
    protected Socket socket;

    public SocketManager(Socket socket) {
        this.socket = socket;
    }

    public SocketManager(SocketAddress addr) throws IOException {
        this.socket = new Socket();
        this.socket.connect(addr);
    }

    public String getConnectId() {
        if (this.socket == null) {
            return null;
        }
        return this.socket.toString();
    }

    public boolean isReceiveSocket() throws IOException {
        return this.socket.getInputStream().available() != 0;
    }

    public void read(PacketCache cache) throws IOException {
        cache.put(this.socket.getInputStream());
    }

    private static void write(ByteBuffer buff, OutputStream os) throws IOException {
        ByteBuffer buffSize = ByteBuffer.allocate(4);
        buffSize.putInt(buff.array().length);
        os.write(buffSize.array(), 0, buffSize.array().length);
        os.write(buff.array(), 0, buff.array().length);
        os.flush();
    }

    public void write(ByteBuffer buff) throws IOException {
        SocketManager.write(buff, this.socket.getOutputStream());
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }
}

