/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.level;

import jp.sourceforge.mmosf.server.level.ItemFactory;
import jp.sourceforge.mmosf.server.object.ChatMessage;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MovingNo;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.object.action.Action;
import jp.sourceforge.mmosf.server.object.action.ActionConditionItem;
import jp.sourceforge.mmosf.server.object.action.ActionConditionQuest;
import jp.sourceforge.mmosf.server.object.action.ActionElement;
import jp.sourceforge.mmosf.server.object.action.ActionResultChangeStatus;
import jp.sourceforge.mmosf.server.object.action.ActionResultGetItem;
import jp.sourceforge.mmosf.server.object.action.ActionResultGetMenu;
import jp.sourceforge.mmosf.server.object.action.ActionResultGetMessage;
import jp.sourceforge.mmosf.server.object.action.ActionResultTriggerQuest;

public class MobFactory {
    public static int TYPE_MOB = 0;
    public static int TYPE_TREE = 1;
    public static int TYPE_FIRE = 2;
    public static int TYPE_QNPCA = 3;
    public static int TYPE_QNPCB = 4;
    public static int TYPE_DOOR = 5;
    public static int VISUAL_DOOR_CLOSE = 5;
    public static int VISUAL_DOOR_OPEN = 6;

    public static Mob createMob(Position pos, char c, int id) {
        Mob mob = new Mob(pos.getX(), pos.getY(), Character.valueOf(c), id, 0);
        mob.type = TYPE_TREE;
        return mob;
    }

    public static Mob createTreeMob(Position pos, int id) {
        Mob mob = new Mob(pos.getX(), pos.getY(), Character.valueOf('\u6728'), id, 2);
        mob.moving = new MovingNo();
        ActionElement elm = new ActionElement(0, "\u5207\u308b", 1.5f);
        elm.addResult(new ActionResultGetItem(ItemFactory.createFireWood()));
        mob.act = new Action();
        mob.act.addAction(elm);
        mob.type = TYPE_MOB;
        return mob;
    }

    public static Mob createFireMob(Position pos, int id) {
        Mob mob = new Mob(pos.getX(), pos.getY(), Character.valueOf('\u706b'), id, 3);
        mob.moving = new MovingNo();
        mob.type = TYPE_FIRE;
        return mob;
    }

    public static Mob createDoorMob(Position pos, Vector direction, int id) {
        Mob mob = new Mob(pos.getX(), pos.getY(), Character.valueOf('\u6249'), id, VISUAL_DOOR_CLOSE);
        mob.moving = new MovingNo();
        mob.direction = new Vector(direction);
        ActionElement elm = new ActionElement(0, "\u958b\u304f", 1.0f);
        elm.addCondition(new ActionConditionItem(1, 0));
        elm.addResult(new ActionResultGetMessage(ChatMessage.createSysMsg("\u9375\u304c\u304b\u304b\u3063\u3066\u3044\u308b\u3002")));
        ActionElement elm2 = new ActionElement(1, "\u958b\u304f", 1.0f);
        elm2.addCondition(new ActionConditionItem(1, 1));
        elm2.addResult(new ActionResultChangeStatus(0, 0, VISUAL_DOOR_OPEN));
        elm2.addResult(new ActionResultChangeStatus(0, 1, 0));
        mob.act = new Action();
        mob.act.addAction(elm);
        mob.act.addAction(elm2);
        mob.type = TYPE_DOOR;
        return mob;
    }

    public static Mob createQuestMobA(Position pos, int id) {
        Mob mob = new Mob(pos.getX(), pos.getY(), Character.valueOf('\uff21'), id, 4);
        mob.moving = new MovingNo();
        ActionElement elm1 = new ActionElement(1, "\u8a13\u7df4\u3092\u53d7\u3051\u305f\u3044", 1.0f);
        elm1.addResult(new ActionResultGetMessage(ChatMessage.createTell(String.valueOf(mob.c), "\u304a\u304a\u3001\u3084\u306f\u308a\u305d\u3046\u304b\u3002\u3067\u306f\u3001NPC-B\u3068\u8a71\u3057\u3066\u307f\u308b\u3053\u3068\u3060\u3002")));
        elm1.addResult(new ActionResultTriggerQuest(0));
        ActionElement elm2 = new ActionElement(2, "\u7528\u306f\u306a\u3044", 1.0f);
        elm2.addResult(new ActionResultGetMessage(ChatMessage.createTell(String.valueOf(mob.c), "\u8a13\u7df4\u304c\u5fc5\u8981\u306a\u3089\u3044\u3064\u3067\u3082\u623b\u3063\u3066\u6765\u3044\u3002")));
        Action act = new Action();
        act.addAction(elm1);
        act.addAction(elm2);
        ActionElement elm = new ActionElement(0, "\u8a71\u3059", 1.0f);
        elm.addCondition(new ActionConditionQuest(0, 0, 0));
        elm.addResult(new ActionResultGetMenu("\u79c1\u306f\u5192\u967a\u8005\u306b\u751f\u304d\u308b\u305f\u3081\u306e\u77e5\u6075\u3092\u6559\u3048\u3066\u3044\u308b\u3002", act));
        ActionElement elm3 = new ActionElement(3, "\u8a71\u3059", 1.0f);
        elm3.addCondition(new ActionConditionQuest(0, 0, 1));
        elm3.addResult(new ActionResultGetMessage(ChatMessage.createTell(String.valueOf(mob.c), "NPC-B\u306f\u897f\u306e\u65b9\u306b\u3044\u308b\u305e\u3002")));
        ActionElement elm4 = new ActionElement(4, "\u8a71\u3059", 1.0f);
        elm4.addCondition(new ActionConditionQuest(0, 0, 3));
        elm4.addResult(new ActionResultGetMessage(ChatMessage.createTell(String.valueOf(mob.c), "\u304c\u3093\u3070\u3063\u3066\u3044\u308b\u304b\uff1f")));
        mob.act = new Action();
        mob.act.addAction(elm);
        mob.act.addAction(elm3);
        mob.act.addAction(elm4);
        mob.type = TYPE_QNPCA;
        return mob;
    }

    public static Mob createQuestMobB(Position pos, int id) {
        Mob mob = new Mob(pos.getX(), pos.getY(), Character.valueOf('\uff22'), id, 4);
        mob.moving = new MovingNo();
        ActionElement elm5 = new ActionElement(7, "\u8a71\u3059", 1.0f);
        elm5.addCondition(new ActionConditionQuest(1, 1, 3));
        elm5.addResult(new ActionResultGetMessage(ChatMessage.createTell(String.valueOf(mob.c), "\u3055\u3042\u3001\u81ea\u5206\u306e\u529b\u3092\u8a66\u3059\u305f\u3081\u306b\u65c5\u7acb\u3064\u3093\u3060\u3002")));
        ActionElement elm4 = new ActionElement(6, "\u8a71\u3059", 1.0f);
        elm4.addCondition(new ActionConditionQuest(1, 1, 1));
        elm4.addResult(new ActionResultGetMessage(ChatMessage.createTell(String.valueOf(mob.c), "\u3088\u304f\u3084\u3063\u305f\u3002\u305d\u308c\u304c\u51fa\u6765\u308c\u3070\u3001\u3068\u308a\u3042\u3048\u305a\u751f\u304d\u3066\u3044\u3051\u308b\u3060\u308d\u3046\u3002\u3055\u3042\u3001\u3053\u306e\u9375\u3092\u4f7f\u3063\u3066\u6249\u3092\u958b\u3051\u3001\u753a\u306e\u5916\u3067\u81ea\u5206\u306e\u529b\u3092\u8a66\u3057\u3066\u6765\u3044\u3002")));
        elm4.addResult(new ActionResultTriggerQuest(1));
        ActionElement elm3 = new ActionElement(5, "\u8a71\u3059", 1.0f);
        elm3.addCondition(new ActionConditionQuest(1, 0, 1));
        elm3.addResult(new ActionResultGetMessage(ChatMessage.createTell(String.valueOf(mob.c), "\u3053\u306e\u3042\u305f\u308a\u306e\u201c\u6728\u201d\u3092\u201c\u5207\u3063\u201d\u3066\u201c\u85aa\u201d\u3092\u624b\u306b\u5165\u308c\u308d\u3002\u201c\u85aa\u201d\u3092\u624b\u306b\u5165\u308c\u305f\u3089\u3001\u305d\u308c\u306b\u201c\u706b\u3092\u4ed8\u3051\u308b\u201d\u3093\u3060\u3002\u308f\u304b\u3063\u305f\u304b\uff1f")));
        ActionElement elm = new ActionElement(1, "\u8a71\u3059", 1.0f);
        elm.addCondition(new ActionConditionQuest(0, 0, 1));
        ActionElement elm00 = new ActionElement(3, "\u6e96\u5099\u306f\u3067\u304d\u3066\u3044\u308b\u3002", 1.0f);
        elm00.addResult(new ActionResultGetMessage(ChatMessage.createTell(String.valueOf(mob.c), "\u3088\u3057\u3001\u307e\u305a\u3053\u306e\u3042\u305f\u308a\u306e\u201c\u6728\u201d\u3092\u201c\u5207\u3063\u201d\u3066\u201c\u85aa\u201d\u3092\u624b\u306b\u5165\u308c\u308d\u3002\u201c\u85aa\u201d\u3092\u624b\u306b\u5165\u308c\u305f\u3089\u3001\u305d\u308c\u306b\u201c\u706b\u3092\u4ed8\u3051\u308b\u201d\u3093\u3060\u3002\u305d\u308c\u304c\u51fa\u6765\u305f\u3089\u623b\u3063\u3066\u6765\u3044\u3002")));
        elm00.addResult(new ActionResultTriggerQuest(1));
        ActionElement elm01 = new ActionElement(4, "\u3082\u3046\u5c11\u3057\u5f85\u3063\u3066\u304f\u308c\u3002", 1.0f);
        elm01.addResult(new ActionResultGetMessage(ChatMessage.createTell(String.valueOf(mob.c), "\u6025\u3050\u5fc5\u8981\u306f\u306a\u3044\u304c\u3001\u305d\u3093\u306a\u306b\u5927\u5909\u306a\u3053\u3068\u3067\u3082\u306a\u3044\u305e")));
        Action act = new Action();
        act.addAction(elm00);
        act.addAction(elm01);
        elm.addResult(new ActionResultGetMenu("\u8a71\u306f\u805e\u3044\u3066\u3044\u308b\u3002\u6e96\u5099\u306f\u3044\u3044\u304b\uff1f", act));
        elm.addCondition(new ActionConditionQuest(1, 0, 0));
        ActionElement elm2 = new ActionElement(0, "\u8a71\u3059", 1.0f);
        elm2.addCondition(new ActionConditionQuest(0, 0, 0));
        elm2.addResult(new ActionResultGetMessage(ChatMessage.createTell(String.valueOf(mob.c), "\u3084\u3042\u3001\u3053\u3093\u306b\u3061\u306f\u3002")));
        mob.act = new Action();
        mob.act.addAction(elm);
        mob.act.addAction(elm2);
        mob.act.addAction(elm3);
        mob.act.addAction(elm4);
        mob.act.addAction(elm5);
        mob.type = TYPE_QNPCB;
        return mob;
    }
}

