/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mmosf.server.UserConnection;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MovingVector;
import jp.sourceforge.mmosf.server.object.UpdateCache;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.object.item.Item;
import jp.sourceforge.mmosf.server.object.quest.Quest;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerCharactor
extends Mob {
    private static Log log = LogFactory.getLog(PlayerCharactor.class);
    public UserConnection conn;
    protected UpdateCache cache = null;
    public Item[] listItem;
    public Quest[] listQuest;
    public List<Quest> listCompleteQuest;

    public PlayerCharactor(int x, int y, Character c, int id, UserConnection conn) {
        super(x, y, c, id, 1);
        this.conn = conn;
        this.cache = new UpdateCache();
        this.moving = new MovingVector();
        this.listItem = new Item[20];
        this.listQuest = new Quest[20];
        this.listCompleteQuest = new LinkedList<Quest>();
    }

    public PlayerCharactor(PlayerCharactor mob) {
        super(mob);
        this.conn = mob.conn;
        this.cache = new UpdateCache();
        this.moving = new MovingVector();
    }

    @Override
    public boolean isPlayerCharactor() {
        return true;
    }

    public void sendUpdate(List<Mob> listMob) {
        List<Mob> list = this.cache.pickUpdate(listMob);
        if (list.size() == 0) {
            return;
        }
        Packet pac = PacketFactory.createUpdatePacket(list);
        try {
            this.conn.send(pac);
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public void setVector(Vector v) {
        ((MovingVector)this.moving).vec.set(v);
    }

    public Vector getVector() {
        return ((MovingVector)this.moving).vec;
    }

    public int addItem(Item item) {
        int i = 0;
        while (i < this.listItem.length) {
            if (this.listItem[i] == null) {
                this.listItem[i] = item;
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int addQuest(Quest quest) {
        int i = 0;
        while (i < this.listQuest.length) {
            if (this.listQuest[i] == null) {
                this.listQuest[i] = quest;
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getQuestIndex(int id) {
        int i = 0;
        while (i < this.listQuest.length) {
            if (this.listQuest[i] != null && this.listQuest[i].id == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getItemIndex(int itemId) {
        int i = 0;
        while (i < this.listItem.length) {
            if (this.listItem[i] != null && this.listItem[i].id == itemId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Quest getQuest(int index) {
        return this.listQuest[index];
    }

    public Item getItem(int index) {
        return this.listItem[index];
    }
}

