/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import jp.sourceforge.mmosf.server.object.Vector;

public class Position {
    private double x;
    private double y;
    private double z;
    public int zoneID;
    public int shardID;
    private boolean isValid;

    public Position() {
        this.setValid(false);
    }

    public Position(Position pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        this.zoneID = pos.zoneID;
        this.shardID = pos.shardID;
        this.setValid(true);
    }

    public void move(Vector v) {
        this.checkValid();
        this.x += (double)v.x;
        this.y += (double)v.y;
        this.z += (double)v.z;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Position) {
            if (!this.isValid) {
                return false;
            }
            Position pos = (Position)obj;
            if (!pos.isValid) {
                return false;
            }
            return this.getX() == pos.getX() && this.getY() == pos.getY() && this.getZ() == pos.getZ();
        }
        return false;
    }

    public String toString() {
        if (!this.isValid) {
            return "not initialize.";
        }
        return "x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + ",zone=" + this.zoneID + ",shard=" + this.shardID;
    }

    public void subtract(Position p) {
        this.checkValid();
        p.checkValid();
        this.x -= p.x;
        this.y -= p.y;
        this.z -= p.z;
    }

    public int getX() {
        this.checkValid();
        return (int)this.x;
    }

    public int getY() {
        this.checkValid();
        return (int)this.y;
    }

    public int getZ() {
        this.checkValid();
        return (int)this.z;
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.setValid(true);
    }

    public void set(Position pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        this.setValid(true);
    }

    public void move(Position next, int speed) {
        this.checkValid();
        Position nP = new Position(next);
        nP.subtract(this);
        double value = speed;
        double length = Math.sqrt(Math.pow(nP.getX(), 2.0) + Math.pow(nP.getY(), 2.0));
        if (length == 0.0) {
            return;
        }
        double a = value / length;
        this.x += nP.x * a;
        this.y += nP.y * a;
        this.z += nP.z * a;
    }

    public Vector getVector(Position next, int speed) {
        this.checkValid();
        double x = next.x - this.x;
        double y = next.y - this.y;
        double z = next.z - this.z;
        double length = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        if (length == 0.0) {
            return Vector.ZERO;
        }
        double a = (double)speed / length;
        Vector vec = new Vector();
        vec.x = (int)(x * a);
        vec.y = (int)(y * a);
        vec.z = (int)(z * a);
        return vec;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    private void checkValid() {
        if (!this.isValid) {
            throw new RuntimeException("Not Initialize.");
        }
    }
}

