/*
 * Decompiled with CFR 0.152.
 */
package com.jme.intersection;

import com.jme.intersection.PickData;
import com.jme.math.FastMath;
import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrianglePickData
extends PickData {
    private static final Logger logger = Logger.getLogger(TrianglePickData.class.getName());
    private final Vector3f[] worldTriangle = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f()};
    private final Vector3f[] vertices = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f()};
    private final Vector3f intersectionPoint = new Vector3f();

    public TrianglePickData(Ray ray, GeomBatch geomBatch, ArrayList<Integer> arrayList, boolean bl) {
        super(ray, geomBatch, arrayList, false);
        if (bl) {
            this.distance = this.calculateDistance();
        }
    }

    @Override
    protected float calculateDistance() {
        float f;
        int n;
        int n2;
        ArrayList<Integer> arrayList = this.getTargetTris();
        if (arrayList.isEmpty()) {
            return Float.POSITIVE_INFINITY;
        }
        TriangleBatch triangleBatch = (TriangleBatch)this.getTargetMesh();
        float f2 = Float.POSITIVE_INFINITY;
        float[] fArray = new float[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            n = arrayList.get(n2);
            triangleBatch.getTriangle(n, this.vertices);
            fArray[n2] = f = this.getDistanceSquaredToTriangle(this.vertices, triangleBatch.getParentGeom());
            if (!(f > 0.0f) || !(f < f2)) continue;
            f2 = f;
        }
        n2 = 0;
        while (n2 == 0) {
            n2 = 1;
            for (n = 0; n < fArray.length - 1; ++n) {
                if (!(fArray[n] > fArray[n + 1])) continue;
                n2 = 0;
                f = fArray[n + 1];
                fArray[n + 1] = fArray[n];
                fArray[n] = f;
                int n3 = arrayList.get(n + 1);
                arrayList.set(n + 1, arrayList.get(n));
                arrayList.set(n, n3);
            }
        }
        if (Float.isInfinite(f2)) {
            return f2;
        }
        return FastMath.sqrt(f2);
    }

    private float getDistanceSquaredToTriangle(Vector3f[] vector3fArray, Spatial spatial) {
        for (int i = 0; i < 3; ++i) {
            spatial.localToWorld(vector3fArray[i], this.worldTriangle[i]);
        }
        Ray ray = this.getRay();
        if (ray.intersectWhere(this.worldTriangle[0], this.worldTriangle[1], this.worldTriangle[2], this.intersectionPoint)) {
            return ray.getOrigin().distanceSquared(this.intersectionPoint);
        }
        logger.warning("Couldn't detect nearest triangle intersection!");
        return Float.POSITIVE_INFINITY;
    }
}

