/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.math.Vector3f;
import com.jme.scene.BezierPatch;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class BezierMesh
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private BezierPatch patch;

    public BezierMesh() {
    }

    public BezierMesh(String string) {
        super(string);
    }

    public BezierMesh(String string, BezierPatch bezierPatch) {
        super(string);
        this.patch = bezierPatch;
        this.tessellate();
    }

    public void setPatch(BezierPatch bezierPatch) {
        this.patch = bezierPatch;
        this.tessellate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tessellate() {
        float f;
        int n;
        if (this.patch == null) {
            return;
        }
        TriangleBatch triangleBatch = this.getBatch(0);
        int n2 = 0;
        int n3 = this.patch.getDetailLevel();
        Vector3f[] vector3fArray = new Vector3f[4];
        Vector3f[] vector3fArray2 = new Vector3f[n3 + 1];
        vector3fArray[0] = this.patch.getAnchor(0, 3);
        vector3fArray[1] = this.patch.getAnchor(1, 3);
        vector3fArray[2] = this.patch.getAnchor(2, 3);
        vector3fArray[3] = this.patch.getAnchor(3, 3);
        for (n = 0; n <= n3; ++n) {
            f = (float)n / (float)n3;
            vector3fArray2[n] = this.calcBerstein(f, vector3fArray);
        }
        n2 = 1;
        triangleBatch.setVertexCount((n3 * 2 + 2) * n3);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setTriangleQuantity(n3 * n3 * 6);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(triangleBatch.getTriangleCount() * 3));
        triangleBatch.getVertexBuffer().clear();
        FloatBuffer floatBuffer = triangleBatch.getTextureBuffers().get(0);
        floatBuffer.clear();
        for (n2 = 1; n2 <= n3; ++n2) {
            float f2 = (float)n2 / (float)n3;
            float f3 = ((float)n2 - 1.0f) / (float)n3;
            vector3fArray[0] = this.calcBerstein(f2, this.patch.getAnchors()[0]);
            vector3fArray[1] = this.calcBerstein(f2, this.patch.getAnchors()[1]);
            vector3fArray[2] = this.calcBerstein(f2, this.patch.getAnchors()[2]);
            vector3fArray[3] = this.calcBerstein(f2, this.patch.getAnchors()[3]);
            for (n = 0; n <= n3; ++n) {
                f = (float)n / (float)n3;
                floatBuffer.put(f3).put(f);
                triangleBatch.getVertexBuffer().put(vector3fArray2[n].x).put(vector3fArray2[n].y).put(vector3fArray2[n].z);
                vector3fArray2[n] = this.calcBerstein(f, vector3fArray);
                floatBuffer.put(f2).put(f);
                triangleBatch.getVertexBuffer().put(vector3fArray2[n].x).put(vector3fArray2[n].y).put(vector3fArray2[n].z);
            }
        }
        int n4 = -1;
        for (int i = 0; i < triangleBatch.getTriangleCount(); i += 6) {
            ++n4;
            if (i > 0 && i % (n3 * 6) == 0) {
                ++n4;
            }
            triangleBatch.getIndexBuffer().put(2 * n4);
            triangleBatch.getIndexBuffer().put(2 * n4 + 1);
            triangleBatch.getIndexBuffer().put(2 * n4 + 2);
            triangleBatch.getIndexBuffer().put(2 * n4 + 3);
            triangleBatch.getIndexBuffer().put(2 * n4 + 2);
            triangleBatch.getIndexBuffer().put(2 * n4 + 1);
        }
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n3) {
            for (int i = 0; i < n3 * 2 + 2; ++i) {
                block15: {
                    block16: {
                        BufferUtils.populateFromBuffer(vector3f3, triangleBatch.getVertexBuffer(), n7);
                        if (i % 2 != 0) break block16;
                        if (n8 == 0) {
                            if (i < n3 * 2) {
                                n5 = n7 + 1;
                                n6 = n7 + 2;
                                break block15;
                            } else {
                                n5 = n7 - 1;
                                n6 = n7 + 1;
                            }
                            break block15;
                        } else {
                            int n9 = n7 - (n3 * 2 + 1);
                            triangleBatch.getNormalBuffer().rewind();
                            vector3f4.x = triangleBatch.getNormalBuffer().get(n9 * 3);
                            vector3f4.y = triangleBatch.getNormalBuffer().get(n9 * 3 + 1);
                            vector3f4.z = triangleBatch.getNormalBuffer().get(n9 * 3 + 2);
                            vector3f4.normalizeLocal();
                            BufferUtils.setInBuffer(vector3f4, triangleBatch.getNormalBuffer(), n7);
                            ++n7;
                            continue;
                        }
                    }
                    if (i < n3 * 2 + 1) {
                        n5 = n7 + 2;
                        n6 = n7 - 1;
                    } else {
                        n5 = n7 - 1;
                        n6 = n7 - 2;
                    }
                }
                BufferUtils.populateFromBuffer(vector3f2, triangleBatch.getVertexBuffer(), n5);
                BufferUtils.populateFromBuffer(vector3f, triangleBatch.getVertexBuffer(), n6);
                vector3f4.set(vector3f2).subtractLocal(vector3f3).crossLocal(vector3f.subtractLocal(vector3f3)).normalizeLocal();
                BufferUtils.setInBuffer(vector3f4, triangleBatch.getNormalBuffer(), n7);
                ++n7;
            }
            ++n8;
        }
        return;
    }

    private Vector3f calcBerstein(float f, Vector3f[] vector3fArray) {
        if (vector3fArray.length != 4) {
            throw new JmeException("Point parameter must be length 4.");
        }
        Vector3f vector3f = vector3fArray[0].mult((float)Math.pow(f, 3.0));
        Vector3f vector3f2 = vector3fArray[1].mult(3.0f * (float)Math.pow(f, 2.0) * (1.0f - f));
        Vector3f vector3f3 = vector3fArray[2].mult(3.0f * f * (float)Math.pow(1.0f - f, 2.0));
        Vector3f vector3f4 = vector3fArray[3].mult((float)Math.pow(1.0f - f, 3.0));
        return vector3f.addLocal(vector3f2).addLocal(vector3f3.addLocal(vector3f4));
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.patch, "patch", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.patch = (BezierPatch)inputCapsule.readSavable("patch", null);
    }
}

