/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.animation.Bone;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import java.io.IOException;

public class ConnectionPoint
extends Node {
    private static final long serialVersionUID = -3767376526385942925L;
    private Bone target;

    public ConnectionPoint() {
    }

    public ConnectionPoint(String string, Bone bone) {
        super(string);
        this.target = bone;
    }

    public void updateWorldData(float f) {
        this.updateWorldVectors();
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Spatial spatial = (Spatial)this.children.get(i);
                if (spatial == null) continue;
                spatial.updateGeometricState(f, false);
            }
        }
    }

    public void updateWorldVectors() {
        if (this.target == null) {
            return;
        }
        if ((this.lockedMode & 4) == 0) {
            this.worldScale.set(this.parent.getWorldScale()).multLocal(this.target.getWorldScale());
            this.parent.getWorldRotation().mult(this.target.getWorldRotation(), this.worldRotation);
            this.worldTranslation = this.parent.localToWorld(this.target.getWorldTranslation(), this.worldTranslation);
        }
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        this.target = (Bone)jMEImporter.getCapsule(this).readSavable("target", null);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        jMEExporter.getCapsule(this).write(this.target, "target", null);
    }
}

