/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.batch;

import com.jme.renderer.Renderer;
import com.jme.scene.batch.GeomBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.IntBuffer;

public class PointBatch
extends GeomBatch
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    private float pointSize = 1.0f;
    private boolean antialiased = false;
    protected transient IntBuffer indexBuffer;

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void setAntialiased(boolean bl) {
        this.antialiased = bl;
    }

    public float getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(float f) {
        this.pointSize = f;
    }

    public IntBuffer getIndexBuffer() {
        return this.indexBuffer;
    }

    public void setIndexBuffer(IntBuffer intBuffer) {
        this.indexBuffer = intBuffer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getIndexBuffer() == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.getIndexBuffer().limit());
            this.getIndexBuffer().rewind();
            int n = this.getIndexBuffer().limit();
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeInt(this.getIndexBuffer().get());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n == 0) {
            this.setIndexBuffer(null);
        } else {
            IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
            for (int i = 0; i < n; ++i) {
                intBuffer.put(objectInputStream.readInt());
            }
            this.setIndexBuffer(intBuffer);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.pointSize, "pointSize", 1.0f);
        outputCapsule.write(this.antialiased, "antialiased", false);
        outputCapsule.write(this.indexBuffer, "indexBuffer", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.pointSize = inputCapsule.readFloat("pointSize", 1.0f);
        this.antialiased = inputCapsule.readBoolean("antialiased", false);
        this.indexBuffer = inputCapsule.readIntBuffer("indexBuffer", null);
    }

    public void draw(Renderer renderer) {
        if (!this.isEnabled()) {
            return;
        }
        if (!renderer.isProcessingQueue() && renderer.checkAndAdd(this)) {
            return;
        }
        super.draw(renderer);
        renderer.draw(this);
    }
}

