/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Icosahedron
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private static final int NUM_POINTS = 12;
    private static final int NUM_TRIS = 20;
    private float sideLength;

    public Icosahedron() {
    }

    public Icosahedron(String string, float f) {
        super(string);
        this.sideLength = f;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount(12);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(12));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(12));
        triangleBatch.setTextureBuffer(BufferUtils.createVector2Buffer(12), 0);
        triangleBatch.setTriangleQuantity(20);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(3 * triangleBatch.getTriangleCount()));
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void setIndexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        IntBuffer intBuffer = triangleBatch.getIndexBuffer();
        intBuffer.rewind();
        intBuffer.put(0).put(8).put(4);
        intBuffer.put(0).put(5).put(10);
        intBuffer.put(2).put(4).put(9);
        intBuffer.put(2).put(11).put(5);
        intBuffer.put(1).put(6).put(8);
        intBuffer.put(1).put(10).put(7);
        intBuffer.put(3).put(9).put(6);
        intBuffer.put(3).put(7).put(11);
        intBuffer.put(0).put(10).put(8);
        intBuffer.put(1).put(8).put(10);
        intBuffer.put(2).put(9).put(11);
        intBuffer.put(3).put(11).put(9);
        intBuffer.put(4).put(2).put(0);
        intBuffer.put(5).put(0).put(2);
        intBuffer.put(6).put(1).put(3);
        intBuffer.put(7).put(3).put(1);
        intBuffer.put(8).put(6).put(4);
        intBuffer.put(9).put(4).put(6);
        intBuffer.put(10).put(5).put(7);
        intBuffer.put(11).put(7).put(5);
    }

    private void setTextureData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        Vector2f vector2f = new Vector2f();
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < 12; ++i) {
            BufferUtils.populateFromBuffer(vector3f, triangleBatch.getVertexBuffer(), i);
            vector2f.x = FastMath.abs(vector3f.z) < this.sideLength ? 0.5f * (1.0f + FastMath.atan2(vector3f.y, vector3f.x) * 0.31830987f) : 0.5f;
            vector2f.y = FastMath.acos(vector3f.z) * 0.31830987f;
            triangleBatch.getTextureBuffers().get(0).put(vector2f.x).put(vector2f.y);
        }
    }

    private void setNormalData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < 12; ++i) {
            BufferUtils.populateFromBuffer(vector3f, triangleBatch.getVertexBuffer(), i);
            vector3f.normalizeLocal();
            BufferUtils.setInBuffer(vector3f, triangleBatch.getNormalBuffer(), i);
        }
    }

    private void setVertexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        float f = 0.5f * (1.0f + FastMath.sqrt(5.0f));
        float f2 = 1.0f / FastMath.sqrt(1.0f + f * f);
        float f3 = f * f2 * this.sideLength;
        float f4 = f2 * this.sideLength;
        FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
        floatBuffer.rewind();
        floatBuffer.put(f3).put(f4).put(0.0f);
        floatBuffer.put(-f3).put(f4).put(0.0f);
        floatBuffer.put(f3).put(-f4).put(0.0f);
        floatBuffer.put(-f3).put(-f4).put(0.0f);
        floatBuffer.put(f4).put(0.0f).put(f3);
        floatBuffer.put(f4).put(0.0f).put(-f3);
        floatBuffer.put(-f4).put(0.0f).put(f3);
        floatBuffer.put(-f4).put(0.0f).put(-f3);
        floatBuffer.put(0.0f).put(f3).put(f4);
        floatBuffer.put(0.0f).put(-f3).put(f4);
        floatBuffer.put(0.0f).put(f3).put(-f4);
        floatBuffer.put(0.0f).put(-f3).put(-f4);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.sideLength, "sideLength", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.sideLength = inputCapsule.readInt("sideLength", 0);
    }
}

