/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.loginserver;

import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mmosf.server.loginserver.SingleProcess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingleProcessThread
implements Runnable {
    private static Log log = LogFactory.getLog(SingleProcessThread.class);
    protected int interval;
    protected List<SingleProcess> listSP = new LinkedList<SingleProcess>();

    public SingleProcessThread(int interval) {
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long next = System.currentTimeMillis();
        LinkedList<SingleProcess> copyList = new LinkedList<SingleProcess>();
        while (true) {
            next += (long)this.interval;
            List<SingleProcess> list = this.listSP;
            synchronized (list) {
                copyList.clear();
                copyList.addAll(this.listSP);
            }
            for (SingleProcess singleProcess : copyList) {
                try {
                    if (singleProcess.process()) continue;
                    this.removeProcess(singleProcess);
                }
                catch (Exception e) {
                    log.error("error in process", e);
                }
            }
            long interval = next - System.currentTimeMillis();
            if (interval < 0L) {
                log.warn("loop broken, interval = " + interval);
                continue;
            }
            try {
                Thread.sleep(interval);
                continue;
            }
            catch (InterruptedException e) {
                log.error("error in loop singleprocess sleep, ", e);
                continue;
            }
            break;
        }
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcess(SingleProcess process) {
        List<SingleProcess> list = this.listSP;
        synchronized (list) {
            this.listSP.add(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcess(SingleProcess process) {
        SingleProcessThread singleProcessThread = this;
        synchronized (singleProcessThread) {
            int index = this.listSP.indexOf(process);
            if (index == -1) {
                log.warn("remove invalid singleprocess.");
                return;
            }
            this.listSP.remove(index);
        }
    }
}

