/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server;

import java.io.IOException;
import java.util.Random;
import jp.sourceforge.mmosf.server.FatalIOError;
import jp.sourceforge.mmosf.server.MatchingServer;
import jp.sourceforge.mmosf.server.UserConnection;
import jp.sourceforge.mmosf.server.loginserver.SingleProcess;
import jp.sourceforge.mmosf.server.object.PlayerCharactor;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiveThread
extends SingleProcess
implements Runnable {
    private static final Log log = LogFactory.getLog(ReceiveThread.class);
    protected UserConnection conn;
    protected MatchingServer matching;
    protected int state;
    public static final int STATE_CONNECTING = 0;
    public static final int STATE_DATA_LOADING = 1;
    public static final int STATE_GAMING = 2;
    public static final int STATE_LOGOUT = 3;
    protected PlayerCharactor pc;

    public ReceiveThread(MatchingServer matching, UserConnection conn) {
        this.conn = conn;
        this.matching = matching;
        this.state = 0;
    }

    public void run() {
        if (!this.isValidConnect()) {
            log.error((Object)"invalid connect.");
            this.conn.close();
            return;
        }
        this.pc = this.processDataLoad();
        if (this.pc == null) {
            return;
        }
        while (true) {
            try {
                while (this.processMain(this.pc)) {
                    Thread.yield();
                }
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
            catch (Exception e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
        this.processLogout(this.pc);
    }

    protected void processLogout(PlayerCharactor pc) {
        if (pc != null) {
            this.matching.unregister(pc);
            log.info((Object)("logout:" + pc.getId()));
        }
        this.conn.close();
    }

    protected boolean processMain(PlayerCharactor pc) throws InterruptedException, PacketFormatException, IOException {
        Packet packet;
        block7: {
            block6: {
                if (!this.conn.isConnected()) {
                    this.state = 3;
                    return false;
                }
                if (this.conn.isFailedSending()) {
                    this.state = 3;
                    return false;
                }
                try {
                    if (this.conn.isReceive()) break block6;
                    return true;
                }
                catch (FatalIOError e) {
                    log.error((Object)"error in receive, ", (Throwable)e);
                    this.state = 3;
                    return false;
                }
            }
            packet = this.conn.receive();
            if (packet.getType() != 1) break block7;
            Packet ret = PacketFactory.createLogoutPacket(true);
            this.conn.send(ret);
            this.state = 3;
            return false;
        }
        this.matching.put(packet, pc);
        return true;
    }

    protected PlayerCharactor processDataLoad() {
        Random rd = new Random(this.conn.hashCode());
        PlayerCharactor pc = new PlayerCharactor(rd.nextInt(26) + 18, rd.nextInt(8) + 7, Character.valueOf((char)(65345 + rd.nextInt(26))), this.conn.hashCode(), this.conn);
        try {
            Packet retPacket = PacketFactory.createConnectResponsePcaket(pc.getId(), true);
            this.conn.send(retPacket);
        }
        catch (Throwable e) {
            log.error((Object)"connect response error.", e);
            this.state = 3;
            return null;
        }
        log.info((Object)("load player data:" + this.conn.sockManager.toString() + ":" + pc.getId()));
        this.matching.register(pc);
        return pc;
    }

    protected boolean isValidConnect() {
        boolean isValidConnect = false;
        long timeStart = System.currentTimeMillis();
        while (true) {
            try {
                while (this.processConnect()) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
            catch (Exception e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
        return this.state != 3;
    }

    protected boolean processConnect() throws PacketFormatException {
        if (!this.conn.isReceive()) {
            return true;
        }
        Packet packet = this.conn.receive();
        if (packet.getType() != 5) {
            this.state = 3;
            return false;
        }
        log.info((Object)("connect:" + this.conn.sockManager.toString() + ":" + this.conn.connectID));
        return false;
    }

    public boolean process() throws Exception {
        switch (this.state) {
            case 0: {
                if (this.processConnect()) break;
                if (this.state == 3) {
                    this.processLogout(null);
                    return false;
                }
                this.state = 1;
                break;
            }
            case 1: {
                this.pc = this.processDataLoad();
                if (this.pc == null) {
                    this.processLogout(null);
                    return false;
                }
                this.state = 2;
                break;
            }
            case 2: {
                if (this.processMain(this.pc) || this.state != 3) break;
                this.processLogout(this.pc);
                return false;
            }
            case 3: {
                this.processLogout(this.pc);
                return false;
            }
            default: {
                this.processLogout(this.pc);
                return false;
            }
        }
        return true;
    }
}

