/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.loginserver;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import jp.sourceforge.mmosf.server.db.NotFountAccountException;
import jp.sourceforge.mmosf.server.loginserver.LoginConnection;
import jp.sourceforge.mmosf.server.loginserver.LoginServer;
import jp.sourceforge.mmosf.server.loginserver.SingleProcess;
import jp.sourceforge.mmosf.server.packet.LoginPacket;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginThread
extends SingleProcess
implements Runnable {
    private static final Log log = LogFactory.getLog(LoginThread.class);
    protected LoginConnection conn;
    protected String random = null;
    protected LoginServer loginServer = null;

    public void run() {
        while (true) {
            try {
                while (this.process()) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                log.error((Object)"error in receive.", (Throwable)e);
                continue;
            }
            break;
        }
        try {
            this.conn.close();
        }
        catch (Exception e) {
            log.error((Object)"socket close error.", (Throwable)e);
        }
    }

    public boolean process() throws InterruptedException, PacketFormatException, NoSuchAlgorithmException, IOException {
        if (!this.conn.isConnected()) {
            return false;
        }
        if (this.conn.isTimeout()) {
            log.error((Object)"timeout.");
            return false;
        }
        if (!this.conn.isReceive()) {
            return true;
        }
        Packet pac = this.conn.receive();
        if (pac.getType() == 4) {
            Packet sendPacket = PacketFactory.createHelloPcaket(this.random);
            this.conn.send(sendPacket);
        } else {
            if (pac.getType() == 0) {
                Packet sendPacket = null;
                if (this.isLogin(pac)) {
                    String connectId = LoginPacket.digest(String.valueOf(pac.getString("userId")) + this.random);
                    this.loginServer.getListeningServer().reservLoginID(connectId);
                    sendPacket = PacketFactory.createLoginSuccessPcaket(this.loginServer.getListeningServer().getAddress(), connectId);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("send packet\n" + new String(sendPacket.toBytes().array())));
                    }
                } else {
                    sendPacket = PacketFactory.createLoginFailurePcaket();
                }
                this.conn.send(sendPacket);
                return false;
            }
            log.error((Object)"receive invalid packet.");
        }
        return true;
    }

    protected boolean isLogin(Packet pac) throws PacketFormatException, NoSuchAlgorithmException {
        String id;
        block3: {
            id = pac.getString("userId");
            String pass = pac.getString("password");
            String digest = null;
            digest = LoginPacket.digest(String.valueOf(this.loginServer.getAccountManager().getPassword(id)) + this.random);
            if (!digest.equals(pass)) break block3;
            return true;
        }
        try {
            log.error((Object)("userId=" + id + ", password error."));
        }
        catch (NotFountAccountException e) {
            log.error((Object)("userId=" + id), (Throwable)e);
        }
        return false;
    }

    public LoginThread(LoginServer server, LoginConnection conn) throws NoSuchAlgorithmException {
        this.conn = conn;
        this.loginServer = server;
        this.random = LoginPacket.digest(Long.toHexString(System.currentTimeMillis()));
    }
}

