/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.sync;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mmosf.server.loginserver.SingleProcess;
import jp.sourceforge.mmosf.server.loginserver.SingleProcessThread;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.PlayerCharactor;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.sync.AreaIndex;
import jp.sourceforge.mmosf.server.sync.SyncZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncArea
extends SingleProcess {
    private static final int UPDATE_INTERVAL = 600;
    private static Log log = LogFactory.getLog(SyncArea.class);
    protected List<PlayerCharactor> listConnection = new LinkedList<PlayerCharactor>();
    protected List<Mob> listMob = new LinkedList<Mob>();
    protected SyncZone parent;
    protected AreaIndex index = null;
    protected List<AreaIndex> listAroundIndex = null;
    private static SingleProcessThread updateTimer;

    SyncArea(AreaIndex index, SyncZone parent) {
        this.index = index;
        this.listAroundIndex = AreaIndex.getAreaIndexAround(index);
        this.parent = parent;
        if (updateTimer == null) {
            updateTimer = new SingleProcessThread(600);
            new Thread(updateTimer).start();
        }
    }

    public void startUpdateTimer() {
        updateTimer.addProcess(this);
    }

    public void stopUpdateTimer() {
        updateTimer.removeProcess(this);
    }

    public void sendPacket(Packet sendPacket) {
        for (PlayerCharactor pc : this.listConnection) {
            try {
                pc.conn.send(sendPacket);
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    public void update() {
        log.debug((Object)"update in");
        List<Mob> listMob = this.gatherMobAround();
        if (listMob.size() == 0) {
            log.debug((Object)"update out");
            return;
        }
        LinkedList<PlayerCharactor> listPC = new LinkedList<PlayerCharactor>();
        listPC.addAll(this.listConnection);
        for (PlayerCharactor pc : listPC) {
            try {
                pc.sendUpdate(listMob);
            }
            catch (Throwable e) {
                log.error((Object)"error in update, ", e);
            }
            log.debug((Object)("send update pc:" + pc.c));
        }
        log.debug((Object)"update out");
    }

    public List<Mob> gatherMobAround() {
        List<Mob> listMob = this.gatherMob();
        List<SyncArea> listArea = this.getSyncAreaAround();
        Iterator<SyncArea> itArea = listArea.iterator();
        while (itArea.hasNext()) {
            List<Mob> list = itArea.next().gatherMob();
            listMob.addAll(list);
        }
        return listMob;
    }

    public List<SyncArea> getSyncAreaAround() {
        List<AreaIndex> listIndex = this.getAroundIndex();
        LinkedList<SyncArea> list = new LinkedList<SyncArea>();
        for (AreaIndex index : listIndex) {
            list.add(this.parent.getSyncArea(index));
        }
        return list;
    }

    public List<Mob> gatherMob() {
        LinkedList<Mob> list = new LinkedList<Mob>();
        list.addAll(this.listConnection);
        list.addAll(this.listMob);
        return list;
    }

    public List<Mob> getCollision(MoveObject mo) {
        LinkedList<Mob> ret = new LinkedList<Mob>();
        List<Mob> list = this.gatherMob();
        for (Mob mob2 : list) {
            if (!mob2.moving.isCollision(mo)) continue;
            ret.add(mob2);
        }
        return ret;
    }

    public void in(PlayerCharactor pc) {
        if (this.listConnection.isEmpty()) {
            this.startUpdateTimer();
        }
        this.listConnection.add(pc);
        log.trace((Object)("pc(" + pc.getId() + ") in " + this.index));
    }

    public void in(Mob mob) {
        if (mob instanceof PlayerCharactor) {
            this.in((PlayerCharactor)mob);
            return;
        }
        this.listMob.add(mob);
        log.trace((Object)("npc(" + mob.getId() + ") in " + this.index));
    }

    public void out(PlayerCharactor pc) {
        log.trace((Object)("pc(" + pc.getId() + ") out " + this.index));
        int index = this.listConnection.indexOf(pc);
        if (index == -1) {
            log.error((Object)("lost pc in syncarea, index=" + this.index));
            return;
        }
        this.listConnection.remove(index);
        if (this.listConnection.isEmpty()) {
            this.stopUpdateTimer();
        }
    }

    public void out(Mob mob) {
        if (mob instanceof PlayerCharactor) {
            this.out((PlayerCharactor)mob);
            return;
        }
        int index = this.listMob.indexOf(mob);
        this.listMob.remove(index);
        log.trace((Object)("npc(" + mob.getId() + ") out " + this.index));
    }

    List<AreaIndex> getAroundIndex() {
        return this.listAroundIndex;
    }

    public Mob getMob(int id) {
        List<Mob> listMob = this.gatherMob();
        for (Mob mob : listMob) {
            if (mob.getId() != id) continue;
            return mob;
        }
        return null;
    }

    @Override
    public boolean process() {
        this.update();
        return true;
    }

    public boolean isCollision(MoveObject mo) {
        List<Mob> listTargetMob = this.getCollision(mo);
        if (mo.getSelfId() == null) {
            return listTargetMob.size() != 0;
        }
        int id = mo.getSelfId();
        for (Mob mob : listTargetMob) {
            if (mob.getId() == id) continue;
            return true;
        }
        return false;
    }
}

