/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.test;

import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.UpdateCache;
import jp.sourceforge.mmosf.server.packet.LoginPacket;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.UpdatePacket;
import org.junit.Assert;
import org.junit.Test;

public class TestStatic {
    @Test
    public void testToByte() {
        String str = "\u3042\u3081\u3093\u307c\u3042\u304b\u3044\u306a\u3042\u3044\u3046\u3048\u304a";
        byte[] data = str.getBytes();
        String hex = LoginPacket.toHexString(data);
        byte[] data2 = LoginPacket.toByte(hex);
        String hex2 = LoginPacket.toHexString(data2);
        Assert.assertTrue((boolean)hex2.equals(hex));
    }

    @Test
    public void testCreateUpdatePacket() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            LinkedList<Mob> list2 = new LinkedList<Mob>();
            Mob mob1 = new Mob(18, 27, Character.valueOf('A'), 1, 0);
            list.add(mob1);
            Packet packet = PacketFactory.createUpdatePacket(list, list2);
            LinkedList<Mob> ret = new LinkedList<Mob>();
            LinkedList<Mob> ret2 = new LinkedList<Mob>();
            PacketFactory.parseUpdatePacket((UpdatePacket)packet, ret, ret2);
            Assert.assertEquals((String)"size", (long)ret.size(), (long)1L);
            Mob mob2 = (Mob)ret.get(0);
            Assert.assertNotNull((String)"null", (Object)mob2);
            Assert.assertEquals((String)"x", (long)mob2.moving.getPosition().getX(), (long)mob1.moving.getPosition().getX());
            Assert.assertEquals((String)"y", (long)mob2.moving.getPosition().getY(), (long)mob1.moving.getPosition().getY());
            Assert.assertEquals((String)"c", (long)mob2.c, (long)mob1.c);
            Assert.assertEquals((long)ret2.size(), (long)0L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCachePickup1() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            LinkedList<Mob> list2 = new LinkedList<Mob>();
            LinkedList<Mob> list3 = new LinkedList<Mob>();
            cache.pickUpdate(list, list2, list3);
            Assert.assertEquals((long)list2.size(), (long)10L);
            Assert.assertEquals((long)list3.size(), (long)0L);
            LinkedList<Mob> list4 = new LinkedList<Mob>();
            LinkedList<Mob> list5 = new LinkedList<Mob>();
            cache.pickUpdate(list, list4, list5);
            Assert.assertEquals((long)list4.size(), (long)0L);
            Assert.assertEquals((long)list5.size(), (long)0L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCachePickup2() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            LinkedList<Mob> list2 = new LinkedList<Mob>();
            LinkedList<Mob> list3 = new LinkedList<Mob>();
            cache.pickUpdate(list, list2, list3);
            Assert.assertEquals((long)list2.size(), (long)10L);
            Assert.assertEquals((long)list3.size(), (long)0L);
            LinkedList<Mob> list4 = new LinkedList<Mob>();
            LinkedList<Mob> list5 = new LinkedList<Mob>();
            Mob mob1 = new Mob(18, 27, Character.valueOf('A'), 10, 0);
            list.add(mob1);
            cache.pickUpdate(list, list4, list5);
            Assert.assertEquals((long)list4.size(), (long)1L);
            Assert.assertEquals((long)list5.size(), (long)0L);
            LinkedList<Mob> list6 = new LinkedList<Mob>();
            LinkedList<Mob> list7 = new LinkedList<Mob>();
            cache.pickUpdate(list, list6, list7);
            Assert.assertEquals((long)list6.size(), (long)0L);
            Assert.assertEquals((long)list7.size(), (long)0L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCachePickup3() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            LinkedList<Mob> list2 = new LinkedList<Mob>();
            LinkedList<Mob> list3 = new LinkedList<Mob>();
            cache.pickUpdate(list, list2, list3);
            Assert.assertEquals((long)list2.size(), (long)10L);
            Assert.assertEquals((long)list3.size(), (long)0L);
            LinkedList<Mob> list4 = new LinkedList<Mob>();
            LinkedList<Mob> list5 = new LinkedList<Mob>();
            ((Mob)list.get((int)0)).moving.setPosition(new Position());
            cache.pickUpdate(list, list4, list5);
            Assert.assertEquals((long)list4.size(), (long)1L);
            Assert.assertEquals((long)list5.size(), (long)0L);
            LinkedList<Mob> list6 = new LinkedList<Mob>();
            LinkedList<Mob> list7 = new LinkedList<Mob>();
            cache.pickUpdate(list, list6, list7);
            Assert.assertEquals((long)list6.size(), (long)0L);
            Assert.assertEquals((long)list7.size(), (long)0L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCachePickup4() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            LinkedList<Mob> list2 = new LinkedList<Mob>();
            LinkedList<Mob> list3 = new LinkedList<Mob>();
            cache.pickUpdate(list, list2, list3);
            Assert.assertEquals((long)list2.size(), (long)10L);
            Assert.assertEquals((long)list3.size(), (long)0L);
            LinkedList<Mob> list4 = new LinkedList<Mob>();
            LinkedList<Mob> list5 = new LinkedList<Mob>();
            list.remove(3);
            cache.pickUpdate(list, list4, list5);
            Assert.assertEquals((long)list4.size(), (long)0L);
            Assert.assertEquals((long)list5.size(), (long)1L);
            LinkedList<Mob> list6 = new LinkedList<Mob>();
            LinkedList<Mob> list7 = new LinkedList<Mob>();
            cache.pickUpdate(list, list6, list7);
            Assert.assertEquals((long)list6.size(), (long)0L);
            Assert.assertEquals((long)list7.size(), (long)0L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCachePickup5() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            LinkedList<Mob> list2 = new LinkedList<Mob>();
            LinkedList<Mob> list3 = new LinkedList<Mob>();
            cache.pickUpdate(list, list2, list3);
            Assert.assertEquals((long)list2.size(), (long)10L);
            Assert.assertEquals((long)list3.size(), (long)0L);
            LinkedList<Mob> list4 = new LinkedList<Mob>();
            LinkedList<Mob> list5 = new LinkedList<Mob>();
            Mob mob1 = new Mob(18, 27, Character.valueOf('A'), 10, 0);
            list.add(mob1);
            list.remove(3);
            cache.pickUpdate(list, list4, list5);
            Assert.assertEquals((long)list4.size(), (long)1L);
            Assert.assertEquals((long)list5.size(), (long)1L);
            LinkedList<Mob> list6 = new LinkedList<Mob>();
            LinkedList<Mob> list7 = new LinkedList<Mob>();
            cache.pickUpdate(list, list6, list7);
            Assert.assertEquals((long)list6.size(), (long)0L);
            Assert.assertEquals((long)list7.size(), (long)0L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCachePickup6() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            LinkedList<Mob> list2 = new LinkedList<Mob>();
            LinkedList<Mob> list3 = new LinkedList<Mob>();
            cache.pickUpdate(list, list2, list3);
            Assert.assertEquals((long)list2.size(), (long)10L);
            Assert.assertEquals((long)list3.size(), (long)0L);
            LinkedList<Mob> list4 = new LinkedList<Mob>();
            LinkedList<Mob> list5 = new LinkedList<Mob>();
            ((Mob)list.get((int)0)).moving.setPosition(new Position());
            list.remove(3);
            cache.pickUpdate(list, list4, list5);
            Assert.assertEquals((long)list4.size(), (long)1L);
            Assert.assertEquals((long)list5.size(), (long)1L);
            LinkedList<Mob> list6 = new LinkedList<Mob>();
            LinkedList<Mob> list7 = new LinkedList<Mob>();
            cache.pickUpdate(list, list6, list7);
            Assert.assertEquals((long)list6.size(), (long)0L);
            Assert.assertEquals((long)list7.size(), (long)0L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCacheUpdate1() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            List<Mob> list2 = cache.update(list, null);
            Assert.assertEquals((long)list2.size(), (long)10L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCacheUpdate2() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            List<Mob> list2 = cache.update(list, null);
            Assert.assertEquals((long)list2.size(), (long)10L);
            Mob mob1 = new Mob(18, 27, Character.valueOf('A'), 10, 0);
            list.add(mob1);
            List<Mob> list3 = cache.update(list, null);
            Assert.assertEquals((long)list3.size(), (long)11L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCacheUpdate3() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            List<Mob> list2 = cache.update(list, null);
            Assert.assertEquals((long)list2.size(), (long)10L);
            ((Mob)list.get((int)0)).moving.setPosition(new Position());
            List<Mob> list3 = cache.update(list, null);
            Assert.assertEquals((long)list3.size(), (long)10L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCacheUpdate4() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            List<Mob> list2 = cache.update(list, null);
            Assert.assertEquals((long)list2.size(), (long)10L);
            list.remove(3);
            List<Mob> list3 = cache.update(list, null);
            Assert.assertEquals((long)list3.size(), (long)10L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUpdateCacheUpdate5() {
        try {
            LinkedList<Mob> list = new LinkedList<Mob>();
            int i = 0;
            while (i < 10) {
                Mob mob1 = new Mob(18, 27, Character.valueOf('A'), i, 0);
                list.add(mob1);
                ++i;
            }
            UpdateCache cache = new UpdateCache();
            List<Mob> list2 = cache.update(list, null);
            Assert.assertEquals((long)list2.size(), (long)10L);
            LinkedList<Mob> list3 = new LinkedList<Mob>();
            list3.add((Mob)list.get(3));
            list.remove(3);
            List<Mob> list4 = cache.update(list, list3);
            Assert.assertEquals((long)list4.size(), (long)9L);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }
}

