/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.timer;

import java.util.Timer;
import java.util.TimerTask;
import jp.sourceforge.mmosf.server.timer.TimerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerFactory {
    private static Log log = LogFactory.getLog(TimerFactory.class);

    public static Timer startTimer(TimerListener listener, long interval) {
        try {
            Timer timer = new Timer();
            MyTimer myTimer = new MyTimer(listener);
            timer.schedule((TimerTask)myTimer, interval, interval);
            return timer;
        }
        catch (Exception e) {
            log.error((Object)"timer start error.", (Throwable)e);
            return null;
        }
    }

    public static void stopTimer(Timer timer) {
        timer.cancel();
    }

    private static class MyTimer
    extends TimerTask {
        private TimerListener listener = null;

        public MyTimer(TimerListener listener) {
            this.listener = listener;
        }

        public void run() {
            this.listener.onTimer();
        }
    }
}

