/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jp.sourceforge.mmosf.admin.LocalMonitor;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InputProcess
implements Runnable,
KeyListener {
    private static Log log = LogFactory.getLog(InputProcess.class);
    protected KeyEvent keyEvent;
    protected boolean pressUp = false;
    protected boolean pressDown = false;
    protected boolean pressRight = false;
    protected boolean pressLeft = false;
    protected BlockingQueue<Vector> queueMove = new LinkedBlockingQueue<Vector>();
    protected static final int QUEUE_SIZE = 3;
    protected final int interval = 100;

    public void keyTyped(KeyEvent e) {
    }

    protected boolean isArrowKey(KeyEvent e, boolean isPress) {
        switch (e.getKeyCode()) {
            case 38: {
                this.pressUp = isPress;
                break;
            }
            case 40: {
                this.pressDown = isPress;
                break;
            }
            case 37: {
                this.pressLeft = isPress;
                break;
            }
            case 39: {
                this.pressRight = isPress;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected boolean isArrowKey2(KeyEvent e, boolean isPress) {
        switch (e.getKeyCode()) {
            case 87: {
                this.pressUp = isPress;
                break;
            }
            case 88: {
                this.pressDown = isPress;
                break;
            }
            case 65: {
                this.pressLeft = isPress;
                break;
            }
            case 68: {
                this.pressRight = isPress;
                break;
            }
            case 69: {
                this.pressUp = isPress;
                this.pressRight = isPress;
                break;
            }
            case 81: {
                this.pressUp = isPress;
                this.pressLeft = isPress;
                break;
            }
            case 67: {
                this.pressDown = isPress;
                this.pressRight = isPress;
                break;
            }
            case 90: {
                this.pressDown = isPress;
                this.pressLeft = isPress;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public abstract void send(Packet var1);

    public void move(int keyCode) {
        Vector v;
        switch (keyCode) {
            case 38: {
                v = Vector.NORTH;
                if (this.keyEvent != null && this.keyEvent.getKeyCode() == 39) {
                    v = Vector.NORTH_EAST;
                    break;
                }
                if (this.keyEvent == null || this.keyEvent.getKeyCode() != 37) break;
                v = Vector.NORTH_WEST;
                break;
            }
            case 40: {
                v = Vector.SOUTH;
                if (this.keyEvent != null && this.keyEvent.getKeyCode() == 39) {
                    v = Vector.SOUTH_EAST;
                    break;
                }
                if (this.keyEvent == null || this.keyEvent.getKeyCode() != 37) break;
                v = Vector.SOUTH_WEST;
                break;
            }
            case 37: {
                v = Vector.WEST;
                if (this.keyEvent != null && this.keyEvent.getKeyCode() == 38) {
                    v = Vector.NORTH_WEST;
                    break;
                }
                if (this.keyEvent == null || this.keyEvent.getKeyCode() != 40) break;
                v = Vector.SOUTH_WEST;
                break;
            }
            case 39: {
                v = Vector.EAST;
                if (this.keyEvent != null && this.keyEvent.getKeyCode() == 38) {
                    v = Vector.NORTH_EAST;
                    break;
                }
                if (this.keyEvent == null || this.keyEvent.getKeyCode() != 40) break;
                v = Vector.SOUTH_EAST;
                break;
            }
            default: {
                return;
            }
        }
        if (this.queueMove.size() < 3) {
            try {
                this.queueMove.put(v);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stop() {
        try {
            if (this.queueMove.size() < 4) {
                this.queueMove.put(Vector.ZERO);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void send(Vector vec) {
        try {
            LocalMonitor.getMonitor().log("input vector:" + this.getVector().toString());
            if (vec.isZero()) {
                if (this.queueMove.size() < 4) {
                    this.queueMove.put(Vector.ZERO);
                }
            } else if (this.queueMove.size() < 3) {
                this.queueMove.put(vec);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Vector getVector() {
        Vector v = Vector.ZERO;
        int vertical = 0;
        if (this.pressUp && !this.pressDown) {
            vertical = -1;
        } else if (!this.pressUp && this.pressDown) {
            vertical = 1;
        }
        int horizonal = 0;
        if (this.pressRight && !this.pressLeft) {
            horizonal = 1;
        } else if (!this.pressRight && this.pressLeft) {
            horizonal = -1;
        }
        if (vertical == -1 && horizonal == 0) {
            v = Vector.NORTH_EAST;
        } else if (vertical == 1 && horizonal == 0) {
            v = Vector.SOUTH_WEST;
        } else if (vertical == 0 && horizonal == 1) {
            v = Vector.SOUTH_EAST;
        } else if (vertical == 0 && horizonal == -1) {
            v = Vector.NORTH_WEST;
        } else if (vertical == -1 && horizonal == 1) {
            v = Vector.EAST;
        } else if (vertical == -1 && horizonal == -1) {
            v = Vector.NORTH;
        } else if (vertical == 1 && horizonal == 1) {
            v = Vector.SOUTH;
        } else if (vertical == 1 && horizonal == -1) {
            v = Vector.WEST;
        }
        return v;
    }

    public void keyReleased(KeyEvent e) {
        log.trace("release," + e.getKeyCode());
        if (this.isArrowKey(e, false) || this.isArrowKey2(e, false)) {
            this.send(this.getVector());
        }
        this.keyEvent = null;
    }

    public void keyPressed(KeyEvent e) {
        log.trace("pressed," + e.getKeyCode());
        if (!this.isKeyDown(e)) {
            return;
        }
        if (this.isArrowKey(e, true) || this.isArrowKey2(e, true)) {
            this.send(this.getVector());
        }
        this.keyEvent = e;
    }

    protected boolean isKeyDown(KeyEvent e) {
        if (this.keyEvent == null) {
            return true;
        }
        return this.keyEvent.getKeyCode() != e.getKeyCode();
    }

    public void run() {
        while (!this.isLogout()) {
            this.send();
            Thread.yield();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send() {
        try {
            Vector v = this.queueMove.take();
            if (this.isLogout()) {
                return;
            }
            while (v != null && v.isZero() && !this.queueMove.isEmpty()) {
                v = this.queueMove.take();
            }
            if (v == null) return;
            Packet packet = PacketFactory.createMovePacket(v);
            this.send(packet);
            LocalMonitor.getMonitor().log("send input:", packet);
            return;
        }
        catch (InterruptedException e) {
            log.error("error in send move packet, ", e);
            return;
        }
        catch (Exception e) {
            log.error("error in send move packet, ", e);
        }
    }

    public abstract boolean isLogout();
}

