/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import jp.sourceforge.mmosf.client.sample.JMessageLabel;
import jp.sourceforge.mmosf.server.object.ChatMessage;

public class JScrollMessageLabel
extends JMessageLabel {
    protected JScrollPane pane;
    private static final long serialVersionUID = 1L;
    private int scroll;
    protected int width;
    protected int height;
    protected Point pt;

    public JScrollMessageLabel() {
        this.initScrollPane();
    }

    public JScrollMessageLabel(String arg0) {
        super(arg0);
        this.initScrollPane();
    }

    public JScrollMessageLabel(Icon arg0) {
        super(arg0);
        this.initScrollPane();
    }

    public JScrollMessageLabel(String arg0, int arg1) {
        super(arg0, arg1);
        this.initScrollPane();
    }

    public JScrollMessageLabel(Icon arg0, int arg1) {
        super(arg0, arg1);
        this.initScrollPane();
    }

    public JScrollMessageLabel(String arg0, Icon arg1, int arg2) {
        super(arg0, arg1, arg2);
        this.initScrollPane();
    }

    protected void initScrollPane() {
        this.pane = new JScrollPane(this, 22, 31);
        Dimension dim = this.pane.getPreferredSize();
        this.pane.setPreferredSize(new Dimension(dim.width, 130));
        LocalComponentListener listener = new LocalComponentListener(){

            public void componentResized(ComponentEvent e) {
                JScrollMessageLabel.this.scrollLastMessage();
            }
        };
        this.addComponentListener(listener);
        LocalComponentListener listener2 = new LocalComponentListener(){

            public void componentResized(ComponentEvent e) {
                JScrollMessageLabel.this.resizeScrollPane();
            }
        };
        this.pane.addComponentListener(listener2);
        this.scroll = 0;
    }

    public JScrollPane getScrollPane() {
        return this.pane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addMessage(ChatMessage message) {
        JScrollMessageLabel jScrollMessageLabel = this;
        synchronized (jScrollMessageLabel) {
            this.pt = this.pane.getViewport().getViewPosition();
            int scroll = super.addMessage(message);
            this.revalidate();
            this.validate();
        }
        return this.scroll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void autoScrollMessageLabel() {
        JScrollMessageLabel jScrollMessageLabel = this;
        synchronized (jScrollMessageLabel) {
            if (!this.isFinishParseHTML()) {
                this.setPreferredSize(new Dimension(this.width, this.getMinimumSize().height));
                return;
            }
            int height2 = this.getMinimumSize().height;
            if (!this.isEnableScroll()) {
                this.height = height2;
                return;
            }
            this.scroll += height2 - this.height;
            if (this.scroll == 0) {
                return;
            }
            JViewport vp = this.pane.getViewport();
            this.pt.y += this.scroll;
            vp.setViewPosition(this.pt);
            this.scroll = 0;
            this.height = height2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrollLastMessage() {
        JScrollMessageLabel jScrollMessageLabel = this;
        synchronized (jScrollMessageLabel) {
            if (!this.isFinishParseHTML()) {
                this.setPreferredSize(new Dimension(this.width, this.getMinimumSize().height));
                return;
            }
            int height2 = this.getMinimumSize().height;
            if (!this.isEnableScroll()) {
                this.height = height2;
                return;
            }
            JViewport vp = this.pane.getViewport();
            this.pt.y = vp.getMaximumSize().height;
            vp.setViewPosition(this.pt);
        }
    }

    private boolean isFinishParseHTML() {
        return this.getMinimumSize().height == this.getPreferredSize().height;
    }

    private boolean isEnableScroll() {
        return this.pane.getSize().height < this.getMinimumSize().height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resizeScrollPane() {
        JScrollMessageLabel jScrollMessageLabel = this;
        synchronized (jScrollMessageLabel) {
            Dimension dim = this.pane.getViewport().getExtentSize();
            this.width = dim.width;
        }
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paintComponent(g2d);
    }

    protected int redrawMessage() {
        Dimension dimBefore2 = this.getMinimumSize();
        StringBuffer sb = new StringBuffer();
        sb.append("<html><div style=\"width:100%\">");
        int i = 0;
        while (i < this.messageList.size()) {
            String color;
            if (i > 0) {
                sb.append("<br>");
            }
            ChatMessage chat = (ChatMessage)this.messageList.get(i);
            String prefix = null;
            switch (chat.type) {
                case 1: {
                    color = "black";
                    prefix = "(say)";
                    break;
                }
                case 2: {
                    color = "green";
                    prefix = "(tell)";
                    break;
                }
                case 0: {
                    color = "blue";
                    break;
                }
                default: {
                    color = "gray";
                }
            }
            sb.append("<font style=\"color:" + color + "\">");
            if (prefix != null && prefix.length() != 0) {
                sb.append(prefix);
                sb.append(chat.speaker);
                sb.append(":");
            }
            sb.append(((ChatMessage)this.messageList.get((int)i)).message);
            sb.append("</font>");
            ++i;
        }
        sb.append("</div></html>");
        this.setText(sb.toString());
        Dimension dimAfter2 = this.getMinimumSize();
        this.setPreferredSize(new Dimension(this.width, dimAfter2.height));
        return dimAfter2.height - dimBefore2.height;
    }

    protected class LocalComponentListener
    implements ComponentListener {
        protected LocalComponentListener() {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }
    }
}

