/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample.jme;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.CloneImportExport;
import com.jme.util.TextureManager;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.animation.KeyframeController;
import com.jmex.model.converters.Md3ToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mmosf.client.sample.jme.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimationModelObject
extends ModelObject {
    public static final int ANIME_TYPE_DEFAULT = 0;
    public static final int ANIME_TYPE_STOP = 1;
    public static final int ANIME_TYPE_MOVE = 2;
    protected static HashMap<String, CloneImportExport> map2;
    protected static HashMap<String, Texture> map3;
    protected static DisplaySystem displaySystem;
    private int typeAnimation = 0;
    private MotionFrame motion = null;
    private HashMap<Integer, MotionFrame> mapMotion = new HashMap();

    public static void setDisplaySystem(DisplaySystem displaySystem) {
        AnimationModelObject.displaySystem = displaySystem;
    }

    protected AnimationModelObject() {
    }

    protected static Map<String, CloneImportExport> getCloningModelMap() {
        if (map2 == null) {
            map2 = new HashMap();
        }
        return map2;
    }

    protected static Map<String, Texture> getTextureMap() {
        if (map3 == null) {
            map3 = new HashMap();
        }
        return map3;
    }

    protected static TriMesh getAnimatedMob(URL objPath, URL texturePath, Quaternion defaultRotation, String name, float fsize) {
        TriMesh model;
        CloneImportExport cie = AnimationModelObject.getCloningModelMap().get(objPath.toString());
        if (cie == null) {
            cie = new CloneImportExport();
            cie.saveClone((Savable)AnimationModelObject.loadMd3(objPath, texturePath));
            AnimationModelObject.getCloningModelMap().put(objPath.toString(), cie);
        }
        if ((model = (TriMesh)cie.loadClone()).getController(0) != null) {
            model.getController(0).setSpeed(24.0f);
        }
        model.setModelBound((BoundingVolume)new BoundingBox());
        model.updateModelBound();
        model.setName(name);
        if (texturePath != null) {
            TextureState ts = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            Texture tx = AnimationModelObject.getTextureMap().get(texturePath.toString());
            if (tx == null) {
                tx = TextureManager.loadTexture((URL)texturePath);
                AnimationModelObject.getTextureMap().put(texturePath.toString(), tx);
            }
            ts.setEnabled(true);
            ts.setTexture(tx);
            model.setRenderState((RenderState)ts);
            model.setTextureCombineMode(5);
        }
        model.setLocalScale(fsize);
        model.setLocalRotation(defaultRotation);
        return model;
    }

    protected static TriMesh loadMd3(URL objFile, URL textureFile) {
        TriMesh model = null;
        Md3ToJme converter = new Md3ToJme();
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            converter.convert(objFile.openStream(), (OutputStream)os);
            if (converter.getController() != null) {
                converter.getController().setRepeatType(2);
            }
            Node node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(os.toByteArray()));
            model = (TriMesh)node.getChild(0);
        }
        catch (Exception e) {
            ModelObject.log.error("error in load obj, ", e);
        }
        return model;
    }

    public static AnimationModelObject getAnimatedModel(URL objPath, URL texturePath, Quaternion defaultRotation, String name, float scale, int visual) {
        AnimationModelObject obj = new AnimationModelObject();
        obj.mesh = AnimationModelObject.getAnimatedMob(objPath, texturePath, defaultRotation, name, scale);
        obj.nodeRotation = new Node();
        obj.nodeRotation.attachChild((Spatial)obj.mesh);
        obj.nodeTranslation = new Node(name);
        obj.nodeTranslation.attachChild((Spatial)obj.nodeRotation);
        obj.scale = scale;
        obj.size = 1;
        obj.visual = visual;
        return obj;
    }

    public void startAnimation() {
        for (Controller controller : this.mesh.getControllers()) {
            if (!(controller instanceof KeyframeController)) continue;
            KeyframeController keyCtrl = (KeyframeController)controller;
            if (this.typeAnimation == 2) continue;
            keyCtrl.setNewAnimationTimes(10.0f, 29.0f);
            keyCtrl.setSpeed(24.0f);
            this.typeAnimation = 2;
        }
    }

    public void stopAnimation() {
        for (Controller controller : this.mesh.getControllers()) {
            if (!(controller instanceof KeyframeController)) continue;
            KeyframeController keyCtrl = (KeyframeController)controller;
            if (this.typeAnimation == 1) continue;
            keyCtrl.setNewAnimationTimes(0.0f, 9.0f);
            keyCtrl.setSpeed(2.0f);
            this.typeAnimation = 1;
        }
    }

    public boolean setMotion(int index) {
        MotionFrame mf = this.mapMotion.get(index);
        if (mf == null) {
            return false;
        }
        for (Controller controller : this.mesh.getControllers()) {
            if (!(controller instanceof KeyframeController)) continue;
            KeyframeController keyCtrl = (KeyframeController)controller;
            if (mf.equals(this.motion)) continue;
            keyCtrl.setNewAnimationTimes(mf.start, mf.end);
            keyCtrl.setSpeed(mf.speed);
            this.motion = mf;
        }
        return true;
    }

    public void setMotionFrame(int index, float start, float end, float speed) {
        MotionFrame mf = new MotionFrame(start, end, speed);
        this.mapMotion.put(index, mf);
    }

    private class MotionFrame {
        public final float start;
        public final float end;
        public final float speed;

        public MotionFrame(float start, float end, float speed) {
            this.start = start;
            this.end = end;
            this.speed = speed;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Float.floatToIntBits(this.end);
            result = 31 * result + Float.floatToIntBits(this.speed);
            result = 31 * result + Float.floatToIntBits(this.start);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MotionFrame other = (MotionFrame)obj;
            if (Float.floatToIntBits(this.end) != Float.floatToIntBits(other.end)) {
                return false;
            }
            if (Float.floatToIntBits(this.speed) != Float.floatToIntBits(other.speed)) {
                return false;
            }
            return Float.floatToIntBits(this.start) == Float.floatToIntBits(other.start);
        }
    }
}

