/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample.jme;

import com.jme.animation.SpatialTransformer;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.intersection.BoundingPickResults;
import com.jme.intersection.PickResults;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Arrow;
import com.jme.scene.shape.Box;
import com.jme.system.DisplaySystem;
import com.jme.system.SystemProvider;
import com.jme.system.lwjgl.LWJGLDisplaySystem;
import com.jme.util.geom.BufferUtils;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jp.sourceforge.mmosf.admin.LocalMonitor;
import jp.sourceforge.mmosf.client.sample.jme.AnimationModelObject;
import jp.sourceforge.mmosf.client.sample.jme.ModelObject;
import jp.sourceforge.mmosf.client.sample.jme.ModelObjectFactory;
import jp.sourceforge.mmosf.client.sample.jme.SampleClientFrame;
import jp.sourceforge.mmosf.client.sample.jme.SampleJMEPanel;
import jp.sourceforge.mmosf.server.level.GeomapData;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MovingVector;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.packet.MovePacket;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuarterViewPanel
extends SampleJMEPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(QuarterViewPanel.class);
    public GeomapData map;
    private Node nodeMap;
    private Node nodeChar;
    private Node nodeRotate1;
    private Node nodeRotate2;
    private Node nodeOffset;
    protected Mob self;
    protected Mob oldSelf;
    protected List<Mob> listMob;
    protected BlockingQueue<Mob> listDeleteMob;
    private float fsize = 0.2f;
    private Vector3f min = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f max = new Vector3f(this.fsize, this.fsize, this.fsize);
    private ModelObject myChar2;
    private ModelObject myChar3;
    private float angle = 1.0f;
    private float length = -80.0f / this.angle;
    protected Point p;
    protected Map<Spatial, Mob> mapSpatialMob;
    protected Map<Integer, ModelObject> mapMobModel;
    protected Mob selectedMob = null;
    protected TriMesh cursol;
    protected SampleClientFrame frame;
    private Position oldPos;

    public QuarterViewPanel() {
        this.listDeleteMob = new LinkedBlockingQueue<Mob>();
    }

    public QuarterViewPanel(GeomapData data) {
        this.setMap(data);
        this.listDeleteMob = new LinkedBlockingQueue<Mob>();
    }

    public void setFrame(SampleClientFrame frame) {
        this.frame = frame;
    }

    @Override
    protected void simpleSetup2() {
        this.getRootNode().detachAllChildren();
        this.nodeChar = new Node();
        this.nodeOffset = new Node();
        this.nodeRotate1 = new Node();
        this.nodeRotate2 = new Node();
        this.initGround();
        AnimationModelObject.setDisplaySystem(this.display);
        this.myChar2 = ModelObjectFactory.createMan("self", this.fsize, 0);
        this.myChar3 = ModelObjectFactory.createMan("self2", this.fsize, 10);
        this.myChar3.getMesh().setDefaultColor(ColorRGBA.magenta);
        this.myChar2.getNodeTranslation().setLocalTranslation(0.0f, 0.0f, 0.0f);
        this.myChar3.getNodeTranslation().setLocalTranslation(0.0f, 0.0f, 0.0f);
        this.cursol = new Arrow("cursol", 1.0f * this.fsize, 0.5f * this.fsize);
        Quaternion q = new Quaternion();
        q.fromAngles(0.0f, 0.0f, (float)Math.PI);
        this.cursol.setLocalRotation(q);
        this.cursol.setDefaultColor(ColorRGBA.red);
        this.cursol.setTextureCombineMode(0);
        this.nodeChar.attachChild(this.myChar2.getObject());
        this.nodeChar.attachChild(this.myChar3.getObject());
        this.nodeMap.attachChild((Spatial)this.nodeChar);
        this.nodeOffset.attachChild((Spatial)this.nodeMap);
        this.nodeRotate1.attachChild((Spatial)this.nodeOffset);
        this.nodeRotate2.attachChild((Spatial)this.nodeRotate1);
        this.getCamea().setParallelProjection(true);
        this.resizeCamera(this.getCamea(), this.comp.getWidth(), this.comp.getHeight());
        this.setAngle();
        this.getRootNode().setLocalTranslation(0.0f, 0.0f, this.length);
        this.getRootNode().attachChild((Spatial)this.nodeRotate2);
        this.comp.addMouseListener(this);
        this.mapSpatialMob = new HashMap<Spatial, Mob>();
        this.mapMobModel = new HashMap<Integer, ModelObject>();
    }

    private void setAngle() {
        Quaternion rote1 = new Quaternion();
        rote1.fromAngles(0.3926991f, 0.0f, 0.0f);
        this.nodeRotate2.setLocalRotation(rote1);
        Quaternion rote2 = new Quaternion();
        rote2.fromAngles(0.0f, 0.7853982f, 0.0f);
        this.nodeRotate1.setLocalRotation(rote2);
    }

    public void initGround() {
        System.out.println(System.currentTimeMillis());
        TriMesh src_quad = this.getQuad("src_quad", this.max.x, this.max.y);
        src_quad.setRandomColors();
        Box src_box = new Box("src_box", this.min, this.max);
        src_box.setRandomColors();
        this.nodeMap = new Node();
        int i = 0;
        while (i < this.map.getMapHeight()) {
            int j = 0;
            while (j < this.map.getMapWidth()) {
                SharedMesh box;
                if (this.map.map[i][j] != '\uff38') {
                    box = new SharedMesh(String.valueOf(i) + "," + j, src_quad);
                    box.setModelBound((BoundingVolume)new BoundingBox());
                    Vector3f vec = this.createVector3f(j, i);
                    vec.y = 0.0f;
                    box.setLocalTranslation(vec);
                    this.nodeMap.attachChild((Spatial)box);
                } else {
                    box = new SharedMesh(String.valueOf(i) + "," + j, (TriMesh)src_box);
                    box.setModelBound((BoundingVolume)new BoundingBox());
                    box.setLocalTranslation(this.createVector3f(j, i));
                    this.nodeMap.attachChild((Spatial)box);
                }
                ++j;
            }
            ++i;
        }
    }

    TriMesh getQuad(String name, float x, float z) {
        TriMesh m = new TriMesh("Quad");
        Vector3f[] vertexes = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(x, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, z), new Vector3f(x, 0.0f, z)};
        Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};
        ColorRGBA[] colors = new ColorRGBA[]{new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f), new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f), new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f), new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f)};
        Vector2f[] texCoords = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f)};
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 3;
        int[] indexes = nArray;
        m.reconstruct(BufferUtils.createFloatBuffer((Vector3f[])vertexes), BufferUtils.createFloatBuffer((Vector3f[])normals), BufferUtils.createFloatBuffer((ColorRGBA[])colors), BufferUtils.createFloatBuffer((Vector2f[])texCoords), BufferUtils.createIntBuffer((int[])indexes));
        return m;
    }

    private Vector3f createVector3f(int x, int z) {
        return new Vector3f((float)(x - this.map.getMapWidth() / 2) * this.fsize, 0.0f, (float)(z - this.map.getMapHeight() / 2) * this.fsize);
    }

    @Override
    protected void simpleUpdate2() {
        try {
            if (this.self != null) {
                this.moveSelf2();
            }
            if (this.listMob != null) {
                this.moveMob();
            }
            if (this.listDeleteMob.size() > 0) {
                while (this.listDeleteMob.size() > 0) {
                    Mob mob = this.listDeleteMob.take();
                    ModelObject obj = this.mapMobModel.get(mob.getId());
                    if (obj == null) continue;
                    this.nodeChar.detachChild(obj.getObject());
                    this.mapMobModel.remove(mob.getId());
                    this.mapSpatialMob.remove(obj.getObject());
                    obj.clear();
                }
            }
            if (this.p != null) {
                this.selectMob(this.p);
                this.p = null;
            }
            this.dispCursol();
        }
        catch (Exception e) {
            log.error("error in simpleUpdate2,", e);
        }
    }

    protected void selectMob(Point pt) {
        Spatial sp = this.getSelectedSpatial(pt);
        if (sp != null) {
            this.selectedMob = this.mapSpatialMob.get(sp);
            this.frame.selectMob(this.selectedMob);
        }
    }

    protected Spatial getSelectedSpatial(Point pt) {
        Geometry sp = null;
        Vector2f screenPos = new Vector2f();
        screenPos.set((float)pt.x, (float)pt.y);
        SystemProvider systemProvider = LWJGLDisplaySystem.getSystemProvider();
        DisplaySystem displaySystem = systemProvider.getDisplaySystem();
        Ray mouseRay = displaySystem.getPickRay(screenPos, true, null);
        BoundingPickResults pr = new BoundingPickResults();
        pr.clear();
        this.getRootNode().findPick(mouseRay, (PickResults)pr);
        int i = 0;
        while (i < pr.getNumber()) {
            sp = pr.getPickData(i).getTargetMesh().getParentGeom();
            ++i;
        }
        return sp;
    }

    protected void moveMob() {
        for (Mob mob : this.listMob) {
            if (mob.getId() == this.self.getId()) continue;
            ModelObject obj = this.mapMobModel.get(mob.getId());
            if (obj != null && obj.getVisual() != mob.vis.getVtype()) {
                this.nodeChar.detachChild(obj.getObject());
                this.mapMobModel.remove(mob.getId());
                this.mapSpatialMob.remove(obj.getObject());
                obj = null;
            }
            if (obj == null) {
                ModelObject obj2 = this.getModelObject(mob);
                this.nodeChar.attachChild(obj2.getObject());
                obj2.getMesh().updateRenderState();
                obj = obj2;
                this.mapSpatialMob.put((Spatial)obj2.getMesh(), mob);
                this.mapMobModel.put(mob.getId(), obj2);
            }
            this.setAnimation2(obj, mob.moving.getPosition(), null, mob.moving.getVector(), mob.moving.getSpeed(), mob.moving.getDirection(), false, 3.6f);
            this.mapSpatialMob.get((Object)obj.getMesh()).moving.setPosition(mob.moving.getPosition());
        }
    }

    private ModelObject getModelObject(Mob mob) {
        ModelObject obj2 = null;
        ColorRGBA color = null;
        AnimationModelObject.setDisplaySystem(this.display);
        switch (mob.vis.getVtype()) {
            case 0: {
                obj2 = ModelObjectFactory.createMan(Integer.toString(mob.getId()), this.fsize * 0.8f, mob.vis.getVtype());
                break;
            }
            case 1: {
                color = ColorRGBA.red;
                obj2 = ModelObjectFactory.createMan(Integer.toString(mob.getId()), this.fsize, mob.vis.getVtype());
                break;
            }
            case 2: {
                color = ColorRGBA.brown;
                obj2 = ModelObjectFactory.createTree(Integer.toString(mob.getId()), this.fsize, mob.vis.getVtype());
                break;
            }
            case 3: {
                color = ColorRGBA.red;
                color.a = 0.1f;
                obj2 = ModelObjectFactory.createFire(Integer.toString(mob.getId()), this.fsize, mob.vis.getVtype());
                break;
            }
            case 4: {
                obj2 = ModelObjectFactory.createMan(Integer.toString(mob.getId()), this.fsize, mob.vis.getVtype());
                break;
            }
            case 5: {
                color = ColorRGBA.darkGray;
                obj2 = ModelObjectFactory.createDoorClose(Integer.toString(mob.getId()), this.fsize, mob.vis.getVtype());
                break;
            }
            case 6: {
                color = ColorRGBA.darkGray;
                obj2 = ModelObjectFactory.createDoorOpen(Integer.toString(mob.getId()), this.fsize, mob.vis.getVtype());
                break;
            }
            default: {
                color = ColorRGBA.randomColor();
                obj2 = ModelObjectFactory.createMan(Integer.toString(mob.getId()), this.fsize, mob.vis.getVtype());
            }
        }
        return obj2;
    }

    private Vector3f createVector3f(Mob mob) {
        return this.createVector3f(mob.moving.getPosition().getX(), mob.moving.getPosition().getY());
    }

    protected void moveSelf2() {
        float frame = 1.9f;
        this.setAnimation2(this.myChar2, this.self.moving.getPosition(), this.oldPos, this.self.moving.getVector(), this.self.moving.getSpeed(), this.self.moving.getDirection(), true, frame);
        this.oldSelf = this.self;
    }

    private void setAnimation2(ModelObject obj, Position pos, Position oldPos, Vector vec, double speed, Vector direction, boolean isScroll, float frame) {
        if (oldPos == null) {
            oldPos = pos;
        }
        if (!vec.isZero() && oldPos.equals(pos)) {
            Vector3f animeEnd;
            if (!this.isAnimateEnd((Spatial)obj.getNodeTranslation())) {
                return;
            }
            Vector3f now = this.getNowPosition((Spatial)obj.getNodeTranslation());
            if (now == null) {
                now = this.createVector3f(pos.getX(), pos.getY());
            }
            if ((animeEnd = this.getEndPosition((Spatial)obj.getNodeTranslation())) == null) {
                animeEnd = this.createVector3f(pos.getX(), pos.getY());
            }
            if (obj instanceof AnimationModelObject) {
                AnimationModelObject amo = (AnimationModelObject)obj;
                amo.startAnimation();
                LocalMonitor.getMonitor().log("start animation");
            }
            Vector next = vec.getDirection();
            Vector3f end = animeEnd.add(new Vector3f((float)next.getdX(), 0.0f, (float)next.getdY()));
            if (isScroll) {
                this.moveSmooth((Spatial)this.nodeOffset, now.negate(), end.negate(), frame);
            }
            this.moveSmooth((Spatial)obj.getNodeTranslation(), now, end, frame);
            obj.setDirection(direction);
        } else {
            Vector3f now = this.getNowPosition((Spatial)obj.getNodeTranslation());
            if (now == null) {
                now = this.createVector3f(pos.getX(), pos.getY());
            }
            Vector3f newStart = this.createVector3f(pos.getX(), pos.getY());
            Vector next = vec.getDirection();
            Vector3f end = newStart.add(new Vector3f((float)next.getdX(), 0.0f, (float)next.getdY()));
            if (vec.isZero()) {
                frame = this.adjustAnimeSpeed(frame, now.distance(end));
            }
            if (obj instanceof AnimationModelObject) {
                AnimationModelObject amo = (AnimationModelObject)obj;
                if (frame <= 0.1f) {
                    amo.stopAnimation();
                    LocalMonitor.getMonitor().log("stop animation");
                } else {
                    amo.startAnimation();
                    LocalMonitor.getMonitor().log("start animation");
                }
            }
            if (isScroll) {
                this.moveSmooth((Spatial)this.nodeOffset, now.negate(), end.negate(), frame);
            }
            this.moveSmooth((Spatial)obj.getNodeTranslation(), now, end, frame);
            obj.setDirection(direction);
            this.oldPos = pos;
        }
    }

    private float adjustAnimeSpeed(float frame, float distance) {
        float adjust = distance / (this.fsize * 2.0f);
        if (adjust < frame) {
            frame = adjust;
        }
        if (frame < 0.1f) {
            frame = 0.1f;
        }
        return frame;
    }

    private void moveSmooth(Spatial target, Vector3f start, Vector3f end, float speed) {
        ArrayList list = target.getControllers();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Controller controller = (Controller)it.next();
            if (!(controller instanceof SpatialTransformer)) continue;
            it.remove();
        }
        SpatialTransformer st = new SpatialTransformer(1);
        st.setObject(target, 0, -1);
        st.setPosition(0, 0.0f, start);
        st.setPosition(0, speed, end);
        st.interpolateMissing();
        target.addController((Controller)st);
    }

    protected void dispCursol() {
        if (this.selectedMob != null) {
            if (!this.nodeChar.hasChild((Spatial)this.cursol)) {
                this.nodeChar.attachChild((Spatial)this.cursol);
                this.cursol.updateRenderState();
            }
            Vector3f v = this.createVector3f(this.selectedMob);
            Vector3f v2 = this.cursol.getLocalTranslation();
            if (v.x == v2.x && v.y == v2.y) {
                return;
            }
            v.x += 0.5f * this.fsize;
            v.y += 4.0f * this.fsize;
            v.z += 0.5f * this.fsize;
            this.cursol.setLocalTranslation(v);
        } else if (this.nodeChar.hasChild((Spatial)this.cursol)) {
            this.nodeChar.detachChild((Spatial)this.cursol);
        }
    }

    protected void resizeCamera(Camera camea, int width, int height) {
        Vector2f rect = this.getCameraRect(width, height);
        float offset = 0.0f;
        camea.setFrustum(1.0f, 1000.0f, -rect.x / 2.0f + offset, rect.x / 2.0f - offset, -rect.y / 2.0f + offset, rect.y / 2.0f - offset);
    }

    protected Vector2f getCameraRect(float width, float height) {
        Vector2f rect = new Vector2f();
        float aspect = 1.3333334f;
        float width2 = this.fsize * 20.0f;
        float height2 = this.fsize * 20.0f;
        if (width / height < aspect) {
            width2 = width / height * height2;
        } else {
            height2 = width2 / (width / height);
        }
        rect.set(width2, height2);
        return rect;
    }

    public void setMap(GeomapData map) {
        this.map = map;
    }

    public void update(Mob self, List<Mob> listUpdate, List<Mob> listDelete) {
        this.oldSelf = this.self;
        this.self = self;
        this.frame.logTimeMove();
        this.listMob = listUpdate;
        for (Mob mob : listDelete) {
            try {
                this.listDeleteMob.put(mob);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected int getOffset(int pos, int viewSize, int mapSize) {
        int Offset = pos - viewSize / 2;
        if (Offset < 0) {
            Offset = 0;
        } else if (Offset > mapSize - viewSize) {
            Offset = mapSize - viewSize;
        }
        return Offset;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.p = e.getPoint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void resetSelect() {
        this.selectedMob = null;
        this.p = null;
    }

    public Mob getSelf() {
        return this.self;
    }

    public void receiveMovePacket(MovePacket packet) {
        if (this.self == null) {
            return;
        }
        try {
            MovingVector mv = MovingVector.valueOf2(packet.getString("moving"));
        }
        catch (PacketFormatException e) {
            log.error("error in receiveMovePacket, ", e);
        }
    }

    private Vector3f getNowPosition(Spatial sp) {
        ArrayList list = sp.getControllers();
        for (Controller controller : list) {
            if (!(controller instanceof SpatialTransformer)) continue;
            SpatialTransformer st = (SpatialTransformer)controller;
            ArrayList listFrame = st.keyframes;
            SpatialTransformer.PointInTime start = (SpatialTransformer.PointInTime)listFrame.get(0);
            Vector3f startV = start.look[0].getTranslation();
            SpatialTransformer.PointInTime end = (SpatialTransformer.PointInTime)listFrame.get(1);
            Vector3f endV = end.look[0].getTranslation();
            Vector3f move = endV.subtract(startV);
            Vector3f move2 = move.mult(st.getCurTime() / st.getMaxTime());
            Vector3f now = startV.add(move2);
            return now;
        }
        return null;
    }

    private Vector3f getStartPosition(Spatial sp) {
        ArrayList list = sp.getControllers();
        for (Controller controller : list) {
            if (!(controller instanceof SpatialTransformer)) continue;
            SpatialTransformer st = (SpatialTransformer)controller;
            ArrayList listFrame = st.keyframes;
            SpatialTransformer.PointInTime start = (SpatialTransformer.PointInTime)listFrame.get(0);
            Vector3f startV = start.look[0].getTranslation();
            return startV;
        }
        return null;
    }

    private Vector3f getEndPosition(Spatial sp) {
        ArrayList list = sp.getControllers();
        for (Controller controller : list) {
            if (!(controller instanceof SpatialTransformer)) continue;
            SpatialTransformer st = (SpatialTransformer)controller;
            ArrayList listFrame = st.keyframes;
            SpatialTransformer.PointInTime end = (SpatialTransformer.PointInTime)listFrame.get(1);
            Vector3f endV = end.look[0].getTranslation();
            return endV;
        }
        return null;
    }

    private boolean isAnimateEnd(Spatial sp) {
        ArrayList list = sp.getControllers();
        for (Controller controller : list) {
            if (!(controller instanceof SpatialTransformer)) continue;
            SpatialTransformer st = (SpatialTransformer)controller;
            return !(st.getCurTime() < st.getMaxTime());
        }
        return true;
    }

    private Position createPosition(Vector3f vec) {
        int x = (int)(vec.x / this.fsize + (float)(this.map.getMapWidth() / 2));
        int z = (int)(vec.z / this.fsize + (float)(this.map.getMapHeight() / 2));
        return new Position(x, z, 0.0);
    }
}

