/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample.jme;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.sourceforge.mmosf.admin.LocalMonitor;
import jp.sourceforge.mmosf.client.sample.InputProcess;
import jp.sourceforge.mmosf.client.sample.JScrollMessageLabel;
import jp.sourceforge.mmosf.client.sample.PacketProcess;
import jp.sourceforge.mmosf.client.sample.jme.JMenuPanel;
import jp.sourceforge.mmosf.client.sample.jme.JQuestJournalPanel;
import jp.sourceforge.mmosf.client.sample.jme.LoggingResponseTime;
import jp.sourceforge.mmosf.client.sample.jme.QuarterViewPanel;
import jp.sourceforge.mmosf.server.MatchingServer;
import jp.sourceforge.mmosf.server.level.GeomapData;
import jp.sourceforge.mmosf.server.object.ChatMessage;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.object.action.ActionElement;
import jp.sourceforge.mmosf.server.object.item.Item;
import jp.sourceforge.mmosf.server.packet.MenuPacket;
import jp.sourceforge.mmosf.server.packet.MovePacket;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import jp.sourceforge.mmosf.server.packet.StatusPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleClientFrame
extends JFrame
implements ActionListener,
WindowListener,
LoggingResponseTime {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(SampleClientFrame.class);
    protected JScrollMessageLabel message;
    protected JTextField chatInput;
    protected JMenuPanel menuPanel;
    protected JMenuPanel inventoryPanel;
    protected JTabbedPane tabPane;
    protected PacketProcess process;
    protected InputProcess input;
    protected Position pos;
    protected GeomapData zone = new GeomapData();
    protected QuarterViewPanel viewPanel;
    protected Mob selectedMob = null;
    protected int selectedSlot = -1;
    protected Item[] listItem;
    protected boolean isOpenMenu = false;
    protected long time;
    protected long timeMove;
    protected StringBuffer timelogBuffer;
    protected final int SIZE_TIMELOG_BFFER = 256;
    protected JQuestJournalPanel questPanel;

    public static void main(String[] args) {
        SampleClientFrame frame = new SampleClientFrame();
        frame.setBounds(0, 0, 300, 200);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    SampleClientFrame() throws HeadlessException {
        this.process = new PacketProcess(){

            @Override
            public void receiveMessage(ChatMessage chat) {
                SampleClientFrame.this.message.addMessage(chat);
            }

            @Override
            public void receiveUpdate(Mob self, List<Mob> listUpdate, List<Mob> listDelete) {
                SampleClientFrame.this.viewPanel.update(self, listUpdate, listDelete);
            }

            @Override
            public void receivePacket(Packet packet) {
                SampleClientFrame.this.receivePacket2(packet);
            }

            @Override
            protected void onLogout() {
                SampleClientFrame.this.input.send(Vector.ZERO);
            }
        };
        this.process.setFrame(this);
        this.input = new InputProcess(){

            public void send(Packet packet) {
                SampleClientFrame.this.startLogTimeMove();
                SampleClientFrame.this.process.send(packet);
            }

            public boolean isLogout() {
                return SampleClientFrame.this.process.isLogout();
            }
        };
        new Thread((Runnable)this.input, "InputProcess").start();
        this.listItem = new Item[20];
        this.setBounds(0, 0, 640, 480);
        JPanel panel = new JPanel();
        BorderLayout layout = new BorderLayout();
        panel.setLayout(layout);
        this.viewPanel = new QuarterViewPanel();
        panel.add((Component)this.viewPanel, "Center");
        JPanel panel2 = new JPanel();
        BorderLayout layout2 = new BorderLayout();
        panel2.setLayout(layout2);
        this.chatInput = new JTextField();
        panel2.add((Component)this.chatInput, "North");
        this.message = new JScrollMessageLabel();
        this.message.setText("<html></html>");
        this.message.setVerticalAlignment(3);
        panel2.add((Component)this.message.getScrollPane(), "Center");
        panel.add((Component)panel2, "South");
        this.menuPanel = new JMenuPanel(){

            protected void onButton(ActionElement act) {
                Packet packet = SampleClientFrame.this.selectedMob != null ? PacketFactory.createActionPacket(SampleClientFrame.this.selectedMob, act) : PacketFactory.createActionPacket(SampleClientFrame.this.selectedSlot, act);
                if (this.isReplyMessage()) {
                    SampleClientFrame.this.message.addMessage(ChatMessage.createTell(String.valueOf(SampleClientFrame.this.viewPanel.self.c), act.name));
                }
                SampleClientFrame.this.process.send(packet);
                SampleClientFrame.this.clearMenu();
            }
        };
        this.menuPanel.setText("Command");
        this.menuPanel.setPreferredSize(new Dimension(200, 200));
        this.inventoryPanel = new JMenuPanel(){

            protected void onButton(ActionElement act) {
                SampleClientFrame.this.selectItem(act.id);
            }
        };
        this.inventoryPanel.setText("Inventory");
        this.inventoryPanel.setPreferredSize(new Dimension(200, 200));
        this.questPanel = new JQuestJournalPanel();
        this.tabPane = new JTabbedPane();
        this.tabPane.add("command", this.menuPanel);
        this.tabPane.add("inventory", this.inventoryPanel);
        this.tabPane.add("quest", this.questPanel);
        this.tabPane.setFocusable(false);
        panel.add((Component)this.tabPane, "East");
        panel.addKeyListener(this.input);
        this.getContentPane().add(panel);
        this.chatInput.addActionListener(this);
        this.chatInput.addKeyListener(this.input);
        KeyListener[] kl = this.tabPane.getKeyListeners();
        int i = 0;
        while (i < kl.length) {
            this.tabPane.removeKeyListener(kl[i]);
            ++i;
        }
        this.tabPane.addKeyListener(this.input);
        this.viewPanel.addKeyListener(this.input);
        this.pack();
        this.viewPanel.setMap(this.zone);
        this.viewPanel.setFrame(this);
        this.viewPanel.start();
        this.setDefaultCloseOperation(1);
        this.addWindowListener(this);
        this.timelogBuffer = new StringBuffer();
    }

    public boolean connect(SocketAddress addr, String connectId) {
        try {
            return this.process.connect(addr, connectId);
        }
        catch (Exception e) {
            log.error("error in connect,", e);
            return false;
        }
    }

    public void start() {
        block2: while (true) {
            try {
                while (true) {
                    this.process.process();
                    if (this.process.isLogout()) {
                        this.dispose();
                        break block2;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                log.error("receive error.", e);
                continue;
            }
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.process.sendMessage(this.chatInput.getText());
        this.chatInput.setText("");
    }

    public void openMenu(boolean isOpen) {
        this.isOpenMenu = isOpen;
    }

    public void selectMob(Mob mob) {
        this.selectedMob = mob;
        this.selectedSlot = -1;
        Packet packet = PacketFactory.createMenuRequestPaket(mob);
        this.process.send(packet);
    }

    public void selectItem(int slot) {
        this.selectedMob = null;
        this.selectedSlot = slot;
        this.viewPanel.resetSelect();
        Packet packet = PacketFactory.createMenuRequestPaket(slot);
        this.process.send(packet);
    }

    public void receivePacket2(Packet packet) {
        try {
            switch (packet.getType()) {
                case 7: {
                    LocalMonitor.getMonitor().log("receive move response,", packet);
                    this.viewPanel.receiveMovePacket((MovePacket)packet);
                    break;
                }
                case 8: {
                    double distance = 0.0;
                    if (this.selectedMob != null) {
                        distance = MatchingServer.getDistance(this.getSelf().moving.getPosition(), this.selectedMob.moving.getPosition());
                    }
                    String target = packet.getString("target");
                    String text = packet.getString("text");
                    List<ActionElement> listAction = PacketFactory.parseMenuResponsePacket((MenuPacket)packet);
                    if (text == null) {
                        this.setMenu(target, listAction, distance, false);
                    } else {
                        this.setMenu(text, listAction, distance, true);
                        this.message.addMessage(ChatMessage.createTell(target, text));
                    }
                    this.tabPane.setSelectedComponent(this.menuPanel);
                    break;
                }
                case 9: {
                    switch (packet.getInt("type")) {
                        case 0: {
                            Map.Entry<Integer, Item> ret = PacketFactory.parseGetItemStatusPacket((StatusPacket)packet);
                            this.message.addMessage(ChatMessage.createSysMsg(String.valueOf(ret.getValue().name) + "\u3092\u624b\u306b\u5165\u308c\u305f\u3002"));
                            this.listItem[ret.getKey().intValue()] = ret.getValue();
                            LinkedList<ActionElement> listAct = new LinkedList<ActionElement>();
                            int i = 0;
                            while (i < this.listItem.length) {
                                Item item = this.listItem[i];
                                if (item != null) {
                                    ActionElement elm = new ActionElement(i, item.name, 0.0f);
                                    listAct.add(elm);
                                }
                                ++i;
                            }
                            this.setInventory(listAct);
                        }
                    }
                    break;
                }
                case 11: {
                    switch (packet.getInt("progress")) {
                        case 0: {
                            this.message.addMessage(ChatMessage.createSysMsg("\"" + packet.getString("name") + "\"\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002"));
                            this.questPanel.addNewQuest(packet);
                            break;
                        }
                        case 1: {
                            this.message.addMessage(ChatMessage.createSysMsg("\"" + packet.getString("name") + "\"\u3092\u66f4\u65b0\u3057\u307e\u3057\u305f\u3002"));
                            this.questPanel.updateQuest(packet);
                            break;
                        }
                        case 2: {
                            this.message.addMessage(ChatMessage.createSysMsg("\"" + packet.getString("name") + "\"\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002"));
                            this.questPanel.completeQuest(packet);
                        }
                    }
                    this.questPanel.resize();
                    this.questPanel.revalidate();
                    this.questPanel.repaint();
                }
            }
        }
        catch (Exception e) {
            log.error("error in receivePacket2,", e);
        }
    }

    public void setMenu(String text, List<ActionElement> listAction, double distance, boolean isReplyMessage) {
        this.menuPanel.setText(text);
        this.menuPanel.setDistance(distance);
        this.menuPanel.setReplyMessage(isReplyMessage);
        this.menuPanel.setButton(listAction);
        this.menuPanel.resize();
        this.menuPanel.revalidate();
        this.menuPanel.repaint();
    }

    public void clearMenu() {
        this.setMenu("", new LinkedList<ActionElement>(), 0.0, false);
    }

    public void setInventory(List<ActionElement> listAction) {
        this.inventoryPanel.setButton(listAction);
        this.inventoryPanel.resize();
        this.inventoryPanel.revalidate();
        this.inventoryPanel.repaint();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.sendLog();
        Packet packet = PacketFactory.createLogoutPacket(true);
        this.process.send(packet);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public Mob getSelf() {
        return this.viewPanel.getSelf();
    }

    @Override
    public void startLogTimeMove() {
        if (!this.isTime()) {
            return;
        }
        this.timeMove = System.nanoTime();
    }

    @Override
    public void startLogTime() {
        if (!this.isTime()) {
            return;
        }
        this.time = System.nanoTime();
    }

    @Override
    public void logTimeMove() {
        if (!this.isTime()) {
            return;
        }
        if (this.timeMove == 0L) {
            return;
        }
        long timePast = System.nanoTime() - this.timeMove;
        this.logTime("move:" + (double)timePast / 1.0E9);
        this.timeMove = 0L;
    }

    @Override
    public void logTime(Packet packet) throws PacketFormatException {
        if (!this.isTime()) {
            return;
        }
        long timePast = System.nanoTime() - this.time;
        this.logTime("past(" + packet.getType() + "):" + (double)timePast / 1.0E9);
    }

    protected boolean isTime() {
        return true;
    }

    protected void logTime(String string) {
        this.timelogBuffer.append(String.valueOf(string) + ";");
        if (this.timelogBuffer.length() < 256) {
            return;
        }
        this.sendLog();
    }

    @Override
    public void sendLog() {
        if (!this.isTime()) {
            return;
        }
        Packet pac = PacketFactory.createLogPacket(this.timelogBuffer.toString());
        this.process.send(pac);
        this.timelogBuffer.setLength(0);
    }
}

