/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import java.util.Random;
import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.Moving;
import jp.sourceforge.mmosf.server.object.MovingVector;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;

public class MovingRnd
extends MovingVector {
    private int wait = -1;
    protected Position nextPos = null;
    private static Random rd = null;

    public MovingRnd(Position pos) {
        super(pos);
        this.moveType = 2;
        this.speed = 1.0;
    }

    Vector getVector(int direction2) {
        int direction = direction2;
        switch (direction) {
            case 0: {
                return Vector.NORTH;
            }
            case 1: {
                return Vector.EAST;
            }
            case 2: {
                return Vector.SOUTH;
            }
            case 3: {
                return Vector.WEST;
            }
        }
        return Vector.ZERO;
    }

    private boolean isMovePosition(Position nowPos) {
        return !nowPos.equals(this.nextPos);
    }

    protected Vector getVector(Position nowPos) {
        if (this.isMovePosition(nowPos)) {
            return nowPos.getVector(this.nextPos, this.getSpeed());
        }
        return Vector.ZERO;
    }

    Vector getRndMoveVector(Perception prc) {
        int direction = this.getRd().nextInt(4);
        int length = 4;
        int secondDirection = -1;
        int secondLength = -1;
        int j = 0;
        while (j < 4) {
            Vector vec = this.getVector(direction);
            int count = this.isEnableDirection(vec, 4, prc);
            if (count == 4) {
                secondLength = count;
                secondDirection = direction;
                break;
            }
            if (count > secondLength) {
                secondLength = count;
                secondDirection = direction;
            }
            direction = (direction + 1) % 4;
            ++j;
        }
        if (secondLength <= 0) {
            Mob.log.error("mob can't move, mob in box.");
            return Vector.ZERO;
        }
        Vector vec = new Vector(this.getVector(secondDirection), secondLength);
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Perception prc) {
        MovingRnd movingRnd = this;
        synchronized (movingRnd) {
            if (this.nextPos != null && !this.nextPos.equals(this.getPosition())) {
                Position old = this.getPosition();
                super.move(prc);
                if (old.equals(this.getPosition())) {
                    this.nextPos = this.getPosition();
                    this.wait = 4 + this.getRd().nextInt(4);
                }
                return;
            }
            if (this.wait != -1) {
                --this.wait;
                return;
            }
            Vector vec = this.getRndMoveVector(prc);
            this.nextPos = this.getPosition().getMoved(vec);
            this.setDirection(vec.getDirection());
            this.wait = 4 + this.getRd().nextInt(4);
            return;
        }
    }

    protected void moveRnd(Perception prc) {
        Vector vec = this.getRndMoveVector(prc);
        this.nextPos = this.getPosition().getMoved(vec);
    }

    int isEnableDirection(Vector vec, int length, Perception prc) {
        MoveObject mo = new MoveObject(this.getPosition(), vec);
        int i = 0;
        i = 1;
        while (i <= length) {
            if (!prc.isEnableMove(mo)) {
                return i - 1;
            }
            mo.moveNewPositon();
            ++i;
        }
        return length;
    }

    public Random getRd() {
        if (rd == null) {
            rd = new Random(System.currentTimeMillis());
        }
        return rd;
    }

    public Vector getVector() {
        if (this.nextPos == null) {
            return Vector.ZERO;
        }
        return this.getPosition().getVector(this.nextPos, this.getSpeed());
    }

    public Moving duplicate() {
        MovingRnd mr = new MovingRnd(this.getPosition());
        mr.setColType(this.getColType());
        mr.setDirection(this.getDirection());
        mr.setVector(this.getVector());
        mr.nextPos = this.nextPos;
        return mr;
    }
}

