/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.Moving;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MovingVector
extends Moving {
    private Log log = LogFactory.getLog(MovingVector.class);
    private Vector vec;

    public MovingVector(Position pos) {
        super(pos);
        this.speed = 4.0;
        this.moveType = 1;
        this.vec = new Vector();
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public boolean isMoveType(int moveType) {
        return this.moveType == moveType;
    }

    protected Vector getVector(Position nowPos) {
        if (!this.isMoveVector()) {
            return Vector.ZERO;
        }
        long span = this.nowTime - this.lastTime;
        double scale = (double)span * this.getSpeed() / 1000.0;
        Vector ret = new Vector(this.vec, scale);
        this.log.trace("vector = " + ret.toString());
        return ret;
    }

    private boolean isMoveVector() {
        return !this.vec.isZero();
    }

    public MoveObject createMoveObject() {
        return new MoveObject(this.getPosition(), this.getVector(this.getPosition()));
    }

    public void move(Perception prc) {
        MoveObject mo1 = this.createMoveObject();
        Vector vec = mo1.getVec().getBaseVector();
        vec.isZero();
        do {
            MoveObject mo2;
            if (!this.isEnableMove(mo2 = new MoveObject(this.getPosition(), vec), prc)) {
                this.vec = Vector.ZERO;
                this.normalize();
                this.onStop();
                return;
            }
            if (this.isOver(this.getPosition(), mo1.getNextPos(), vec)) {
                return;
            }
            Position old = this.getPosition();
            this.move(mo2);
            if (this.getPosition().equals(old)) continue;
            this.onMoved();
        } while (!this.getPosition().equals(mo1.getNextPos()));
    }

    protected void onStop() {
    }

    protected void onMoved() {
    }

    private boolean isOver(Position startPos, Position endPos, Vector step) {
        Vector p1 = startPos.getVector(endPos);
        if (step.getdX() > 0.0 ? p1.getdX() < step.getdX() : p1.getdX() > step.getdX()) {
            return true;
        }
        if (step.getdY() > 0.0 ? p1.getdY() < step.getdY() : p1.getdY() > step.getdY()) {
            return true;
        }
        return step.getdZ() > 0.0 ? p1.getdZ() < step.getdZ() : p1.getdZ() > step.getdZ();
    }

    protected Vector getVectorPerFrame(Vector vec) {
        return vec.getBaseVector();
    }

    public void setVector(Vector vec) {
        this.vec = vec;
        this.normalize();
    }

    public Vector getVector() {
        return this.vec;
    }

    private void move(MoveObject mo) {
        this.setPosition(mo.getNextPos());
        if (!mo.getVec().isZero()) {
            this.setDirection(mo.getVec().getDirection());
        }
    }

    public Moving duplicate() {
        MovingVector mv = new MovingVector(this.getPosition());
        mv.setColType(this.getColType());
        mv.setDirection(this.getDirection());
        mv.setVector(this.getVector());
        mv.nowTime = this.nowTime;
        mv.lastTime = this.lastTime;
        return mv;
    }

    protected void normalize() {
        Position pos = this.getPosition();
        this.setPosition(new Position((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5));
    }

    public static MovingVector valueOf(String string) {
        MovingVector mv = new MovingVector(new Position());
        if (string == null || string.length() == 0) {
            return mv;
        }
        String[] split = string.split(";");
        if (split == null || split.length == 0) {
            return mv;
        }
        int i = 0;
        while (i < split.length) {
            int index2;
            int index1;
            if (split[i] != null && split[i].length() != 0 && (index1 = split[i].indexOf("{")) != -1 && (index2 = split[i].indexOf("}", index1)) != -1) {
                String name = split[i].substring(0, index1).trim();
                String value = split[i].substring(index1 + 1, index2).trim();
                if (name.equalsIgnoreCase("position")) {
                    mv.setPosition(Position.valueOf(value));
                } else if (name.equalsIgnoreCase("vector")) {
                    mv.setVector(Vector.valueOf(value));
                } else if (name.equalsIgnoreCase("direction")) {
                    mv.setDirection(Vector.valueOf(value));
                } else if (name.equalsIgnoreCase("speed")) {
                    mv.setSpeed(Double.valueOf(value));
                }
            }
            ++i;
        }
        return mv;
    }

    public static MovingVector valueOf2(String string) {
        MovingVector mv = new MovingVector(new Position());
        if (string == null || string.length() == 0) {
            return mv;
        }
        String[] split = string.split(";");
        if (split == null || split.length == 0) {
            return mv;
        }
        int i = 0;
        while (split != null && i < split.length) {
            switch (i) {
                case 0: {
                    mv.setPosition(Position.valueOf2(split[i]));
                    break;
                }
                case 1: {
                    mv.setVector(Vector.valueOf2(split[i]));
                    break;
                }
                case 2: {
                    mv.setDirection(Vector.valueOf2(split[i]));
                    break;
                }
                case 3: {
                    mv.setSpeed(Double.valueOf(split[i]));
                }
            }
            ++i;
        }
        return mv;
    }
}

