/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.input.ActionTrigger;
import com.jme.input.InputHandlerDevice;
import com.jme.input.KeyBindingManager;
import com.jme.input.Mouse;
import com.jme.input.action.InputAction;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.input.action.MouseInputAction;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInput;
import com.jme.input.joystick.JoystickInputHandlerDevice;
import com.jme.input.keyboard.KeyboardInputHandlerDevice;
import com.jme.input.mouse.MouseInputHandlerDevice;
import com.jme.input.util.SyntheticAxis;
import com.jme.input.util.SyntheticButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputHandler {
    private static final Logger logger = Logger.getLogger(InputHandler.class.getName());
    ActionTrigger activeTriggers;
    ArrayList<ActionTrigger> allTriggers;
    public static final String DEVICE_MOUSE = "mouse";
    public static final String DEVICE_KEYBOARD = "keyboard";
    public static final String DEVICE_ALL = "ALL DEVICES";
    public static final int BUTTON_NONE = -1;
    public static final int BUTTON_ALL = Integer.MIN_VALUE;
    public static final int AXIS_NONE = -1;
    public static final int AXIS_ALL = Integer.MIN_VALUE;
    protected Mouse mouse;
    protected InputActionEvent event = new InputActionEvent();
    private static Map<String, InputHandlerDevice> devices;
    private static Collection<InputHandlerDevice> devicesReadOnly;
    private boolean enabled = true;
    private ArrayList<InputHandler> attachedHandlers;
    private InputHandler parent;

    public InputHandler() {
        InputHandler.initializeDefaultDevices();
    }

    public void setActionSpeed(float f) {
        this.setActionSpeed(f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActionSpeed(float f, String string) {
        InputHandler inputHandler = this;
        synchronized (inputHandler) {
            if (this.allTriggers != null) {
                for (int i = this.allTriggers.size() - 1; i >= 0; --i) {
                    ActionTrigger actionTrigger = this.allTriggers.get(i);
                    if (string != null && !string.equals(actionTrigger.name) || !(actionTrigger.action instanceof InputAction)) continue;
                    InputAction inputAction = (InputAction)actionTrigger.action;
                    inputAction.setSpeed(f);
                }
            }
        }
    }

    public void addAction(InputActionInterface inputActionInterface, String string, boolean bl) {
        new ActionTrigger.CommandTrigger(this, string, inputActionInterface, bl);
    }

    public void addAction(InputActionInterface inputActionInterface, String string, int n, boolean bl) {
        if (string == null) {
            throw new NullPointerException("triggerCommand may not be null");
        }
        KeyBindingManager.getKeyBindingManager().add(string, n);
        this.addAction(inputActionInterface, string, bl);
    }

    public void addAction(InputAction inputAction, SyntheticButton syntheticButton, boolean bl) {
        this.addAction(inputAction, syntheticButton.getDeviceName(), syntheticButton.getIndex(), -1, bl);
    }

    public void addAction(InputAction inputAction, SyntheticAxis syntheticAxis, boolean bl) {
        this.addAction(inputAction, syntheticAxis.getDeviceName(), -1, syntheticAxis.getIndex(), bl);
    }

    public void addAction(MouseInputAction mouseInputAction) {
        this.addAction(mouseInputAction, DEVICE_MOUSE, -1, 0, true);
    }

    private static void initializeDefaultDevices() {
        if (devices == null) {
            devices = new HashMap<String, InputHandlerDevice>();
            InputHandler.addDevice(new MouseInputHandlerDevice());
            InputHandler.addDevice(new KeyboardInputHandlerDevice());
            for (int i = JoystickInput.get().getJoystickCount() - 1; i >= 0; --i) {
                String string;
                Joystick joystick = JoystickInput.get().getJoystick(i);
                String string2 = string = joystick.getName();
                int n = 2;
                while (devices.get(string2) != null) {
                    string2 = string + " (" + n + ")";
                    ++n;
                }
                InputHandler.addDevice(new JoystickInputHandlerDevice(joystick, string2));
            }
        }
    }

    public static Collection<InputHandlerDevice> getDevices() {
        if (devices == null) {
            throw new IllegalStateException("devices have not been initialized - create an InputHandler first");
        }
        if (devicesReadOnly == null) {
            devicesReadOnly = Collections.unmodifiableCollection(devices.values());
        }
        return devicesReadOnly;
    }

    public static void addDevice(InputHandlerDevice inputHandlerDevice) {
        InputHandlerDevice inputHandlerDevice2;
        if (inputHandlerDevice != null && (inputHandlerDevice2 = devices.put(inputHandlerDevice.getName(), inputHandlerDevice)) != null && inputHandlerDevice2 != inputHandlerDevice) {
            logger.warning("InputHandlerDevice name '" + inputHandlerDevice.getName() + "' used twice!");
        }
    }

    public void addAction(InputActionInterface inputActionInterface, String string, int n, int n2, boolean bl) {
        if (DEVICE_ALL.equals(string)) {
            for (InputHandlerDevice inputHandlerDevice : devices.values()) {
                inputHandlerDevice.createTriggers(inputActionInterface, n2, n, bl, this);
            }
        } else {
            InputHandlerDevice inputHandlerDevice = devices.get(string);
            if (inputHandlerDevice != null) {
                inputHandlerDevice.createTriggers(inputActionInterface, n2, n, bl, this);
            } else {
                throw new UnsupportedOperationException("Device '" + string + "' is unknown!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAction(InputActionInterface inputActionInterface) {
        InputHandler inputHandler = this;
        synchronized (inputHandler) {
            for (int i = this.allTriggers.size() - 1; i >= 0; --i) {
                ActionTrigger actionTrigger = this.allTriggers.get(i);
                if (actionTrigger.action != inputActionInterface) continue;
                actionTrigger.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAction(String string) {
        InputHandler inputHandler = this;
        synchronized (inputHandler) {
            KeyBindingManager.getKeyBindingManager().remove(string);
            for (int i = this.allTriggers.size() - 1; i >= 0; --i) {
                ActionTrigger actionTrigger = this.allTriggers.get(i);
                if (!actionTrigger.name.equals(string)) continue;
                actionTrigger.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllActions() {
        InputHandler inputHandler = this;
        synchronized (inputHandler) {
            for (int i = this.allTriggers.size() - 1; i >= 0; --i) {
                ActionTrigger actionTrigger = this.allTriggers.get(i);
                actionTrigger.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActions() {
        InputHandler inputHandler = this;
        synchronized (inputHandler) {
            for (int i = this.allTriggers.size() - 1; i >= 0; --i) {
                ActionTrigger actionTrigger = this.allTriggers.get(i);
                actionTrigger.remove();
            }
        }
    }

    public void update(float f) {
        if (!this.isEnabled()) {
            return;
        }
        this.processTriggers(f);
        this.updateAttachedHandlers(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTriggers(float f) {
        this.event.setTime(f);
        InputHandler inputHandler = this;
        synchronized (inputHandler) {
            ActionTrigger actionTrigger = this.activeTriggers;
            while (actionTrigger != null) {
                ActionTrigger actionTrigger2 = actionTrigger.getNext();
                actionTrigger.performAction(this.event);
                actionTrigger = actionTrigger2;
            }
        }
    }

    protected void updateAttachedHandlers(float f) {
        for (int i = this.sizeOfAttachedHandlers() - 1; i >= 0; --i) {
            InputHandler inputHandler = this.getFromAttachedHandlers(i);
            if (!inputHandler.isEnabled()) continue;
            inputHandler.update(f);
        }
    }

    public static float getFloatProp(HashMap hashMap, String string, float f) {
        if (hashMap == null || hashMap.get(string) == null) {
            return f;
        }
        return Float.parseFloat(hashMap.get(string).toString());
    }

    public static int getIntProp(HashMap hashMap, String string, int n) {
        if (hashMap == null || hashMap.get(string) == null) {
            return n;
        }
        return Integer.parseInt(hashMap.get(string).toString());
    }

    public static boolean getBooleanProp(HashMap hashMap, String string, boolean bl) {
        if (hashMap == null || hashMap.get(string) == null) {
            return bl;
        }
        return "true".equalsIgnoreCase(hashMap.get(string).toString());
    }

    public static Object getObjectProp(HashMap hashMap, String string, Object object) {
        if (hashMap == null || hashMap.get(string) == null) {
            return object;
        }
        return hashMap.get(string);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        if (bl2 != bl) {
            this.enabled = bl;
        }
    }

    public void setEnabledOfAttachedHandlers(boolean bl) {
        for (int i = this.sizeOfAttachedHandlers() - 1; i >= 0; --i) {
            InputHandler inputHandler = this.getFromAttachedHandlers(i);
            inputHandler.setEnabled(bl);
        }
    }

    public boolean addToAttachedHandlers(InputHandler inputHandler) {
        return inputHandler != null && inputHandler.setParent(this);
    }

    private boolean addToAttachedHandlers_internal(InputHandler inputHandler) {
        boolean bl = false;
        if (inputHandler != null) {
            if (this.attachedHandlers == null) {
                this.attachedHandlers = new ArrayList();
            } else if (this.attachedHandlers.contains(inputHandler)) {
                return false;
            }
            bl = this.attachedHandlers.add(inputHandler);
            if (bl) {
                inputHandler.setParent(this);
            }
        }
        return bl;
    }

    public InputHandler getFromAttachedHandlers(int n) {
        if (this.attachedHandlers != null && n >= 0 && n < this.attachedHandlers.size()) {
            return this.attachedHandlers.get(n);
        }
        return null;
    }

    public void removeAllFromAttachedHandlers() {
        for (int i = this.sizeOfAttachedHandlers() - 1; i >= 0; --i) {
            InputHandler inputHandler = this.getFromAttachedHandlers(i);
            this.removeFromAttachedHandlers(inputHandler);
        }
    }

    public boolean removeFromAttachedHandlers(InputHandler inputHandler) {
        boolean bl = false;
        if (this.attachedHandlers != null && inputHandler != null && (bl = this.attachedHandlers.remove(inputHandler))) {
            inputHandler.setParent(null);
        }
        return bl;
    }

    public int sizeOfAttachedHandlers() {
        return this.attachedHandlers == null ? 0 : this.attachedHandlers.size();
    }

    public InputHandler getParent() {
        return this.parent;
    }

    protected boolean setParent(InputHandler inputHandler) {
        boolean bl = false;
        InputHandler inputHandler2 = this.parent;
        if (inputHandler2 != inputHandler) {
            if (inputHandler2 != null) {
                this.parent = null;
                inputHandler2.removeFromAttachedHandlers(this);
            }
            this.parent = inputHandler;
            if (inputHandler != null) {
                inputHandler.addToAttachedHandlers_internal(this);
            }
            bl = true;
        }
        return bl;
    }
}

