/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.controls.controller.camera;

import com.jme.input.controls.controller.camera.CameraPerspective;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.Spatial;

public class FixedCameraPerspective
implements CameraPerspective {
    private Quaternion q = new Quaternion();
    private Vector3f v = new Vector3f();
    private Vector3f v2 = new Vector3f();
    private Vector3f location;
    private boolean hideSpatialOnActivate;
    private int previousCullMode;

    public FixedCameraPerspective(Vector3f vector3f) {
        this(vector3f, false);
    }

    public FixedCameraPerspective(Vector3f vector3f, boolean bl) {
        this.location = vector3f;
        this.hideSpatialOnActivate = bl;
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public void update(Camera camera, Spatial spatial, float f) {
        this.q.set(spatial.getWorldRotation());
        camera.setDirection(this.q.getRotationColumn(2));
        camera.setLeft(this.q.getRotationColumn(0));
        camera.setUp(this.q.getRotationColumn(1));
        spatial.updateWorldVectors();
        this.v.set(spatial.getWorldTranslation());
        this.q.set(spatial.getWorldRotation());
        this.v2.set(this.location);
        this.q.multLocal(this.v2);
        this.v.addLocal(this.v2);
        camera.setLocation(this.v);
        camera.lookAt(spatial.getLocalTranslation(), camera.getUp());
        camera.update();
    }

    public void setActive(Camera camera, Spatial spatial, boolean bl) {
        if (bl && this.hideSpatialOnActivate) {
            this.previousCullMode = spatial.getCullMode();
            spatial.setCullMode(2);
        } else if (!bl && this.hideSpatialOnActivate) {
            spatial.setCullMode(this.previousCullMode);
        }
    }
}

