/*
 * Decompiled with CFR 0.152.
 */
package com.jme.intersection;

import com.jme.math.Vector3f;
import com.jme.system.JmeException;

public class IntersectionRecord {
    private float[] distances;
    private Vector3f[] points;

    public IntersectionRecord() {
    }

    public IntersectionRecord(float[] fArray, Vector3f[] vector3fArray) {
        if (fArray.length != vector3fArray.length) {
            throw new JmeException("The distances and points variables must have an equal number of elements.");
        }
        this.distances = fArray;
        this.points = vector3fArray;
    }

    public int getQuantity() {
        if (this.points == null) {
            return 0;
        }
        return this.points.length;
    }

    public Vector3f getIntersectionPoint(int n) {
        return this.points[n];
    }

    public float getIntersectionDistance(int n) {
        return this.distances[n];
    }

    public float getClosestDistance() {
        float f = Float.MAX_VALUE;
        if (this.distances != null) {
            for (float f2 : this.distances) {
                if (!(f2 < f)) continue;
                f = f2;
            }
        }
        return f;
    }

    public int getClosestPoint() {
        float f = Float.MAX_VALUE;
        int n = 0;
        if (this.distances != null) {
            int n2 = this.distances.length;
            while (--n2 >= 0) {
                float f2 = this.distances[n2];
                if (!(f2 < f)) continue;
                f = f2;
                n = n2;
            }
        }
        return n;
    }

    public int getFarthestPoint() {
        float f = Float.MIN_VALUE;
        int n = 0;
        if (this.distances != null) {
            int n2 = this.distances.length;
            while (--n2 >= 0) {
                float f2 = this.distances[n2];
                if (!(f2 > f)) continue;
                f = f2;
                n = n2;
            }
        }
        return n;
    }
}

