/*
 * Decompiled with CFR 0.152.
 */
package com.jme.light;

import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.Quaternion;
import com.jme.scene.Node;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class SimpleLightNode
extends Node {
    private static final long serialVersionUID = 1L;
    private Light light;
    private Quaternion lightRotate;

    public SimpleLightNode() {
    }

    public SimpleLightNode(String string, Light light) {
        super(string);
        this.light = light;
    }

    public Light getLight() {
        return this.light;
    }

    public void updateWorldData(float f) {
        super.updateWorldData(f);
        if (this.light == null) {
            return;
        }
        this.lightRotate = this.worldRotation.mult(this.localRotation, this.lightRotate);
        switch (this.light.getType()) {
            case 0: {
                DirectionalLight directionalLight = (DirectionalLight)this.light;
                directionalLight.setDirection(this.lightRotate.getRotationColumn(2, directionalLight.getDirection()));
                break;
            }
            case 1: {
                PointLight pointLight = (PointLight)this.light;
                pointLight.setLocation(this.worldTranslation);
                break;
            }
            case 2: {
                SpotLight spotLight = (SpotLight)this.light;
                spotLight.setLocation(this.worldTranslation);
                spotLight.setDirection(this.lightRotate.getRotationColumn(2, spotLight.getDirection()));
                break;
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.light, "Light", null);
        outputCapsule.write(this.lightRotate, "lightRotate", new Quaternion());
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.light = (Light)inputCapsule.readSavable("light", null);
        this.lightRotate = (Quaternion)inputCapsule.readSavable("lightRotate", new Quaternion());
    }
}

