/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.Plane;
import com.jme.math.Triangle;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;

public class Ray
implements Serializable,
Savable {
    private static final Logger logger = Logger.getLogger(Ray.class.getName());
    private static final long serialVersionUID = 1L;
    public Vector3f origin;
    public Vector3f direction;
    protected static final Vector3f tempVa = new Vector3f();
    protected static final Vector3f tempVb = new Vector3f();
    protected static final Vector3f tempVc = new Vector3f();
    protected static final Vector3f tempVd = new Vector3f();

    public Ray() {
        this.origin = new Vector3f();
        this.direction = new Vector3f();
    }

    public Ray(Vector3f vector3f, Vector3f vector3f2) {
        this.origin = vector3f;
        this.direction = vector3f2;
    }

    public boolean intersect(Triangle triangle) {
        return this.intersect(triangle.get(0), triangle.get(1), triangle.get(2));
    }

    public boolean intersect(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        return this.intersectWhere(vector3f, vector3f2, vector3f3, null);
    }

    public boolean intersectWhere(Triangle triangle, Vector3f vector3f) {
        return this.intersectWhere(triangle.get(0), triangle.get(1), triangle.get(2), vector3f);
    }

    public boolean intersectWhere(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        return this.intersects(vector3f, vector3f2, vector3f3, vector3f4, false, false);
    }

    public boolean intersectWherePlanar(Triangle triangle, Vector3f vector3f) {
        return this.intersectWherePlanar(triangle.get(0), triangle.get(1), triangle.get(2), vector3f);
    }

    public boolean intersectWherePlanar(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        return this.intersects(vector3f, vector3f2, vector3f3, vector3f4, true, false);
    }

    private boolean intersects(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, boolean bl, boolean bl2) {
        float f;
        float f2;
        float f3;
        Vector3f vector3f5;
        Vector3f vector3f6 = this.origin.subtract(vector3f, tempVa);
        Vector3f vector3f7 = vector3f2.subtract(vector3f, tempVb);
        Vector3f vector3f8 = vector3f7.cross(vector3f5 = vector3f3.subtract(vector3f, tempVc), tempVd);
        float f4 = this.direction.dot(vector3f8);
        if (f4 > 1.1920929E-7f) {
            f3 = 1.0f;
        } else if (f4 < -1.1920929E-7f) {
            f3 = -1.0f;
            f4 = -f4;
        } else {
            return false;
        }
        float f5 = f3 * this.direction.dot(vector3f6.cross(vector3f5, vector3f5));
        if (f5 > 0.0f && (f2 = f3 * this.direction.dot(vector3f7.crossLocal(vector3f6))) >= 0.0f && (!bl2 ? f5 + f2 <= f4 : f2 <= f4) && (f = -f3 * vector3f6.dot(vector3f8)) >= 0.0f) {
            if (vector3f4 == null) {
                return true;
            }
            float f6 = 1.0f / f4;
            float f7 = f * f6;
            if (!bl) {
                vector3f4.set(this.origin).addLocal(this.direction.x * f7, this.direction.y * f7, this.direction.z * f7);
            } else {
                float f8 = f5 * f6;
                float f9 = f2 * f6;
                vector3f4.set(f7, f8, f9);
            }
            return true;
        }
        return false;
    }

    public boolean intersectWherePlanarQuad(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        return this.intersects(vector3f, vector3f2, vector3f3, vector3f4, true, true);
    }

    public boolean intersectsWherePlane(Plane plane, Vector3f vector3f) {
        float f = plane.getNormal().dot(this.direction);
        if (f > -1.1920929E-7f && f < 1.1920929E-7f) {
            return false;
        }
        float f2 = -(plane.getNormal().dot(this.origin) + plane.getConstant());
        float f3 = f2 / f;
        if (f3 < 1.1920929E-7f) {
            return false;
        }
        vector3f.set(this.direction).multLocal(f3).addLocal(this.origin);
        return true;
    }

    public float distanceSquared(Vector3f vector3f) {
        vector3f.subtract(this.origin, tempVa);
        float f = this.direction.dot(tempVa);
        if (f > 0.0f) {
            this.origin.add(this.direction.mult(f, tempVb), tempVb);
        } else {
            tempVb.set(this.origin);
            f = 0.0f;
        }
        tempVb.subtract(vector3f, tempVa);
        return tempVa.lengthSquared();
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector3f vector3f) {
        this.origin = vector3f;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f vector3f) {
        this.direction = vector3f;
    }

    public void set(Ray ray) {
        this.origin.set(ray.getOrigin());
        this.direction.set(ray.getDirection());
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.origin, "origin", Vector3f.ZERO);
        outputCapsule.write(this.direction, "direction", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.origin = (Vector3f)inputCapsule.readSavable("origin", Vector3f.ZERO.clone());
        this.direction = (Vector3f)inputCapsule.readSavable("direction", Vector3f.ZERO.clone());
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

