/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;

public class TransformQuaternion
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    private Quaternion rot = new Quaternion();
    private Vector3f translation = new Vector3f();
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

    public void setRotationQuaternion(Quaternion quaternion) {
        this.rot.set(quaternion);
    }

    public void setTranslation(Vector3f vector3f) {
        this.translation.set(vector3f);
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public void setScale(Vector3f vector3f) {
        this.scale.set(vector3f);
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public Vector3f getTranslation(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        vector3f.set(this.translation);
        return vector3f;
    }

    public Quaternion getRotation(Quaternion quaternion) {
        if (quaternion == null) {
            quaternion = new Quaternion();
        }
        quaternion.set(this.rot);
        return quaternion;
    }

    public Quaternion getRotation() {
        return this.rot;
    }

    public Vector3f getScale(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        vector3f.set(this.scale);
        return vector3f;
    }

    public void interpolateTransforms(TransformQuaternion transformQuaternion, TransformQuaternion transformQuaternion2, float f) {
        this.rot.slerp(transformQuaternion.rot, transformQuaternion2.rot, f);
        this.translation.interpolate(transformQuaternion.translation, transformQuaternion2.translation, f);
        this.scale.interpolate(transformQuaternion.scale, transformQuaternion2.scale, f);
    }

    public TransformQuaternion combineWithParent(TransformQuaternion transformQuaternion) {
        this.scale.multLocal(transformQuaternion.scale);
        this.rot.multLocal(transformQuaternion.rot);
        transformQuaternion.rot.multLocal(this.translation).multLocal(transformQuaternion.scale).addLocal(transformQuaternion.translation);
        return this;
    }

    public void applyToSpatial(Spatial spatial) {
        spatial.getLocalScale().set(this.scale);
        spatial.getLocalRotation().set(this.rot);
        spatial.getLocalTranslation().set(this.translation);
    }

    public void setTranslation(float f, float f2, float f3) {
        this.translation.set(f, f2, f3);
    }

    public void setScale(float f, float f2, float f3) {
        this.scale.set(f, f2, f3);
    }

    public void loadIdentity() {
        this.translation.set(0.0f, 0.0f, 0.0f);
        this.scale.set(1.0f, 1.0f, 1.0f);
        this.rot.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void set(TransformQuaternion transformQuaternion) {
        this.translation.set(transformQuaternion.translation);
        this.rot.set(transformQuaternion.rot);
        this.scale.set(transformQuaternion.scale);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.rot, "rot", new Quaternion());
        outputCapsule.write(this.translation, "translation", Vector3f.ZERO);
        outputCapsule.write(this.scale, "scale", Vector3f.UNIT_XYZ);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.rot = (Quaternion)inputCapsule.readSavable("rot", new Quaternion());
        this.translation = (Vector3f)inputCapsule.readSavable("translation", Vector3f.ZERO.clone());
        this.scale = (Vector3f)inputCapsule.readSavable("scale", Vector3f.UNIT_XYZ.clone());
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

