/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.math.Vector3f;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;

public class BezierPatch
implements Savable {
    private Vector3f[][] anchors;
    private int detailLevel;

    public BezierPatch() {
        this.anchors = new Vector3f[4][4];
        this.detailLevel = 0;
    }

    public BezierPatch(Vector3f[][] vector3fArray) {
        if (vector3fArray.length != 4 || vector3fArray[0].length != 4) {
            throw new JmeException("Bezier patch anchors must be 4x4.");
        }
        this.anchors = vector3fArray;
        this.detailLevel = 0;
    }

    public BezierPatch(Vector3f[][] vector3fArray, int n) {
        if (vector3fArray.length != 4 || vector3fArray[0].length != 4) {
            throw new JmeException("Bezier patch anchors must be 4x4.");
        }
        this.anchors = vector3fArray;
        this.detailLevel = n;
    }

    public void setAnchors(Vector3f[][] vector3fArray) {
        if (vector3fArray.length != 4 || vector3fArray[0].length != 4) {
            throw new JmeException("Bezier patch anchors must be 4x4.");
        }
        this.anchors = vector3fArray;
    }

    public Vector3f[][] getAnchors() {
        return this.anchors;
    }

    public void setAnchor(int n, int n2, Vector3f vector3f) {
        if (n < 0 || n > 4 || n2 < 0 || n2 > 4) {
            throw new JmeException("Bezier Patch anchor out of bounds.");
        }
        this.anchors[n][n2] = vector3f;
    }

    public Vector3f getAnchor(int n, int n2) {
        if (n < 0 || n > 4 || n2 < 0 || n2 > 4) {
            throw new JmeException("Bezier Patch anchor out of bounds.");
        }
        return this.anchors[n][n2];
    }

    public void setDetailLevel(int n) {
        this.detailLevel = n;
    }

    public int getDetailLevel() {
        return this.detailLevel;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.anchors, "anchors", new Vector3f[4][4]);
        outputCapsule.write(this.detailLevel, "detailLevel", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        Savable[][] savableArray = inputCapsule.readSavableArray2D("anchors", new Vector3f[4][4]);
        if (savableArray != null) {
            for (int i = 0; i < savableArray.length; ++i) {
                for (int j = 0; j < savableArray[i].length; ++j) {
                    this.anchors[i][j] = (Vector3f)savableArray[i][j];
                }
            }
        }
        this.detailLevel = inputCapsule.readInt("detailLevel", 0);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

