/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.renderer.RenderContext;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.PassNodeState;
import com.jme.scene.Spatial;
import com.jme.system.DisplaySystem;
import java.util.ArrayList;

public class PassNode
extends Node {
    private static final long serialVersionUID = 1L;
    private ArrayList<PassNodeState> passNodeStates = new ArrayList();

    public PassNode(String string) {
        super(string);
    }

    public PassNode() {
    }

    public void draw(Renderer renderer) {
        if (this.children == null) {
            return;
        }
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        DisplaySystem.getDisplaySystem().getRenderer().getQueue().swapBuckets();
        for (PassNodeState passNodeState : this.passNodeStates) {
            if (!passNodeState.isEnabled()) continue;
            passNodeState.applyPassNodeState(renderer, renderContext);
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                Spatial spatial = (Spatial)this.children.get(i);
                if (spatial == null) continue;
                spatial.onDraw(renderer);
            }
            renderer.renderQueue();
            passNodeState.resetPassNodeStates(renderer, renderContext);
        }
        DisplaySystem.getDisplaySystem().getRenderer().getQueue().swapBuckets();
    }

    public void addPass(PassNodeState passNodeState) {
        this.passNodeStates.add(passNodeState);
    }

    public void insertPass(PassNodeState passNodeState, int n) {
        this.passNodeStates.add(n, passNodeState);
    }

    public boolean containsPass(PassNodeState passNodeState) {
        return this.passNodeStates.contains(passNodeState);
    }

    public boolean removePass(PassNodeState passNodeState) {
        return this.passNodeStates.remove(passNodeState);
    }

    public PassNodeState getPass(int n) {
        return this.passNodeStates.get(n);
    }

    public int nrPasses() {
        return this.passNodeStates.size();
    }

    public void clearAll() {
        this.passNodeStates.clear();
    }
}

