/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Dodecahedron
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private static final int NUM_POINTS = 20;
    private static final int NUM_TRIS = 36;
    private float sideLength;

    public Dodecahedron() {
    }

    public Dodecahedron(String string, float f) {
        super(string);
        this.sideLength = f;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount(20);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(20));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(20));
        triangleBatch.setTextureBuffer(BufferUtils.createVector2Buffer(20), 0);
        triangleBatch.setTriangleQuantity(36);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(3 * triangleBatch.getTriangleCount()));
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void setIndexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        IntBuffer intBuffer = triangleBatch.getIndexBuffer();
        intBuffer.rewind();
        intBuffer.put(0).put(8).put(9);
        intBuffer.put(0).put(9).put(4);
        intBuffer.put(0).put(4).put(16);
        intBuffer.put(0).put(12).put(13);
        intBuffer.put(0).put(13).put(1);
        intBuffer.put(0).put(1).put(8);
        intBuffer.put(0).put(16).put(17);
        intBuffer.put(0).put(17).put(2);
        intBuffer.put(0).put(2).put(12);
        intBuffer.put(8).put(1).put(18);
        intBuffer.put(8).put(18).put(5);
        intBuffer.put(8).put(5).put(9);
        intBuffer.put(12).put(2).put(10);
        intBuffer.put(12).put(10).put(3);
        intBuffer.put(12).put(3).put(13);
        intBuffer.put(16).put(4).put(14);
        intBuffer.put(16).put(14).put(6);
        intBuffer.put(16).put(6).put(17);
        intBuffer.put(9).put(5).put(15);
        intBuffer.put(9).put(15).put(14);
        intBuffer.put(9).put(14).put(4);
        intBuffer.put(6).put(11).put(10);
        intBuffer.put(6).put(10).put(2);
        intBuffer.put(6).put(2).put(17);
        intBuffer.put(3).put(19).put(18);
        intBuffer.put(3).put(18).put(1);
        intBuffer.put(3).put(1).put(13);
        intBuffer.put(7).put(15).put(5);
        intBuffer.put(7).put(5).put(18);
        intBuffer.put(7).put(18).put(19);
        intBuffer.put(7).put(11).put(6);
        intBuffer.put(7).put(6).put(14);
        intBuffer.put(7).put(14).put(15);
        intBuffer.put(7).put(19).put(3);
        intBuffer.put(7).put(3).put(10);
        intBuffer.put(7).put(10).put(11);
    }

    private void setTextureData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        Vector2f vector2f = new Vector2f();
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < 20; ++i) {
            BufferUtils.populateFromBuffer(vector3f, triangleBatch.getVertexBuffer(), i);
            vector2f.x = FastMath.abs(vector3f.z) < this.sideLength ? 0.5f * (1.0f + FastMath.atan2(vector3f.y, vector3f.x) * 0.31830987f) : 0.5f;
            vector2f.y = FastMath.acos(vector3f.z) * 0.31830987f;
            triangleBatch.getTextureBuffers().get(0).put(vector2f.x).put(vector2f.y);
        }
    }

    private void setNormalData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < 20; ++i) {
            BufferUtils.populateFromBuffer(vector3f, triangleBatch.getVertexBuffer(), i);
            vector3f.normalizeLocal();
            BufferUtils.setInBuffer(vector3f, triangleBatch.getNormalBuffer(), i);
        }
    }

    private void setVertexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        float f = 1.0f / FastMath.sqrt(3.0f);
        float f2 = FastMath.sqrt((3.0f - FastMath.sqrt(5.0f)) / 6.0f);
        float f3 = FastMath.sqrt((3.0f + FastMath.sqrt(5.0f)) / 6.0f);
        f *= this.sideLength;
        f2 *= this.sideLength;
        f3 *= this.sideLength;
        FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
        floatBuffer.rewind();
        floatBuffer.put(f).put(f).put(f);
        floatBuffer.put(f).put(f).put(-f);
        floatBuffer.put(f).put(-f).put(f);
        floatBuffer.put(f).put(-f).put(-f);
        floatBuffer.put(-f).put(f).put(f);
        floatBuffer.put(-f).put(f).put(-f);
        floatBuffer.put(-f).put(-f).put(f);
        floatBuffer.put(-f).put(-f).put(-f);
        floatBuffer.put(f2).put(f3).put(0.0f);
        floatBuffer.put(-f2).put(f3).put(0.0f);
        floatBuffer.put(f2).put(-f3).put(0.0f);
        floatBuffer.put(-f2).put(-f3).put(0.0f);
        floatBuffer.put(f3).put(0.0f).put(f2);
        floatBuffer.put(f3).put(0.0f).put(-f2);
        floatBuffer.put(-f3).put(0.0f).put(f2);
        floatBuffer.put(-f3).put(0.0f).put(-f2);
        floatBuffer.put(0.0f).put(f2).put(f3);
        floatBuffer.put(0.0f).put(-f2).put(f3);
        floatBuffer.put(0.0f).put(f2).put(-f3);
        floatBuffer.put(0.0f).put(-f2).put(-f3);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.sideLength, "sideLength", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.sideLength = inputCapsule.readInt("sideLength", 0);
    }
}

