/*
 * Decompiled with CFR 0.152.
 */
package com.jme.image.util;

import com.jme.image.Image;
import com.jme.math.FastMath;
import com.jme.renderer.ColorRGBA;
import com.jme.system.JmeException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ColorMipMapGenerator {
    public static Image generateColorMipMap(int n, ColorRGBA[] colorRGBAArray, ColorRGBA colorRGBA) {
        if (!FastMath.isPowerOfTwo(n)) {
            throw new JmeException("size must be power of two!");
        }
        int n2 = (int)(FastMath.log(n) / FastMath.log(2.0f)) + 1;
        Image image = new Image(3, n, n, null);
        int n3 = n * n * 4;
        int[] nArray = new int[n2];
        nArray[0] = n3;
        for (int i = 1; i < n2; ++i) {
            nArray[i] = nArray[i - 1] >> 1;
            n3 += nArray[i];
        }
        image.setMipMapSizes(nArray);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3).order(ByteOrder.nativeOrder());
        byteBuffer.clear();
        int[] nArray2 = new int[]{(int)(colorRGBA.r * 255.0f), (int)(colorRGBA.g * 255.0f), (int)(colorRGBA.b * 255.0f)};
        for (int i = 0; i < n2; ++i) {
            int n4 = nArray[i] >> 2;
            float f = (float)(n2 - i + colorRGBAArray.length) / (float)n2;
            for (int j = 0; j < n4; ++j) {
                if (i >= colorRGBAArray.length) {
                    byteBuffer.put((byte)((float)nArray2[0] * f));
                    byteBuffer.put((byte)((float)nArray2[1] * f));
                    byteBuffer.put((byte)((float)nArray2[2] * f));
                } else {
                    byteBuffer.put((byte)(colorRGBAArray[i].r * 255.0f));
                    byteBuffer.put((byte)(colorRGBAArray[i].g * 255.0f));
                    byteBuffer.put((byte)(colorRGBAArray[i].b * 255.0f));
                }
                byteBuffer.put((byte)-1);
            }
        }
        byteBuffer.rewind();
        image.setData(byteBuffer);
        return image;
    }
}

