/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.action.InputActionInterface;
import com.jme.input.action.KeyBackwardAction;
import com.jme.input.action.KeyForwardAction;
import com.jme.input.action.KeyLookDownAction;
import com.jme.input.action.KeyLookUpAction;
import com.jme.input.action.KeyRotateLeftAction;
import com.jme.input.action.KeyRotateRightAction;
import com.jme.input.action.KeyStrafeDownAction;
import com.jme.input.action.KeyStrafeLeftAction;
import com.jme.input.action.KeyStrafeRightAction;
import com.jme.input.action.KeyStrafeUpAction;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;

public class KeyboardLookHandler
extends InputHandler {
    private KeyForwardAction forward;
    private KeyBackwardAction backward;
    private KeyStrafeLeftAction sLeft;
    private KeyStrafeRightAction sRight;
    private KeyRotateRightAction right;
    private KeyRotateLeftAction left;
    private KeyStrafeDownAction down;
    private KeyStrafeUpAction up;
    private float moveSpeed;

    public KeyboardLookHandler(Camera camera, float f, float f2) {
        this.moveSpeed = f;
        KeyBindingManager keyBindingManager = KeyBindingManager.getKeyBindingManager();
        keyBindingManager.set("forward", 17);
        keyBindingManager.set("backward", 31);
        keyBindingManager.set("strafeLeft", 30);
        keyBindingManager.set("strafeRight", 32);
        keyBindingManager.set("lookUp", 200);
        keyBindingManager.set("lookDown", 208);
        keyBindingManager.set("turnRight", 205);
        keyBindingManager.set("turnLeft", 203);
        keyBindingManager.set("elevateUp", 16);
        keyBindingManager.set("elevateDown", 44);
        this.forward = new KeyForwardAction(camera, f);
        this.addAction((InputActionInterface)this.forward, "forward", true);
        this.backward = new KeyBackwardAction(camera, f);
        this.addAction((InputActionInterface)this.backward, "backward", true);
        this.sLeft = new KeyStrafeLeftAction(camera, f);
        this.addAction((InputActionInterface)this.sLeft, "strafeLeft", true);
        this.sRight = new KeyStrafeRightAction(camera, f);
        this.addAction((InputActionInterface)this.sRight, "strafeRight", true);
        this.addAction((InputActionInterface)new KeyLookUpAction(camera, f2), "lookUp", true);
        this.addAction((InputActionInterface)new KeyLookDownAction(camera, f2), "lookDown", true);
        this.down = new KeyStrafeDownAction(camera, f);
        Vector3f vector3f = new Vector3f(camera.getUp());
        this.down.setUpVector(vector3f);
        this.addAction((InputActionInterface)this.down, "elevateDown", true);
        this.up = new KeyStrafeUpAction(camera, f);
        this.up.setUpVector(vector3f);
        this.addAction((InputActionInterface)this.up, "elevateUp", true);
        this.right = new KeyRotateRightAction(camera, f2);
        this.right.setLockAxis(new Vector3f(camera.getUp()));
        this.addAction((InputActionInterface)this.right, "turnRight", true);
        this.left = new KeyRotateLeftAction(camera, f2);
        this.left.setLockAxis(new Vector3f(camera.getUp()));
        this.addAction((InputActionInterface)this.left, "turnLeft", true);
    }

    public void setLockAxis(Vector3f vector3f) {
        this.right.setLockAxis(new Vector3f(vector3f));
        this.left.setLockAxis(new Vector3f(vector3f));
    }

    public void setUpAxis(Vector3f vector3f) {
        this.up.setUpVector(vector3f);
        this.down.setUpVector(vector3f);
    }

    public float getMoveSpeed() {
        return this.moveSpeed;
    }

    public void setMoveSpeed(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.moveSpeed = f;
        this.forward.setSpeed(f);
        this.backward.setSpeed(f);
        this.sLeft.setSpeed(f);
        this.sRight.setSpeed(f);
        this.down.setSpeed(f);
        this.up.setSpeed(f);
    }
}

