/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.joystick.lwjgl;

import com.jme.input.joystick.Joystick;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.games.input.Controller;
import net.java.games.input.Rumbler;

class LWJGLJoystick
implements Joystick {
    private static final Logger logger = Logger.getLogger(LWJGLJoystick.class.getName());
    private org.lwjgl.input.Controller controller;
    private Rumbler[] rumblers;

    LWJGLJoystick(org.lwjgl.input.Controller controller) {
        this.controller = controller;
        try {
            Field field = controller.getClass().getDeclaredField("target");
            field.setAccessible(true);
            Controller controller2 = (Controller)field.get(controller);
            Rumbler[] rumblerArray = controller2.getRumblers();
            this.rumblers = new Rumbler[this.getAxisCount()];
            String[] stringArray = this.getAxisNames();
            for (int i = 0; i < rumblerArray.length; ++i) {
                Rumbler rumbler = rumblerArray[i];
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = stringArray[j];
                    if (!string.equals(rumbler.getAxisName())) continue;
                    this.rumblers[j] = rumbler;
                }
            }
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "LWJGLJoystick(Controller)", "Exception", exception);
        }
    }

    public void rumble(int n, float f) {
        Rumbler rumbler;
        if (this.rumblers != null && n < this.rumblers.length && (rumbler = this.rumblers[n]) != null) {
            rumbler.rumble(f);
        }
    }

    public String[] getAxisNames() {
        org.lwjgl.input.Controller controller = this.controller;
        String[] stringArray = new String[controller.getAxisCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = controller.getAxisName(i);
        }
        return stringArray;
    }

    public int getAxisCount() {
        return this.controller.getAxisCount();
    }

    public float getAxisValue(int n) {
        org.lwjgl.input.Controller controller = this.controller;
        if (n < controller.getAxisCount()) {
            return controller.getAxisValue(n);
        }
        return 0.0f;
    }

    public int getButtonCount() {
        return this.controller.getButtonCount();
    }

    public boolean isButtonPressed(int n) {
        org.lwjgl.input.Controller controller = this.controller;
        if (n < controller.getButtonCount()) {
            return controller.isButtonPressed(n);
        }
        return false;
    }

    public String getName() {
        return this.controller.getName();
    }

    public int findAxis(String string) {
        int n = 0;
        for (String string2 : this.getAxisNames()) {
            if (string.equalsIgnoreCase(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

