/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math.spring;

import com.jme.math.Vector3f;
import com.jme.math.spring.SpringPoint;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;

public class Spring
implements Savable {
    public SpringPoint node1;
    public SpringPoint node2;
    private float restLength = 1.0f;
    private float rlSquared = 1.0f;
    private float tMass = 1.0f;
    private Vector3f delta = new Vector3f();

    public Spring(SpringPoint springPoint, SpringPoint springPoint2, float f) {
        this.node1 = springPoint;
        this.node2 = springPoint2;
        this.setRestLength(f);
        this.updateTotalMassFromNodes();
    }

    public void setRestLength(float f) {
        this.restLength = f;
        this.rlSquared = f * f;
    }

    public float getRestLength() {
        return this.restLength;
    }

    public void updateTotalMassFromNodes() {
        this.tMass = 1.0f / (this.node1.invMass + this.node2.invMass);
    }

    public void update() {
        if (this.node1 == null || this.node2 == null) {
            return;
        }
        this.delta.set(this.node2.position).subtractLocal(this.node1.position);
        this.delta.multLocal(this.tMass - 2.0f * this.rlSquared * this.tMass / (this.delta.lengthSquared() + this.rlSquared));
        if (this.node1.invMass != 0.0f) {
            this.node1.position.addLocal(this.delta.x * this.node1.invMass, this.delta.y * this.node1.invMass, this.delta.z * this.node1.invMass);
        }
        if (this.node2.invMass != 0.0f) {
            this.node2.position.subtractLocal(this.delta.x * this.node2.invMass, this.delta.y * this.node2.invMass, this.delta.z * this.node2.invMass);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.node1, "node1", null);
        outputCapsule.write(this.node2, "node2", null);
        outputCapsule.write(this.restLength, "restLength", 0.0f);
        outputCapsule.write(this.tMass, "tMass", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.node1 = (SpringPoint)inputCapsule.readSavable("node1", null);
        this.node2 = (SpringPoint)inputCapsule.readSavable("node2", null);
        this.restLength = inputCapsule.readFloat("restLength", 0.0f);
        this.rlSquared = this.restLength * this.restLength;
        this.tMass = inputCapsule.readFloat("tMass", 0.0f);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

