/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math.spring;

import com.jme.math.Vector3f;
import com.jme.math.spring.Spring;
import com.jme.math.spring.SpringPoint;
import com.jme.math.spring.SpringPointForce;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class SpringSystem
implements Savable {
    protected ArrayList<SpringPoint> nodes = new ArrayList();
    protected ArrayList<Spring> springs = new ArrayList();
    private ArrayList<SpringPointForce> externalForces = new ArrayList();
    private int relaxLoops = 2;

    public SpringPoint getNode(int n) {
        return this.nodes.get(n);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public void addNode(SpringPoint springPoint) {
        this.nodes.add(springPoint);
    }

    public boolean removeNode(SpringPoint springPoint) {
        return this.nodes.remove(springPoint);
    }

    public Spring getSpring(int n) {
        return this.springs.get(n);
    }

    public int getSpringCount() {
        return this.springs.size();
    }

    public void addSpring(SpringPoint springPoint, SpringPoint springPoint2) {
        Spring spring = new Spring(springPoint, springPoint2, springPoint.position.distance(springPoint2.position));
        this.springs.add(spring);
    }

    public void addSpring(Spring spring) {
        this.springs.add(spring);
    }

    public boolean removeSpring(Spring spring) {
        return this.springs.remove(spring);
    }

    public void setRelaxLoops(int n) {
        this.relaxLoops = n;
    }

    public int getRelaxLoops() {
        return this.relaxLoops;
    }

    public void addForce(SpringPointForce springPointForce) {
        this.externalForces.add(springPointForce);
    }

    public boolean removeForce(SpringPointForce springPointForce) {
        return this.externalForces.remove(springPointForce);
    }

    public static SpringSystem createRectField(int n, int n2, FloatBuffer floatBuffer, float f) {
        SpringPoint springPoint;
        SpringSystem springSystem = new SpringSystem();
        floatBuffer.rewind();
        int n3 = 0;
        int n4 = floatBuffer.limit() / 3;
        while (n3 < n4) {
            springPoint = new SpringPoint(new Vector3f(floatBuffer.get(), floatBuffer.get(), floatBuffer.get()));
            springPoint.index = n3++;
            springPoint.setMass(f);
            springSystem.nodes.add(springPoint);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            for (n4 = 0; n4 < n; ++n4) {
                springPoint = springSystem.nodes.get(n3 * n + n4);
                if (n4 < n - 1) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get(n3 * n + (n4 + 1)));
                }
                if (n3 < n2 - 1) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get((n3 + 1) * n + n4));
                }
                if (n4 > 0) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get(n3 * n + (n4 - 1)));
                }
                if (n3 > 0) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get((n3 - 1) * n + n4));
                }
                if (n4 < n - 1 && n3 > 0) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get((n3 - 1) * n + (n4 + 1)));
                }
                if (n4 < n - 1 && n3 < n2 - 1) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get((n3 + 1) * n + (n4 + 1)));
                }
                if (n4 > 0 && n3 > 0) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get((n3 - 1) * n + (n4 - 1)));
                }
                if (n4 > 0 && n3 < n2 - 1) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get((n3 + 1) * n + (n4 - 1)));
                }
                if (n4 < n - 2) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get(n3 * n + (n4 + 2)));
                }
                if (n3 < n2 - 2) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get((n3 + 2) * n + n4));
                }
                if (n4 > 1) {
                    springSystem.addSpring(springPoint, springSystem.nodes.get(n3 * n + (n4 - 2)));
                }
                if (n3 <= 1) continue;
                springSystem.addSpring(springPoint, springSystem.nodes.get((n3 - 2) * n + n4));
            }
        }
        return springSystem;
    }

    public void calcForces(float f) {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            SpringPoint springPoint = this.nodes.get(i);
            springPoint.acceleration.zero();
            int n2 = this.externalForces.size();
            while (--n2 >= 0) {
                SpringPointForce springPointForce = this.externalForces.get(n2);
                if (!springPointForce.isEnabled()) continue;
                springPointForce.apply(f, springPoint);
            }
        }
    }

    public void update(float f) {
        Savable savable;
        int n;
        int n2 = this.nodes.size();
        for (n = 0; n < n2; ++n) {
            savable = this.nodes.get(n);
            ((SpringPoint)savable).update(f);
        }
        n2 = this.springs.size();
        for (n = 0; n < n2; ++n) {
            savable = this.springs.get(n);
            for (int i = 0; i < this.relaxLoops; ++i) {
                ((Spring)savable).update();
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.writeSavableArrayList(this.nodes, "nodes", new ArrayList());
        outputCapsule.writeSavableArrayList(this.springs, "springs", new ArrayList());
        outputCapsule.writeSavableArrayList(this.externalForces, "externalForces", new ArrayList());
        outputCapsule.write(this.relaxLoops, "relaxLoops", 2);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.nodes = inputCapsule.readSavableArrayList("nodes", new ArrayList());
        this.springs = inputCapsule.readSavableArrayList("springs", new ArrayList());
        this.externalForces = inputCapsule.readSavableArrayList("externalForces", new ArrayList());
        this.relaxLoops = inputCapsule.readInt("relaxLoops", 2);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

