/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer;

import com.jme.bounding.BoundingVolume;
import com.jme.math.FastMath;
import com.jme.math.Matrix4f;
import com.jme.math.Plane;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class AbstractCamera
implements Camera {
    private static final Logger logger = Logger.getLogger(AbstractCamera.class.getName());
    public static final int LEFT_PLANE = 0;
    public static final int RIGHT_PLANE = 1;
    public static final int BOTTOM_PLANE = 2;
    public static final int TOP_PLANE = 3;
    public static final int FAR_PLANE = 4;
    public static final int NEAR_PLANE = 5;
    public static final int FRUSTUM_PLANES = 6;
    public static final int MAX_WORLD_PLANES = 32;
    protected Vector3f location;
    protected Vector3f left;
    protected Vector3f up;
    protected Vector3f direction;
    protected float frustumNear;
    protected float frustumFar;
    protected float frustumLeft;
    protected float frustumRight;
    protected float frustumTop;
    protected float frustumBottom;
    protected float[] coeffLeft;
    protected float[] coeffRight;
    protected float[] coeffBottom;
    protected float[] coeffTop;
    protected int planeQuantity;
    protected float viewPortLeft;
    protected float viewPortRight;
    protected float viewPortTop;
    protected float viewPortBottom;
    protected Plane[] worldPlane;
    protected Vector3f newDirection = new Vector3f();
    private int planeState;
    protected int width;
    protected int height;
    protected transient Object parent;
    private boolean parallelProjection;
    private static final Quaternion tmp_quat = new Quaternion();
    private boolean updateMatrices = true;
    private boolean updateSMatrices = true;
    private final Matrix4f modelViewProjectionInverse = new Matrix4f();
    private final Matrix4f modelViewProjection = new Matrix4f();
    private boolean dataOnly;

    public AbstractCamera() {
        this(false);
    }

    public AbstractCamera(boolean bl) {
        this.setDataOnly(bl);
        this.location = new Vector3f();
        this.left = new Vector3f(1.0f, 0.0f, 0.0f);
        this.up = new Vector3f(0.0f, 1.0f, 0.0f);
        this.direction = new Vector3f(0.0f, 0.0f, 1.0f);
        this.frustumNear = 1.0f;
        this.frustumFar = 2.0f;
        this.frustumLeft = -0.5f;
        this.frustumRight = 0.5f;
        this.frustumTop = 0.5f;
        this.frustumBottom = -0.5f;
        this.coeffLeft = new float[2];
        this.coeffRight = new float[2];
        this.coeffBottom = new float[2];
        this.coeffTop = new float[2];
        this.viewPortLeft = 0.0f;
        this.viewPortRight = 1.0f;
        this.viewPortTop = 1.0f;
        this.viewPortBottom = 0.0f;
        this.planeQuantity = 6;
        this.worldPlane = new Plane[32];
        for (int i = 0; i < 32; ++i) {
            this.worldPlane[i] = new Plane();
        }
        this.onFrustumChange();
        this.onViewPortChange();
        this.onFrameChange();
        logger.info("Camera created.");
    }

    public float getFrustumBottom() {
        return this.frustumBottom;
    }

    public void setFrustumBottom(float f) {
        this.frustumBottom = f;
        this.onFrustumChange();
    }

    public float getFrustumFar() {
        return this.frustumFar;
    }

    public void setFrustumFar(float f) {
        this.frustumFar = f;
        this.onFrustumChange();
    }

    public float getFrustumLeft() {
        return this.frustumLeft;
    }

    public void setFrustumLeft(float f) {
        this.frustumLeft = f;
        this.onFrustumChange();
    }

    public float getFrustumNear() {
        return this.frustumNear;
    }

    public void setFrustumNear(float f) {
        this.frustumNear = f;
        this.onFrustumChange();
    }

    public float getFrustumRight() {
        return this.frustumRight;
    }

    public void setFrustumRight(float f) {
        this.frustumRight = f;
        this.onFrustumChange();
    }

    public float getFrustumTop() {
        return this.frustumTop;
    }

    public void setFrustumTop(float f) {
        this.frustumTop = f;
        this.onFrustumChange();
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public Vector3f getLeft() {
        return this.left;
    }

    public Vector3f getUp() {
        return this.up;
    }

    public void setLocation(Vector3f vector3f) {
        this.location = vector3f;
        this.onFrameChange();
    }

    public void setDirection(Vector3f vector3f) {
        this.direction = vector3f;
        this.onFrameChange();
    }

    public void setLeft(Vector3f vector3f) {
        this.left = vector3f;
        this.onFrameChange();
    }

    public void setUp(Vector3f vector3f) {
        this.up = vector3f;
        this.onFrameChange();
    }

    public void setAxes(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.left = vector3f;
        this.up = vector3f2;
        this.direction = vector3f3;
        this.onFrameChange();
    }

    public void setAxes(Quaternion quaternion) {
        this.left = quaternion.getRotationColumn(0, this.left);
        this.up = quaternion.getRotationColumn(1, this.up);
        this.direction = quaternion.getRotationColumn(2, this.direction);
        this.onFrameChange();
    }

    public void normalize() {
        this.left.normalizeLocal();
        this.up.normalizeLocal();
        this.direction.normalizeLocal();
    }

    public void setFrustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.frustumNear = f;
        this.frustumFar = f2;
        this.frustumLeft = f3;
        this.frustumRight = f4;
        this.frustumTop = f5;
        this.frustumBottom = f6;
        this.onFrustumChange();
    }

    public void setFrustumPerspective(float f, float f2, float f3, float f4) {
        float f5 = FastMath.tan(f * ((float)Math.PI / 180)) * f3 * 0.5f;
        float f6 = f5 * f2;
        this.frustumLeft = -f6;
        this.frustumRight = f6;
        this.frustumBottom = -f5;
        this.frustumTop = f5;
        this.frustumNear = f3;
        this.frustumFar = f4;
        this.onFrustumChange();
    }

    public void setFrame(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        this.location = vector3f;
        this.left = vector3f2;
        this.up = vector3f3;
        this.direction = vector3f4;
        this.onFrameChange();
    }

    public void lookAt(Vector3f vector3f, Vector3f vector3f2) {
        this.newDirection.set(vector3f).subtractLocal(this.location).normalizeLocal();
        if (this.newDirection.equals(this.direction)) {
            return;
        }
        this.direction.set(this.newDirection);
        this.up.set(vector3f2).normalizeLocal();
        if (this.up.equals(Vector3f.ZERO)) {
            this.up.set(Vector3f.UNIT_Y);
        }
        this.left.set(this.up).crossLocal(this.direction).normalizeLocal();
        if (this.left.equals(Vector3f.ZERO)) {
            if (this.direction.x != 0.0f) {
                this.left.set(this.direction.y, -this.direction.x, 0.0f);
            } else {
                this.left.set(0.0f, this.direction.z, -this.direction.y);
            }
        }
        this.up.set(this.direction).crossLocal(this.left).normalizeLocal();
        this.onFrameChange();
    }

    public void setFrame(Vector3f vector3f, Quaternion quaternion) {
        this.location = vector3f;
        this.left = quaternion.getRotationColumn(0, this.left);
        this.up = quaternion.getRotationColumn(1, this.up);
        this.direction = quaternion.getRotationColumn(2, this.direction);
        this.onFrameChange();
    }

    public void update() {
        this.onFrustumChange();
        this.onViewPortChange();
        this.onFrameChange();
    }

    public int getPlaneState() {
        return this.planeState;
    }

    public void setPlaneState(int n) {
        this.planeState = n;
    }

    public float getViewPortLeft() {
        return this.viewPortLeft;
    }

    public void setViewPortLeft(float f) {
        this.viewPortLeft = f;
    }

    public float getViewPortRight() {
        return this.viewPortRight;
    }

    public void setViewPortRight(float f) {
        this.viewPortRight = f;
    }

    public float getViewPortTop() {
        return this.viewPortTop;
    }

    public void setViewPortTop(float f) {
        this.viewPortTop = f;
    }

    public float getViewPortBottom() {
        return this.viewPortBottom;
    }

    public void setViewPortBottom(float f) {
        this.viewPortBottom = f;
    }

    public void setViewPort(float f, float f2, float f3, float f4) {
        this.setViewPortLeft(f);
        this.setViewPortRight(f2);
        this.setViewPortBottom(f3);
        this.setViewPortTop(f4);
    }

    public int contains(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return 2;
        }
        int n = 2;
        for (int i = 6; i >= 0; --i) {
            int n2;
            int n3;
            if (i == boundingVolume.getCheckPlane() || (this.planeState & (n3 = 1 << (n2 = i == 6 ? boundingVolume.getCheckPlane() : i))) != 0) continue;
            int n4 = boundingVolume.whichSide(this.worldPlane[n2]);
            if (n4 == 2) {
                boundingVolume.setCheckPlane(n2);
                return 0;
            }
            if (n4 == 1) {
                this.planeState |= n3;
                continue;
            }
            n = 1;
        }
        return n;
    }

    public void onFrustumChange() {
        if (!this.isParallelProjection()) {
            float f = this.frustumNear * this.frustumNear;
            float f2 = this.frustumLeft * this.frustumLeft;
            float f3 = this.frustumRight * this.frustumRight;
            float f4 = this.frustumBottom * this.frustumBottom;
            float f5 = this.frustumTop * this.frustumTop;
            float f6 = FastMath.invSqrt(f + f2);
            this.coeffLeft[0] = this.frustumNear * f6;
            this.coeffLeft[1] = -this.frustumLeft * f6;
            f6 = FastMath.invSqrt(f + f3);
            this.coeffRight[0] = -this.frustumNear * f6;
            this.coeffRight[1] = this.frustumRight * f6;
            f6 = FastMath.invSqrt(f + f4);
            this.coeffBottom[0] = this.frustumNear * f6;
            this.coeffBottom[1] = -this.frustumBottom * f6;
            f6 = FastMath.invSqrt(f + f5);
            this.coeffTop[0] = -this.frustumNear * f6;
            this.coeffTop[1] = this.frustumTop * f6;
        } else {
            this.coeffLeft[0] = 1.0f;
            this.coeffLeft[1] = 0.0f;
            this.coeffRight[0] = -1.0f;
            this.coeffRight[1] = 0.0f;
            this.coeffBottom[0] = 1.0f;
            this.coeffBottom[1] = 0.0f;
            this.coeffTop[0] = -1.0f;
            this.coeffTop[1] = 0.0f;
        }
        this.updateMatrices = true;
    }

    public void onFrameChange() {
        float f = this.direction.dot(this.location);
        Vector3f vector3f = this.worldPlane[0].normal;
        vector3f.x = this.left.x * this.coeffLeft[0];
        vector3f.y = this.left.y * this.coeffLeft[0];
        vector3f.z = this.left.z * this.coeffLeft[0];
        vector3f.addLocal(this.direction.x * this.coeffLeft[1], this.direction.y * this.coeffLeft[1], this.direction.z * this.coeffLeft[1]);
        this.worldPlane[0].setConstant(this.location.dot(vector3f));
        Vector3f vector3f2 = this.worldPlane[1].normal;
        vector3f2.x = this.left.x * this.coeffRight[0];
        vector3f2.y = this.left.y * this.coeffRight[0];
        vector3f2.z = this.left.z * this.coeffRight[0];
        vector3f2.addLocal(this.direction.x * this.coeffRight[1], this.direction.y * this.coeffRight[1], this.direction.z * this.coeffRight[1]);
        this.worldPlane[1].setConstant(this.location.dot(vector3f2));
        Vector3f vector3f3 = this.worldPlane[2].normal;
        vector3f3.x = this.up.x * this.coeffBottom[0];
        vector3f3.y = this.up.y * this.coeffBottom[0];
        vector3f3.z = this.up.z * this.coeffBottom[0];
        vector3f3.addLocal(this.direction.x * this.coeffBottom[1], this.direction.y * this.coeffBottom[1], this.direction.z * this.coeffBottom[1]);
        this.worldPlane[2].setConstant(this.location.dot(vector3f3));
        Vector3f vector3f4 = this.worldPlane[3].normal;
        vector3f4.x = this.up.x * this.coeffTop[0];
        vector3f4.y = this.up.y * this.coeffTop[0];
        vector3f4.z = this.up.z * this.coeffTop[0];
        vector3f4.addLocal(this.direction.x * this.coeffTop[1], this.direction.y * this.coeffTop[1], this.direction.z * this.coeffTop[1]);
        this.worldPlane[3].setConstant(this.location.dot(vector3f4));
        if (this.isParallelProjection()) {
            this.worldPlane[0].setConstant(this.worldPlane[0].getConstant() + this.frustumLeft);
            this.worldPlane[1].setConstant(this.worldPlane[1].getConstant() - this.frustumRight);
            this.worldPlane[3].setConstant(this.worldPlane[3].getConstant() + this.frustumTop);
            this.worldPlane[2].setConstant(this.worldPlane[2].getConstant() - this.frustumBottom);
        }
        this.worldPlane[4].normal.set(-this.direction.x, -this.direction.y, -this.direction.z);
        this.worldPlane[4].setConstant(-(f + this.frustumFar));
        this.worldPlane[5].normal.set(this.direction.x, this.direction.y, this.direction.z);
        this.worldPlane[5].setConstant(f + this.frustumNear);
        this.updateMatrices = true;
        this.updateSMatrices = true;
    }

    public boolean isParallelProjection() {
        return this.parallelProjection;
    }

    public void setParallelProjection(boolean bl) {
        this.parallelProjection = bl;
    }

    public Vector3f getWorldCoordinates(Vector2f vector2f, float f) {
        return this.getWorldCoordinates(vector2f, f, null);
    }

    public abstract Matrix4f getProjectionMatrix();

    public abstract Matrix4f getModelViewMatrix();

    public Vector3f getWorldCoordinates(Vector2f vector2f, float f, Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        this.checkViewProjection();
        if (this.updateMatrices) {
            this.modelViewProjection.invert(this.modelViewProjectionInverse);
            this.updateMatrices = false;
        }
        tmp_quat.set((vector2f.x / (float)this.getWidth() - this.viewPortLeft) / (this.viewPortRight - this.viewPortLeft) * 2.0f - 1.0f, (vector2f.y / (float)this.getHeight() - this.viewPortBottom) / (this.viewPortTop - this.viewPortBottom) * 2.0f - 1.0f, f * 2.0f - 1.0f, 1.0f);
        this.modelViewProjectionInverse.mult(tmp_quat, tmp_quat);
        tmp_quat.multLocal(1.0f / AbstractCamera.tmp_quat.w);
        vector3f.x = AbstractCamera.tmp_quat.x;
        vector3f.y = AbstractCamera.tmp_quat.y;
        vector3f.z = AbstractCamera.tmp_quat.z;
        return vector3f;
    }

    public Vector3f getScreenCoordinates(Vector3f vector3f) {
        return this.getScreenCoordinates(vector3f, null);
    }

    public Vector3f getScreenCoordinates(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        this.checkViewProjection();
        tmp_quat.set(vector3f.x, vector3f.y, vector3f.z, 1.0f);
        this.modelViewProjection.mult(tmp_quat, tmp_quat);
        tmp_quat.multLocal(1.0f / AbstractCamera.tmp_quat.w);
        vector3f2.x = ((AbstractCamera.tmp_quat.x + 1.0f) * (this.viewPortRight - this.viewPortLeft) / 2.0f + this.viewPortLeft) * (float)this.getWidth();
        vector3f2.y = ((AbstractCamera.tmp_quat.y + 1.0f) * (this.viewPortTop - this.viewPortBottom) / 2.0f + this.viewPortBottom) * (float)this.getHeight();
        vector3f2.z = (AbstractCamera.tmp_quat.z + 1.0f) / 2.0f;
        return vector3f2;
    }

    private void checkViewProjection() {
        if (this.updateSMatrices) {
            this.modelViewProjection.set(this.getModelViewMatrix()).multLocal(this.getProjectionMatrix());
            this.updateSMatrices = false;
        }
    }

    public abstract int getHeight();

    public abstract int getWidth();

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.location, "location", Vector3f.ZERO);
        outputCapsule.write(this.left, "left", Vector3f.UNIT_X);
        outputCapsule.write(this.up, "up", Vector3f.UNIT_Y);
        outputCapsule.write(this.direction, "direction", Vector3f.UNIT_Z);
        outputCapsule.write(this.frustumNear, "frustumNear", 1.0f);
        outputCapsule.write(this.frustumFar, "frustumFar", 2.0f);
        outputCapsule.write(this.frustumLeft, "frustumLeft", -0.5f);
        outputCapsule.write(this.frustumRight, "frustumRight", 0.5f);
        outputCapsule.write(this.frustumTop, "frustumTop", 0.5f);
        outputCapsule.write(this.frustumBottom, "frustumBottom", -0.5f);
        outputCapsule.write(this.coeffLeft, "coeffLeft", new float[2]);
        outputCapsule.write(this.coeffRight, "coeffRight", new float[2]);
        outputCapsule.write(this.coeffBottom, "coeffBottom", new float[2]);
        outputCapsule.write(this.coeffTop, "coeffTop", new float[2]);
        outputCapsule.write(this.planeQuantity, "planeQuantity", 6);
        outputCapsule.write(this.viewPortLeft, "viewPortLeft", 0.0f);
        outputCapsule.write(this.viewPortRight, "viewPortRight", 1.0f);
        outputCapsule.write(this.viewPortTop, "viewPortTop", 1.0f);
        outputCapsule.write(this.viewPortBottom, "viewPortBottom", 0.0f);
        outputCapsule.write(this.width, "width", 0);
        outputCapsule.write(this.height, "height", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.location = (Vector3f)inputCapsule.readSavable("location", Vector3f.ZERO.clone());
        this.left = (Vector3f)inputCapsule.readSavable("left", Vector3f.UNIT_X.clone());
        this.up = (Vector3f)inputCapsule.readSavable("up", Vector3f.UNIT_Y.clone());
        this.direction = (Vector3f)inputCapsule.readSavable("direction", Vector3f.UNIT_Z.clone());
        this.frustumNear = inputCapsule.readFloat("frustumNear", 1.0f);
        this.frustumFar = inputCapsule.readFloat("frustumFar", 2.0f);
        this.frustumLeft = inputCapsule.readFloat("frustumLeft", -0.5f);
        this.frustumRight = inputCapsule.readFloat("frustumRight", 0.5f);
        this.frustumTop = inputCapsule.readFloat("frustumTop", 0.5f);
        this.frustumBottom = inputCapsule.readFloat("frustumBottom", -0.5f);
        this.coeffLeft = inputCapsule.readFloatArray("coeffLeft", new float[2]);
        this.coeffRight = inputCapsule.readFloatArray("coeffRight", new float[2]);
        this.coeffBottom = inputCapsule.readFloatArray("coeffBottom", new float[2]);
        this.coeffTop = inputCapsule.readFloatArray("coeffTop", new float[2]);
        this.planeQuantity = inputCapsule.readInt("planeQuantity", 6);
        this.viewPortLeft = inputCapsule.readFloat("viewPortLeft", 0.0f);
        this.viewPortRight = inputCapsule.readFloat("viewPortRight", 1.0f);
        this.viewPortTop = inputCapsule.readFloat("viewPortTop", 1.0f);
        this.viewPortBottom = inputCapsule.readFloat("viewPortBottom", 0.0f);
        this.width = inputCapsule.readInt("width", 0);
        this.height = inputCapsule.readInt("height", 0);
    }

    public Class getClassTag() {
        return AbstractCamera.class;
    }

    public void setDataOnly(boolean bl) {
        this.dataOnly = bl;
    }

    public boolean isDataOnly() {
        return this.dataOnly;
    }
}

