/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer;

import com.jme.renderer.Renderer;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.lwjgl.records.StateRecord;

public class RenderContext {
    public RenderState[] enforcedStateList = new RenderState[17];
    public RenderState[] currentStates = new RenderState[17];
    StateRecord[] stateRecords = new StateRecord[17];
    StateRecord lineRecord = null;
    StateRecord rendererRecord = null;

    public void setupRecords(Renderer renderer) {
        for (int i = 0; i < 17; ++i) {
            this.stateRecords[i] = renderer.createState(i).createStateRecord();
        }
        this.lineRecord = renderer.createLineRecord();
        this.rendererRecord = renderer.createRendererRecord();
    }

    public void invalidateStates() {
        for (int i = 0; i < 17; ++i) {
            this.stateRecords[i].invalidate();
        }
        this.lineRecord.invalidate();
        this.rendererRecord.invalidate();
        this.clearCurrentStates();
    }

    public StateRecord getStateRecord(int n) {
        return this.stateRecords[n];
    }

    public StateRecord getLineRecord() {
        return this.lineRecord;
    }

    public StateRecord getRendererRecord() {
        return this.rendererRecord;
    }

    public void enforceState(RenderState renderState) {
        this.enforcedStateList[renderState.getType()] = renderState;
    }

    public void clearEnforcedState(int n) {
        if (this.enforcedStateList != null) {
            this.enforcedStateList[n] = null;
        }
    }

    public void clearEnforcedStates() {
        for (int i = 0; i < this.enforcedStateList.length; ++i) {
            this.enforcedStateList[i] = null;
        }
    }

    public void clearCurrentStates() {
        for (int i = 0; i < this.currentStates.length; ++i) {
            this.currentStates[i] = null;
        }
    }

    public void clearCurrentState(int n) {
        this.currentStates[n] = null;
    }

    public RenderState getCurrentState(int n) {
        return this.currentStates[n];
    }
}

