/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.intersection.CollisionResults;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.batch.GeomBatch;
import java.io.Serializable;

public class BatchMesh
extends Geometry
implements Serializable {
    private static final long serialVersionUID = 7639644164611314728L;

    public BatchMesh() {
    }

    public BatchMesh(String string) {
        super(string);
    }

    public BatchMesh(String string, GeomBatch ... geomBatchArray) {
        super(string);
        if (geomBatchArray != null && geomBatchArray.length > 0) {
            this.setupBatchList(geomBatchArray);
        }
    }

    protected void setupBatchList(GeomBatch[] geomBatchArray) {
        this.removeBatch(0);
        this.batchList.ensureCapacity(geomBatchArray.length);
        for (GeomBatch geomBatch : geomBatchArray) {
            this.addBatch(geomBatch);
        }
    }

    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
        if (this == spatial || !this.isCollidable || !spatial.isCollidable()) {
            return;
        }
        if (this.getWorldBound().intersects(spatial.getWorldBound())) {
            if ((spatial.getType() & 1) != 0) {
                Node node = (Node)spatial;
                for (int i = 0; i < node.getQuantity(); ++i) {
                    this.findCollisions(node.getChild(i), collisionResults);
                }
            } else {
                collisionResults.addCollision(this, (Geometry)spatial);
            }
        }
    }

    public boolean hasCollision(Spatial spatial, boolean bl) {
        if (this == spatial || !this.isCollidable || !spatial.isCollidable()) {
            return false;
        }
        if (this.getWorldBound().intersects(spatial.getWorldBound())) {
            if ((spatial.getType() & 1) != 0) {
                Node node = (Node)spatial;
                for (int i = 0; i < node.getQuantity(); ++i) {
                    if (!this.hasCollision(node.getChild(i), bl)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void draw(Renderer renderer) {
        if (this.getBatchCount() == 1) {
            GeomBatch geomBatch = this.getBatch(0);
            if (geomBatch != null && geomBatch.isEnabled()) {
                geomBatch.setLastFrustumIntersection(this.frustrumIntersects);
                geomBatch.draw(renderer);
            }
            return;
        }
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            GeomBatch geomBatch = this.getBatch(i);
            if (geomBatch == null || !geomBatch.isEnabled()) continue;
            geomBatch.onDraw(renderer);
        }
    }
}

